/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.module;

import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.module.GlobalPermissionMetaDataListener;
import com.elluminate.groupware.module.PermissionFeatureDebug;
import com.elluminate.groupware.module.PermissionMetaDataListener;
import com.elluminate.util.I18n;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

@Singleton
public class PermissionFeatureFactory {
    private static final String GLOBAL = "Global";
    private Imps imps;
    private FeatureBroker broker;
    private CRSession session;
    private GlobalPermissionMetaDataListener globalPermissionMetaDataListener;
    private Object lock = new Object();

    @Inject
    protected void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    protected void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
    }

    @Inject
    protected void initGlobalPermissionMetaDataListener(GlobalPermissionMetaDataListener globalPermissionMetaDataListener) {
        this.globalPermissionMetaDataListener = globalPermissionMetaDataListener;
    }

    public BooleanFeature createParticipantPermissionFeature(Object owner, String permissionName, String path, String name, String prefixIconName, I18n i18n) {
        boolean supportBridgeParticipant = false;
        return this.createPermissionFeature(owner, permissionName, path, name, prefixIconName, i18n, Boolean.FALSE, supportBridgeParticipant);
    }

    public BooleanFeature createPermissionFeature(Object owner, String permissionName, String path, String name, String prefixIconName, I18n i18n) {
        boolean supportBridgeParticipant = false;
        return this.createPermissionFeature(owner, permissionName, path, name, prefixIconName, i18n, Boolean.TRUE, supportBridgeParticipant);
    }

    public BooleanFeature createBridgeFriendlyPermissionFeature(Object owner, String permissionName, String path, String name, String prefixIconName, I18n i18n) {
        boolean supportBridgeParticipant = true;
        return this.createPermissionFeature(owner, permissionName, path, name, prefixIconName, i18n, Boolean.TRUE, supportBridgeParticipant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BooleanFeature createPermissionFeature(Object owner, String permissionName, String path, String name, String prefixIconName, I18n i18n, boolean includesGlobalPerm, boolean supportsBridgeParticipant) {
        BooleanFeature booleanFeature = null;
        Object object = this.lock;
        synchronized (object) {
            Image imageIconOff;
            Image imageIcon = this.getImage(i18n, prefixIconName);
            Image imageIconOn = this.getImage(i18n, prefixIconName + ".permissionGrantedIcon");
            if (imageIconOn == null) {
                imageIconOn = imageIcon;
            }
            if ((imageIconOff = this.getImage(i18n, prefixIconName + ".permissionRevokedIcon")) == null) {
                imageIconOff = imageIcon;
            }
            imageIconOff = imageIconOn;
            booleanFeature = this.broker.createBooleanFeature(owner, path, true, false, name, name);
            booleanFeature.setTrueText(name);
            booleanFeature.setFalseText(name);
            booleanFeature.setTrueIcon(imageIconOn);
            booleanFeature.setFalseIcon(imageIconOff);
            this.broker.setFeaturePublished((Feature)booleanFeature, false);
            if (PermissionFeatureDebug.TRACE.show()) {
                LogSupport.message((Object)this, (String)"createPermissionFeature", (String)("created permission " + permissionName + " " + path + " " + name + " " + imageIconOn));
            }
            PermissionMetaDataListener permissionMetaDataListener = new PermissionMetaDataListener(permissionName, booleanFeature);
            permissionMetaDataListener.initFeatureBroker(this.broker);
            permissionMetaDataListener.initImps(this.imps);
            permissionMetaDataListener.supportsBridge(supportsBridgeParticipant);
            permissionMetaDataListener.initSession(this.session);
            if (includesGlobalPerm) {
                this.createGlobalPermissionFeature(owner, permissionName, path, name, imageIconOn, imageIconOff);
            }
        }
        return booleanFeature;
    }

    private BooleanFeature createGlobalPermissionFeature(Object owner, String permissionName, String path, String name, Image imageIconOn, Image imageIconOff) {
        path = path + GLOBAL;
        BooleanFeature booleanFeature = this.broker.createBooleanFeature(owner, path, true, false, name, name);
        booleanFeature.setTrueText(name);
        booleanFeature.setFalseText(name);
        booleanFeature.setTrueIcon(imageIconOn);
        booleanFeature.setFalseIcon(imageIconOff);
        this.broker.setFeaturePublished((Feature)booleanFeature, false);
        if (PermissionFeatureDebug.TRACE_GLOBAL.show()) {
            LogSupport.message((Object)this, (String)"createGlobalPermissionFeature", (String)("created global permission " + permissionName + " " + path + " " + name + " " + imageIconOn + " " + imageIconOff));
        }
        this.globalPermissionMetaDataListener.addGlobalPermission(permissionName, booleanFeature);
        return booleanFeature;
    }

    private Image getImage(I18n i18n, String iconName) {
        Image image = null;
        Icon icon = UIManager.getIcon(iconName);
        if (icon != null) {
            image = this.iconToImage(icon);
        }
        if (image == null) {
            try {
                image = i18n.getImage(iconName);
            }
            catch (Exception e) {
                image = null;
            }
        }
        return image;
    }

    private Image iconToImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }
}

