/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.module;

import com.elluminate.groupware.GroupwareDebug;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.JinxProtocolChnl;
import com.elluminate.jinx.JinxProtocolProp;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import java.beans.PropertyChangeListener;

public class JinxTerminal {
    protected Client client = null;
    protected ClientList clients = new ClientList(null);
    private ClientProvider clientProvider = null;
    private JinxProtocol protocol = null;
    private Channel[] channels = null;

    @Inject
    public void initClientProvider(ClientProvider clProvider) {
        this.clientProvider = clProvider;
    }

    public void initProtocol(JinxProtocol proto) {
        this.protocol = proto;
    }

    private void finishClientInitialization() {
        if (this.clientProvider != null) {
            this.client = this.clientProvider.get();
            if (this.client != null) {
                this.clients = this.client.getClientList();
                this.clientProvider = null;
            }
        }
    }

    protected void applyProtocol() {
        if (this.channels != null) {
            for (int i = 0; i < this.channels.length; ++i) {
                this.channels[i].setProtocol(this.protocol);
            }
        }
    }

    public void setClient(Client theClient) {
    }

    public boolean isPlayback() {
        this.finishClientInitialization();
        if (this.client == null) {
            return false;
        }
        return this.client.isPlayback();
    }

    public Client getClient() {
        this.finishClientInitialization();
        return this.client;
    }

    public ClientList getClientList() {
        this.finishClientInitialization();
        return this.clients;
    }

    public void setProtocol(JinxProtocol proto) {
        this.protocol = proto;
    }

    public void setProtocolAndListeners(JinxProtocol proto, ChannelListener cLst, ChannelDataListener dLst, PropertyChangeListener pLst) {
        this.protocol = proto;
        if (pLst != null) {
            this.addProtocolPropertyListeners(pLst);
        }
        this.createChannels(cLst, dLst);
    }

    public void addProtocolPropertyListeners(PropertyChangeListener pLst) {
        this.finishClientInitialization();
        if (pLst != null) {
            for (JinxProtocolProp p : this.protocol.getProperties()) {
                this.clients.addPropertyChangeListener(p.getName(), p.getScope(), pLst);
            }
        }
    }

    public void removeProtocolPropertyListeners(PropertyChangeListener pLst) {
        this.finishClientInitialization();
        if (pLst != null) {
            for (JinxProtocolProp p : this.protocol.getProperties()) {
                this.clients.removePropertyChangeListener(p.getName(), p.getScope(), pLst);
            }
        }
    }

    public void createChannels(ChannelListener cLst, ChannelDataListener dLst) {
        this.finishClientInitialization();
        for (JinxProtocolChnl c : this.protocol.getChannels()) {
            this.addChannel(c.getName(), c.getPriority(), cLst, dLst);
        }
    }

    private int addChannel(String name, byte priority, ChannelListener cLst, ChannelDataListener dLst) {
        try {
            Channel[] tmp;
            int chnl;
            if (this.channels != null) {
                chnl = this.channels.length;
                tmp = new Channel[this.channels.length + 1];
                System.arraycopy(this.channels, 0, tmp, 0, this.channels.length);
            } else {
                chnl = 0;
                tmp = new Channel[1];
            }
            tmp[chnl] = this.client.acquireChannel(name, priority, cLst, dLst);
            if (this.protocol != null) {
                tmp[chnl].setProtocol(this.protocol);
            }
            this.channels = tmp;
            return chnl;
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"addChannel", (Throwable)ex, (boolean)true);
            return -1;
        }
    }

    public Channel getChannel() {
        return this.channels[0];
    }

    public Channel getChannel(int which) {
        return this.channels[which];
    }

    public void fireChannelData(ChannelDataEvent anEvent) {
        this.fireChannelData(0, anEvent, true, (byte)0);
    }

    public void fireChannelData(int which, ChannelDataEvent anEvent) {
        this.fireChannelData(which, anEvent, true, (byte)0);
    }

    public void fireChannelData(ChannelDataEvent e, boolean catchExceptions) {
        this.fireChannelData(0, e, catchExceptions, (byte)0);
    }

    public void fireChannelData(int which, ChannelDataEvent e, boolean catchExceptions) {
        this.fireChannelData(which, e, catchExceptions, (byte)0);
    }

    public void fireChannelData(int which, ChannelDataEvent e, boolean catchExceptions, byte urgency) {
        if (this.channels == null) {
            throw new IllegalStateException("Channels not yet open");
        }
        if (this.channels[which] != null) {
            if (catchExceptions) {
                try {
                    this.channels[which].onChannelData(e, urgency);
                }
                catch (IllegalStateException ex) {
                    if (GroupwareDebug.EVENTS.show()) {
                        LogSupport.exception((Object)this, (String)"fireChannelData", (Throwable)ex, (boolean)false);
                    }
                    e.dispose();
                }
                catch (Exception ex) {
                    LogSupport.exception((Object)this, (String)"fireChanelData", (Throwable)ex, (boolean)true);
                }
            } else {
                this.channels[which].onChannelData(e, urgency);
            }
        } else {
            if (GroupwareDebug.EVENTS.show()) {
                LogSupport.message((Object)this, (String)"fireChannelData", (String)"No ChannelData listener.");
            }
            e.dispose();
        }
    }
}

