/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.module;

import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRPermission;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.CRPermissionChangeListener;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEvent;
import com.elluminate.groupware.module.PermissionFeatureDebug;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@Singleton
public class GlobalPermissionMetaDataListener
implements MetaDataListener,
CRPermissionChangeListener {
    private Map<BooleanFeature, String> permissionNameMap = new HashMap<BooleanFeature, String>();
    private ThreadLocal<Boolean> remoteEventThreadLocal = new ThreadLocal();
    private CRSession session;
    private FeatureBroker broker;

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initSession(CRSession session) {
        this.session = session;
        if (session != null) {
            session.addPermissionChangeListener("ChairPermission", (CRPermissionChangeListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGlobalPermission(String permissionName, BooleanFeature booleanFeature) {
        Map<BooleanFeature, String> map = this.permissionNameMap;
        synchronized (map) {
            if (booleanFeature != null) {
                if (PermissionFeatureDebug.TRACE_GLOBAL.show()) {
                    LogSupport.message((Object)this, (String)"addGlobalPermission", (String)("add " + permissionName));
                }
                booleanFeature.addMetaDataListener((MetaDataListener)this);
                this.session.addPermissionChangeListener(permissionName, (CRPermissionChangeListener)this);
                this.permissionNameMap.put(booleanFeature, permissionName);
            }
        }
    }

    public synchronized void metaDataChanged(MetaDataEvent event) {
        if (PermissionFeatureDebug.TRACE_GLOBAL.show()) {
            LogSupport.message((Object)this, (String)"metaDataChanged", (String)("thread=" + Thread.currentThread().getName()));
        }
        BooleanFeature booleanFeature = (BooleanFeature)event.getSource();
        Object oldValueObject = event.getOldValue();
        Object newValueObject = event.getNewValue();
        if (!(newValueObject instanceof Boolean)) {
            return;
        }
        Boolean isRemoteEvent = this.remoteEventThreadLocal.get();
        if (PermissionFeatureDebug.TRACE_GLOBAL.show()) {
            LogSupport.message((Object)this, (String)"metaDataChanged", (String)("isRemoteEvent = " + isRemoteEvent));
        }
        if (isRemoteEvent != null && isRemoteEvent.booleanValue()) {
            return;
        }
        this.remoteEventThreadLocal.set(false);
        Boolean oldValue = (Boolean)oldValueObject;
        Boolean newValue = (Boolean)newValueObject;
        if (PermissionFeatureDebug.TRACE_GLOBAL.show()) {
            LogSupport.message((Object)this, (String)"metaDataChanged", (String)("oldValue:" + oldValue + " newValue:" + newValue + " source = " + booleanFeature));
        }
        if (this.session.getNumberOfParticipants() > 0) {
            String permissionName = this.permissionNameMap.get(booleanFeature);
            CRParticipant me = this.session.getMe();
            Iterator itr = this.session.getParticipantIterator();
            while (me != null && itr.hasNext()) {
                CRParticipant participant = (CRParticipant)itr.next();
                if (participant == null) continue;
                CRPermission p = this.session.getPermission(permissionName, participant.getID());
                if (!me.isChair() || p == null || participant.isMe()) continue;
                if (newValue.booleanValue() != p.getDefault()) {
                    p.setDefault(newValue.booleanValue());
                }
                if (newValue.booleanValue() == p.getValue()) continue;
                if (PermissionFeatureDebug.TRACE_GLOBAL.show()) {
                    LogSupport.message((Object)this, (String)"metaDataChanged", (String)("[" + permissionName + "] newValue:" + newValue + ", permisson: " + p.getID() + " " + p.getValue() + " " + p.getDefault()));
                }
                if (participant.isChair()) continue;
                this.session.setPermissionValue(permissionName, participant.getID(), newValue.booleanValue());
            }
        }
        this.remoteEventThreadLocal.remove();
    }

    private synchronized void updateFeatures(CRPermission modifedPermission) {
        boolean isChair;
        if (PermissionFeatureDebug.TRACE_GLOBAL.show()) {
            LogSupport.message((Object)this, (String)"updateFeatures", (String)("updating " + this.permissionNameMap.size() + " permissions"));
        }
        if (this.permissionNameMap.size() == 0) {
            return;
        }
        boolean bl = isChair = this.session != null && this.session.getMe() != null ? this.session.getMe().isChair() : false;
        if (PermissionFeatureDebug.TRACE_GLOBAL.show()) {
            LogSupport.message((Object)this, (String)"updateFeatures", (String)("isChair = " + isChair + " modifedPermission = " + modifedPermission));
        }
        for (Map.Entry<BooleanFeature, String> entry : this.permissionNameMap.entrySet()) {
            BooleanFeature booleanFeature = entry.getKey();
            String permissionName = entry.getValue();
            LightweightTimer timer = null;
            CRPermission permission = null;
            Boolean hasPermission = null;
            boolean isEnabled = false;
            boolean isChairPermission = modifedPermission.getName().equals("ChairPermission");
            if (!isChairPermission && !modifedPermission.getName().equals(permissionName)) continue;
            if (this.session.getNumberOfParticipants() > 0) {
                isEnabled = true;
                Iterator itr = this.session.getParticipantIterator();
                while (itr.hasNext()) {
                    CRParticipant participant;
                    block11: {
                        participant = (CRParticipant)itr.next();
                        if (participant == null || participant.getName().startsWith(" ")) continue;
                        try {
                            permission = this.session.getPermission(permissionName, participant.getID());
                        }
                        catch (Exception e) {
                            permission = null;
                            if (timer != null) break block11;
                            UpdateGlobalPermissionsTask task = new UpdateGlobalPermissionsTask(modifedPermission);
                            timer = new LightweightTimer(2, (Runnable)task);
                            task.setTimer(timer);
                        }
                    }
                    if (PermissionFeatureDebug.TRACE_GLOBAL.show()) {
                        LogSupport.message((Object)this, (String)"updateFeatures", (String)("[" + permissionName + "] " + participant.getDisplayName() + " " + permission));
                    }
                    if (permission == null) continue;
                    hasPermission = permission.getDefault();
                    break;
                }
            }
            if (timer != null) {
                timer.scheduleIn(3000L);
            }
            if (PermissionFeatureDebug.TRACE_GLOBAL.show()) {
                LogSupport.message((Object)this, (String)"updateFeatures", (String)("[" + permissionName + "] isChair = " + isChair + " isEnabled = " + isEnabled + " hasPermission = " + hasPermission + " currValue = " + booleanFeature.getValue()));
            }
            booleanFeature.setEnabled(isChair && isEnabled);
            this.broker.setFeaturePublished((Feature)booleanFeature, isChair);
            if (hasPermission == null) continue;
            booleanFeature.setValue(hasPermission);
        }
    }

    public void onPermissionValueChange(CRPermissionChangeEvent event) {
        CRPermission permission = (CRPermission)event.getSource();
        Boolean isRemoteEvent = this.remoteEventThreadLocal.get();
        if (PermissionFeatureDebug.TRACE_GLOBAL.show()) {
            LogSupport.message((Object)this, (String)"onPermissionValueChange", (String)("isRemoteEvent = " + isRemoteEvent + " " + permission.getID() + " " + permission.getName() + " " + event.getValueChange()));
        }
        if (isRemoteEvent != null && !isRemoteEvent.booleanValue()) {
            this.remoteEventThreadLocal.remove();
            return;
        }
        this.remoteEventThreadLocal.set(true);
        this.updateFeatures(permission);
    }

    public void onPermissionDefaultChange(CRPermissionChangeEvent event) {
    }

    private class UpdateGlobalPermissionsTask
    implements Runnable {
        private CRPermission permission;
        private LightweightTimer timer;

        public UpdateGlobalPermissionsTask(CRPermission permission) {
            this.permission = permission;
        }

        public void setTimer(LightweightTimer timer) {
            this.timer = timer;
        }

        @Override
        public void run() {
            GlobalPermissionMetaDataListener.this.updateFeatures(this.permission);
            if (this.timer != null) {
                this.timer.cancel();
            }
        }
    }
}

