/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.client.messaging;

public class MessageType {
    public static final int NOTIFICATION_VOLUME = 11;
    public static final int MAX_VOLUME = 10;
    public static final int NORMAL = 5;
    public static final int MIN_VOLUME = 1;
    public static final int DEFAULT_VOLUME = 5;
    private static final String NULL_NAME = "Unique name can not be null or empty";
    private String uniqueName;
    private String displayName;
    private int volume = 5;

    public MessageType() {
    }

    public MessageType(String uniqueName, String displayName, int volume) {
        this.setUniqueName(uniqueName);
        this.setDisplayName(displayName);
        this.setVolume(volume);
    }

    public MessageType(String uniqueName, String displayName) {
        this(uniqueName, displayName, 5);
    }

    public String toString() {
        return "MessageType: [id=" + this.uniqueName + ",name=" + this.displayName + ",volume=" + this.volume + "]";
    }

    public void setUniqueName(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException(NULL_NAME);
        }
        this.uniqueName = name;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public void setVolume(int level) {
        this.setVolumeWithinBounds(level);
    }

    public String getUniqueName() {
        if (this.uniqueName == null) {
            throw new IllegalStateException("Unique name has not been set");
        }
        return this.uniqueName;
    }

    public String getDisplayName() {
        return this.displayName == null ? this.uniqueName : this.displayName;
    }

    public int getVolume() {
        return this.volume;
    }

    private void setVolumeWithinBounds(int level) {
        this.volume = level < 1 ? 1 : (level > 11 ? 11 : level);
    }
}

