/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.client.messaging;

import com.elluminate.classroom.client.messaging.ExtraInfo;
import com.elluminate.classroom.client.messaging.MessagePublisherMetadata;
import com.elluminate.classroom.client.messaging.MessageType;
import com.elluminate.util.StringUtils;
import java.util.Date;
import java.util.UUID;

public class Message {
    public static final String MSG_TYPE_MISSING = "Message type is a required field";
    public static final String ID_MISSING = "Unique ID is a required field";
    private final String id;
    private final long sessionTime;
    private final long systemTime;
    private final MessagePublisherMetadata publisherInfo;
    private final MessageType type;
    private boolean sentByMe = false;
    private String desc;
    private ExtraInfo info;

    public Message(String uniqueId, long sessionTime, MessageType msgType, MessagePublisherMetadata pubInfo) {
        if (uniqueId == null) {
            throw new IllegalArgumentException(ID_MISSING);
        }
        if (msgType == null) {
            throw new IllegalArgumentException(MSG_TYPE_MISSING);
        }
        this.id = uniqueId;
        this.sessionTime = sessionTime;
        this.systemTime = System.currentTimeMillis();
        this.type = msgType;
        this.publisherInfo = pubInfo;
    }

    public Message(long sessionTime, MessageType msgType, MessagePublisherMetadata pubInfo) {
        this(UUID.randomUUID().toString(), sessionTime, msgType, pubInfo);
    }

    public String toString() {
        return this.id + " " + new Date(this.systemTime).toString() + " " + StringUtils.formatTimeStamp((long)this.sessionTime) + " " + this.type + " " + this.info;
    }

    public String getId() {
        return this.id;
    }

    public long getSessionTime() {
        return this.sessionTime;
    }

    public long getSystemTime() {
        return this.systemTime;
    }

    public MessageType getMessageType() {
        return this.type;
    }

    public void setText(String textDescription) {
        this.desc = textDescription;
    }

    public String getText() {
        return this.desc;
    }

    public void setExtraInfo(ExtraInfo info) {
        this.info = info;
    }

    public ExtraInfo getExtraInfo() {
        return this.info;
    }

    public MessagePublisherMetadata getPublisherInfo() {
        return this.publisherInfo;
    }

    public boolean isSentByMe() {
        return this.sentByMe;
    }

    public void setSentByMe(boolean sentByMe) {
        this.sentByMe = sentByMe;
    }
}

