/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.client.messaging;

import com.elluminate.classroom.client.messaging.Message;
import com.elluminate.classroom.client.messaging.MessageListener;
import com.elluminate.classroom.client.messaging.MessageType;
import com.elluminate.classroom.client.messaging.MessagingDebug;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ListenerMap {
    private Map<MessageListener, List<MessageType>> listenerToType = new ConcurrentHashMap<MessageListener, List<MessageType>>();
    private Map<MessageType, List<MessageListener>> typeToListener = new ConcurrentHashMap<MessageType, List<MessageListener>>();
    private Logger logger = LogSupport.getInstance();

    @Inject
    public void initLogger(Logger logger) {
        this.logger = logger;
    }

    public void addListener(MessageListener listener, List<MessageType> types) {
        if (listener == null) {
            return;
        }
        if (types == null || types.size() == 0) {
            return;
        }
        for (MessageType type : types) {
            if (type == null) continue;
            this.addTypeToListenerMap(listener, type);
            this.addListenerToTypeMap(listener, type);
        }
    }

    private void addListenerToTypeMap(MessageListener listener, MessageType type) {
        if (this.typeToListener.containsKey(type)) {
            List<MessageListener> listeners = this.typeToListener.get(type);
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        } else {
            ArrayList<MessageListener> listeners = new ArrayList<MessageListener>();
            listeners.add(listener);
            this.typeToListener.put(type, listeners);
        }
    }

    private void addTypeToListenerMap(MessageListener listener, MessageType type) {
        if (this.listenerToType.containsKey(listener)) {
            List<MessageType> types = this.listenerToType.get(listener);
            if (!types.contains(type)) {
                types.add(type);
            }
        } else {
            ArrayList<MessageType> types = new ArrayList<MessageType>();
            types.add(type);
            this.listenerToType.put(listener, types);
        }
    }

    private void removeListenerFromTypeMap(MessageListener listener, MessageType type) {
        if (this.typeToListener.containsKey(type)) {
            this.typeToListener.get(type).remove(listener);
        }
    }

    private void removeTypeFromListenerMap(MessageListener listener, MessageType type) {
        List<MessageType> listOfTypes = this.listenerToType.get(listener);
        if (listOfTypes != null) {
            listOfTypes.remove(type);
        }
    }

    public void removeListener(MessageListener listener) {
        if (listener == null) {
            return;
        }
        List<MessageType> types = this.getTypesForListener(listener);
        for (MessageType type : types) {
            if (type == null) continue;
            this.removeListenerFromTypeMap(listener, type);
            this.removeTypeFromListenerMap(listener, type);
        }
    }

    public void removeListenerFromType(MessageListener listener, List<MessageType> types) {
        if (listener == null) {
            return;
        }
        if (types == null || types.size() == 0) {
            return;
        }
        for (MessageType type : types) {
            if (type == null) continue;
            this.removeListenerFromTypeMap(listener, type);
            this.removeTypeFromListenerMap(listener, type);
        }
    }

    protected List<MessageListener> getListenersForType(MessageType type) {
        if (type == null) {
            return new ArrayList<MessageListener>();
        }
        ArrayList listener = this.typeToListener.get(type);
        return listener == null ? new ArrayList() : listener;
    }

    protected List<MessageType> getTypesForListener(MessageListener listener) {
        if (listener == null) {
            return new ArrayList<MessageType>();
        }
        return new ArrayList<MessageType>((Collection)this.listenerToType.get(listener));
    }

    public int fireReceiveMessage(Message msg) {
        int count = 0;
        HashSet<MessageListener> recipients = new HashSet<MessageListener>();
        recipients.addAll(this.getListenersForType(msg.getMessageType()));
        for (MessageListener sendTo : recipients) {
            if (MessagingDebug.DISPATCH.show()) {
                this.logger.message((Object)this, "fireReceiveMessage", "Dispatching to " + sendTo.getClass().getName() + ": " + msg);
            }
            try {
                sendTo.receiveMessage(msg);
                ++count;
            }
            catch (Throwable t) {
                this.logger.exception((Object)this, "fireReceiveMessage", t, true);
            }
        }
        return count;
    }
}

