/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.location;

import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.StringFeature;
import com.elluminate.framework.location.FeatureAdapter;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class StringFeatureAdapter
extends FeatureAdapter
implements ActionListener {
    private StringFeature feature;
    private JTextField textField;
    private JMenuItem menuItem;
    private JLabel label;
    private boolean text = false;
    private boolean icon = false;
    private boolean tips = false;
    private String nameOverride = null;
    private Image iconOverride = null;
    private String tipOverride = null;

    void init(String prefix, StringFeature sf, JTextField textField, Container c) {
        super.init(prefix, (Feature)sf, textField, c);
        this.textField = textField;
        this.feature = sf;
        textField.addActionListener(this);
        textField.setEditable(this.feature.isEnabled() && this.feature.isMutable());
        textField.setEnabled(true);
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                StringFeatureAdapter.this.feature.setMetaDatum("DocumentUpdated", (Object)e.getOffset());
            }
        });
        this.nameOverride = this.getNameOverride();
        this.tipOverride = this.getTooltipOverride();
        this.feature.addMetaDataListener((MetaDataListener)this);
    }

    void init(String prefix, StringFeature sf, JMenuItem menuItem, Container c) {
        super.init(prefix, (Feature)sf, menuItem, c);
        this.menuItem = menuItem;
        this.feature = sf;
        menuItem.setEnabled(sf.isMutable() && sf.isEnabled());
        this.nameOverride = this.getNameOverride();
        this.tipOverride = this.getTooltipOverride();
        this.feature.addMetaDataListener((MetaDataListener)this);
    }

    void init(String prefix, StringFeature sf, JLabel label, Container c) {
        super.init(prefix, (Feature)sf, label, c);
        this.label = label;
        this.feature = sf;
        label.setEnabled(sf.isEnabled());
        this.nameOverride = this.getNameOverride();
        this.tipOverride = this.getTooltipOverride();
        this.feature.addMetaDataListener((MetaDataListener)this);
    }

    @Override
    public void dispose() {
        if (this.getTextField() != null) {
            this.getTextField().removeActionListener(this);
        }
        this.getStringFeature().removeMetaDataListener((MetaDataListener)this);
    }

    public StringFeature getStringFeature() {
        return this.feature;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public JMenuItem getMenuItem() {
        return this.menuItem;
    }

    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.textField != null) {
            this.feature.setValue((Object)this.textField.getText());
        }
    }

    @Override
    public void setHasText(boolean value) {
        if (this.text == value) {
            return;
        }
        this.text = value;
        if (this.text) {
            this.setText();
        } else if (this.textField != null) {
            this.textField.setText(null);
        } else if (this.menuItem != null) {
            this.menuItem.setText(null);
        } else if (this.label != null) {
            this.label.setText(null);
        }
    }

    public void setHasIcon(boolean value) {
        if (this.icon == value) {
            return;
        }
        this.icon = value;
        if (this.icon) {
            this.setIcon();
        } else if (this.menuItem != null) {
            this.menuItem.setIcon(null);
        } else if (this.label != null) {
            this.label.setIcon(null);
        }
    }

    @Override
    public void setHasToolTip(boolean value) {
        if (this.tips == value) {
            return;
        }
        this.tips = value;
        if (this.tips) {
            this.setTip();
        } else if (this.textField != null) {
            this.textField.setToolTipText(null);
        } else if (this.menuItem != null) {
            this.menuItem.setToolTipText(null);
        } else if (this.label != null) {
            this.label.setToolTipText(null);
        }
    }

    public void setText() {
        String text = (String)this.getStringFeature().getValue();
        if (this.textField != null) {
            this.textField.setText(text);
        } else if (this.menuItem != null) {
            this.menuItem.setText(text);
        } else if (this.label != null) {
            this.label.setText(text);
        }
    }

    public void setIcon() {
        Image image = this.iconOverride;
        if (image == null) {
            image = this.feature.getIcon();
        }
        if (this.menuItem != null) {
            this.menuItem.setIcon(new ImageIcon(image));
        } else if (this.label != null) {
            this.label.setIcon(new ImageIcon(image));
        }
    }

    public void setTip() {
        String tooltip = this.tipOverride;
        if (tooltip == null) {
            tooltip = this.feature.getDescription();
        }
        if (this.textField != null) {
            this.textField.setToolTipText(tooltip);
        } else if (this.menuItem != null) {
            this.menuItem.setToolTipText(tooltip);
        } else if (this.label != null) {
            this.label.setToolTipText(tooltip);
        }
    }

    @Override
    public void doMetaDataChanged(MetaDataEvent e) {
        String id = e.getID();
        if (id.equals("Feature.enabled")) {
            if (this.textField != null) {
                this.textField.setEditable(this.feature.isEnabled());
            } else if (this.menuItem != null) {
                this.menuItem.setEnabled(this.feature.isMutable() && this.feature.isEnabled());
            } else if (this.label != null) {
                this.label.setEnabled(this.feature.isEnabled());
            }
        } else if (id.equals("ValueFeature.value")) {
            if (this.text) {
                this.setText();
            }
        } else if (id.equals("Feature.description") && this.tips && this.tipOverride == null) {
            this.setTip();
        }
    }
}

