/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.location;

import com.google.inject.Provider;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class OrderedContainer<C extends Container, T extends Component> {
    public static final float INTEGER_DELTA = 0.001f;
    private C container;
    private Provider<Component> separatorFactory = null;
    private List<ChildInfo> children = new ArrayList<ChildInfo>();
    private Comparator<T> sorted = null;

    public void setContainer(C container) {
        this.container = container;
    }

    public C getContainer() {
        return this.container;
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public void setSeparatorFactory(Provider<Component> provider) {
        this.separatorFactory = provider;
    }

    public void setSorter(Comparator<T> comparator) {
        this.sorted = comparator;
    }

    public void doAdd(T component, float position) {
        if (component == null) {
            throw new IllegalArgumentException("Attempt to add null component");
        }
        if (this.sorted != null) {
            this.addSorted(component);
        } else {
            this.addOrdered(component, position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrdered(T component, float position) {
        ChildInfo prev = null;
        ChildInfo info = new ChildInfo(this, component, position);
        List<ChildInfo> list = this.children;
        synchronized (list) {
            int i;
            for (i = 0; i < this.children.size(); ++i) {
                ChildInfo next = this.children.get(i);
                if (info.getPosition() < next.getPosition()) {
                    this.add(i, info, (Component)component);
                    if (info.needsSeparator(next)) {
                        this.addSeparator(i + 1, next.getSeparator());
                    }
                    if (info.needsSeparator(prev)) {
                        this.addSeparator(i, info.getSeparator());
                    }
                    return;
                }
                prev = next;
            }
            i = this.children.size();
            this.add(i, info, (Component)component);
            if (info.needsSeparator(prev)) {
                this.addSeparator(i, info.getSeparator());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSorted(T component) {
        float position = -1.0f;
        List<ChildInfo> list = this.children;
        synchronized (list) {
            int min = 0;
            int max = this.children.size() - 1;
            float minPos = 1.0E-11f;
            float maxPos = 1.0f;
            while (min <= max) {
                int test = (min + max) / 2;
                ChildInfo info = this.children.get(test);
                int order = this.sorted.compare(component, info.getComponent());
                if (order == 0) {
                    position = info.getPosition();
                    break;
                }
                if (order < 0) {
                    max = test - 1;
                    maxPos = info.getPosition() - 1.0E-11f;
                    continue;
                }
                min = test + 1;
                minPos = info.getPosition() + 1.0E-11f;
            }
            if (position < 0.0f) {
                position = (minPos + maxPos) / 2.0f;
            }
        }
        this.addOrdered(component, position);
    }

    private void add(int pos, ChildInfo info, Component c) {
        this.children.add(pos, info);
        ((Container)this.container).add(c, pos);
    }

    private void addSeparator(int pos, ChildInfo separator) {
        this.add(pos, separator, separator.getSeparatorComponent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemove(T component) {
        ChildInfo prev = null;
        List<ChildInfo> list = this.children;
        synchronized (list) {
            for (int i = 0; i < this.children.size(); ++i) {
                ChildInfo info = this.children.get(i);
                if (info.component == component) {
                    ChildInfo trim;
                    this.remove(i);
                    ChildInfo next = null;
                    if (i < this.children.size()) {
                        next = this.children.get(i);
                    }
                    if ((trim = this.dupSeparator(prev, next)) == null) break;
                    if (trim == prev) {
                        this.remove(i - 1);
                        break;
                    }
                    if (trim != next) break;
                    this.remove(i);
                    break;
                }
                prev = info;
            }
        }
    }

    private void remove(int pos) {
        ((Container)this.container).remove(pos);
        this.children.remove(pos);
    }

    protected ChildInfo dupSeparator(ChildInfo p, ChildInfo n) {
        if (p == null) {
            if (n != null && n.isSeparator()) {
                return n;
            }
        } else if (n == null ? p.isSeparator() : p.isSeparator() && n.isSeparator()) {
            return p;
        }
        return null;
    }

    class ChildInfo
    implements Comparable<ChildInfo> {
        float position;
        T component;
        Component separator;
        final /* synthetic */ OrderedContainer this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public ChildInfo(T component, float position) {
            this.this$0 = (OrderedContainer)f;
            this.position = position == (float)((int)position) ? position + 0.001f : position;
            this.component = component;
            this.separator = null;
        }

        public ChildInfo(OrderedContainer orderedContainer, float position, Component separator) {
            this.this$0 = orderedContainer;
            this.position = position;
            this.component = null;
            this.separator = separator;
        }

        public float getPosition() {
            return this.position;
        }

        public boolean isSeparator() {
            return this.separator != null;
        }

        public T getComponent() {
            return this.component;
        }

        @Override
        public int compareTo(ChildInfo o) {
            if (this.position == o.position) {
                return 0;
            }
            if (this.position < o.position) {
                return -1;
            }
            return 1;
        }

        public boolean needsSeparator(ChildInfo o) {
            if (this.this$0.separatorFactory == null) {
                return false;
            }
            if (o == null) {
                return false;
            }
            if (this.separator != null || o.separator != null) {
                return false;
            }
            return (int)this.position != (int)o.position;
        }

        public ChildInfo getSeparator() {
            Component separator = (Component)this.this$0.separatorFactory.get();
            ChildInfo sepinfo = new ChildInfo(this.this$0, (int)this.position, separator);
            return sepinfo;
        }

        public Component getSeparatorComponent() {
            return this.separator;
        }
    }
}

