/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.location;

import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.location.AbstractSwingLocationHandler;
import com.elluminate.framework.location.ActionFeatureAdapter;
import com.elluminate.framework.location.ActionFeatureAdapterProvider;
import com.elluminate.framework.location.BooleanFeatureAdapter;
import com.elluminate.framework.location.BooleanFeatureAdapterProvider;
import com.elluminate.framework.location.EnumFeatureAdapter;
import com.elluminate.framework.location.EnumFeatureAdapterProvider;
import com.elluminate.framework.location.FeatureAdapter;
import com.elluminate.framework.location.FeaturePair;
import com.elluminate.framework.location.LocationDebug;
import com.elluminate.framework.location.MenuFactory;
import com.elluminate.framework.location.MenuTreeNode;
import com.elluminate.framework.location.OrderedContainer;
import com.elluminate.framework.location.PairedFeatureAdapter;
import com.elluminate.framework.location.PairedFeatureAdapterProvider;
import com.elluminate.framework.location.ParameterSource;
import com.elluminate.framework.location.StringsProperties;
import com.elluminate.framework.location.Submenu;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.StringComparator;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;

public class DefaultMenuHandler
extends AbstractSwingLocationHandler
implements MenuTreeNode {
    public static final String PLATFORM_MODIFIER = "PLATFORM";
    public static final String HINT_PREFIX = "menus";
    public static final String ORDER_HINT = ".order";
    public static final String SUBDIR_NAME_HINT = ".submenus.name";
    public static final String SUBDIR_ORDER_HINT = ".submenus.order";
    public static final String INVERSE_HINT = ".inverse";
    public static final String ACCELERATOR_HINT = ".accelerator";
    public static final String ACCELERATOR_HINT_LIST = ".accelerator.list";
    public static final Float DEFAULT_ORDER = Float.valueOf(999.5f);
    private static final Set<Float> EMPTY_ORDER_SET = new HashSet<Float>();
    private OrderedContainer<JMenu, JMenuItem> menuContainer;
    private Map<Feature, FeatureAdapter> registry = new HashMap<Feature, FeatureAdapter>();
    private Map<String, FeaturePair> pending = new HashMap<String, FeaturePair>();
    private MenuFactory factory;
    private String location;
    private JMenu menu;
    private Provider<Submenu> submenuProvider;
    private Map<JMenu, MenuTreeNode> menus = new IdentityHashMap<JMenu, MenuTreeNode>();
    private Map<String, Submenu> children = new HashMap<String, Submenu>();
    private String platformMask = "";
    private I18n i18n;
    private ActionFeatureAdapterProvider actionAdapterProv;
    private BooleanFeatureAdapterProvider booleanAdapterProv;
    private EnumFeatureAdapterProvider enumAdapterProv;
    private PairedFeatureAdapterProvider pairedAdapterProv;
    private List<ParameterSource<?>> sources = null;
    private Provider<Component> separatorFactory = new Provider<Component>(){

        public Component get() {
            return new JSeparator();
        }
    };

    public DefaultMenuHandler() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int mask = toolkit.getMenuShortcutKeyMask();
        if ((mask & 2) != 0) {
            this.platformMask = this.platformMask + "control";
        }
        if ((mask & 1) != 0) {
            if (this.platformMask.length() > 0) {
                this.platformMask = this.platformMask + " ";
            }
            this.platformMask = this.platformMask + "shift";
        }
        if ((mask & 4) != 0) {
            if (this.platformMask.length() > 0) {
                this.platformMask = this.platformMask + " ";
            }
            this.platformMask = this.platformMask + "meta";
        }
        if ((mask & 8) != 0) {
            if (this.platformMask.length() > 0) {
                this.platformMask = this.platformMask + " ";
            }
            this.platformMask = this.platformMask + "alt";
        }
    }

    @Inject
    public void initMenuItemFactory(MenuFactory factory) {
        this.factory = factory;
    }

    @Inject
    public void initOrderedContainer(OrderedContainer<JMenu, JMenuItem> container) {
        this.menuContainer = container;
        this.menuContainer.setSeparatorFactory(this.separatorFactory);
    }

    @Inject
    public void initSubmenuProvider(Provider<Submenu> subProv) {
        this.submenuProvider = subProv;
    }

    @Inject
    public void initAdapterProviders(ActionFeatureAdapterProvider ap, BooleanFeatureAdapterProvider bp, EnumFeatureAdapterProvider ep, PairedFeatureAdapterProvider pp) {
        this.actionAdapterProv = ap;
        this.booleanAdapterProv = bp;
        this.enumAdapterProv = ep;
        this.pairedAdapterProv = pp;
    }

    @Inject
    public void initI18n(I18nProvider prov) {
        this.i18n = prov.get((Object)this);
    }

    public void setMenuAndLocation(String name, String location, int mnemonic) {
        this.location = location;
        this.menu = this.factory.createMenu(name);
        if (mnemonic >= 0) {
            this.menu.setMnemonic(mnemonic);
        }
        this.menuContainer.setContainer(this.menu);
        this.menus.put(this.menu, this);
        this.menu.setVisible(false);
        this.menu.getPopupMenu().addContainerListener(new VisibilityController(this.menu));
    }

    @Override
    public JMenu getMenu() {
        return this.menu;
    }

    public String getLocation() {
        return this.location;
    }

    public void addSubMenu(JMenu menu, float order) {
        this.menuContainer.doAdd(menu, order);
    }

    public void removeSubmenu(JMenu menu) {
        this.menuContainer.doRemove(menu);
    }

    public void setSorted(boolean sorted) {
        this.menuContainer.setSorter(sorted ? new MenuSorter() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameterSource(ParameterSource<?> src) {
        DefaultMenuHandler defaultMenuHandler = this;
        synchronized (defaultMenuHandler) {
            if (this.sources == null) {
                this.sources = new ArrayList();
            }
            this.sources.add(src);
        }
    }

    @Override
    public void addFeatureSwing(Feature feature) {
        MenuTreeNode node;
        FeatureAdapter adapter;
        if (LocationDebug.MENUS.show()) {
            this.logger.message((Object)this, "addFeature", "Adding '" + feature.getPath() + "'");
        }
        if ((adapter = this.getAdapter(node = this.getNode(feature), feature)) == null) {
            return;
        }
        JMenuItem item = (JMenuItem)adapter.getComponent();
        Float order = (Float)feature.getHintValue(this.getHintName(ORDER_HINT), Float.class);
        this.registry.put(feature, adapter);
        if (order == null) {
            node.add(item, DEFAULT_ORDER.floatValue());
        } else {
            node.add(item, order.floatValue());
        }
    }

    @Override
    public void removeFeatureSwing(Feature feature) {
        FeatureAdapter adapter;
        if (LocationDebug.MENUS.show()) {
            this.logger.message((Object)this, "removeFeature", "Removing '" + feature.getPath() + "'");
        }
        if ((adapter = this.registry.remove(feature)) != null) {
            Container parent = adapter.getParent();
            MenuTreeNode node = this.menus.get((JMenu)parent);
            if (node != null) {
                Component component = adapter.getComponent();
                node.remove((JMenuItem)component);
            }
            adapter.dispose();
        }
    }

    private MenuTreeNode getNode(Feature feature) {
        Set submenus = (Set)feature.getHintValue(this.getHintName(SUBDIR_NAME_HINT), Set.class);
        Set<Float> orders = (Set<Float>)feature.getHintValue(this.getHintName(SUBDIR_ORDER_HINT), Set.class);
        MenuTreeNode node = this;
        if (submenus != null) {
            if (orders == null) {
                orders = EMPTY_ORDER_SET;
            }
            Iterator<Float> orderIterator = orders.iterator();
            for (String subname : submenus) {
                Submenu sub = node.getSubmenu(subname);
                Float order = DEFAULT_ORDER;
                if (orderIterator.hasNext()) {
                    order = orderIterator.next();
                }
                if (sub == null) {
                    JMenu menu = this.factory.createMenu(subname);
                    sub = (Submenu)this.submenuProvider.get();
                    sub.init(node, subname, menu, order.floatValue());
                }
                node = sub;
            }
        }
        return node;
    }

    private FeatureAdapter getAdapter(MenuTreeNode node, Feature f) {
        if (f instanceof ActionFeature) {
            return this.getActionAdapter(node, (ActionFeature)f);
        }
        if (f instanceof BooleanFeature) {
            return this.getBooleanAdapter(node, (BooleanFeature)f);
        }
        if (f instanceof EnumeratedFeature) {
            return this.getEnumeratedAdapter(node, (EnumeratedFeature)f);
        }
        throw new IllegalArgumentException("Unsupported feature type '" + f.getClass() + "'");
    }

    private FeatureAdapter getActionAdapter(MenuTreeNode node, ActionFeature feature) {
        KeyStroke accelerator;
        if (feature.hasHint(this.getHintName(INVERSE_HINT))) {
            return this.getPairedAdapter(node, feature);
        }
        ActionFeatureAdapter adapter = null;
        JMenuItem item = this.factory.createItem((Feature)feature);
        String accel = (String)feature.getHintValue(this.getHintName(ACCELERATOR_HINT), String.class);
        if (accel != null && (accelerator = KeyStroke.getKeyStroke(accel = accel.replace(PLATFORM_MODIFIER, this.platformMask))) != null) {
            item.setAccelerator(accelerator);
        }
        adapter = this.sources == null ? this.actionAdapterProv.get(HINT_PREFIX, feature, item, node.getMenu()) : this.actionAdapterProv.get(HINT_PREFIX, this.sources, feature, item, node.getMenu());
        adapter.setInteractiveSubstitution(this.i18n.getString((PropertiesEnum)StringsProperties.DEFAULTMENUHANDLER_INTERACTIVEITEM));
        adapter.setHasText(true);
        return adapter;
    }

    private FeatureAdapter getPairedAdapter(MenuTreeNode node, ActionFeature feature) {
        String inverse = (String)feature.getHintValue(this.getHintName(INVERSE_HINT), String.class);
        FeaturePair pair = this.pending.remove(feature.getPath());
        if (pair == null) {
            pair = new FeaturePair(feature);
            this.pending.put(inverse, pair);
            return null;
        }
        pair.finish(feature);
        JMenuItem item = this.factory.createItem((Feature)feature);
        PairedFeatureAdapter adapter = this.pairedAdapterProv.get(HINT_PREFIX, pair, item, node.getMenu());
        adapter.setHasText(true);
        return adapter;
    }

    private FeatureAdapter getBooleanAdapter(MenuTreeNode node, BooleanFeature feature) {
        BooleanFeatureAdapter adapter = null;
        if (feature.isMutable()) {
            KeyStroke accelerator;
            JMenuItem item = this.factory.createItem((Feature)feature);
            String accel = (String)feature.getHintValue(this.getHintName(ACCELERATOR_HINT), String.class);
            if (accel != null && (accelerator = KeyStroke.getKeyStroke(accel = accel.replace(PLATFORM_MODIFIER, this.platformMask))) != null) {
                item.setAccelerator(accelerator);
            }
            adapter = this.booleanAdapterProv.get(HINT_PREFIX, feature, item, node.getMenu());
            adapter.setHasText(true);
        }
        return adapter;
    }

    private FeatureAdapter getEnumeratedAdapter(MenuTreeNode node, EnumeratedFeature feature) {
        EnumFeatureAdapter adapter = null;
        if (feature.isMutable()) {
            JMenuItem item = this.factory.createItem((Feature)feature);
            adapter = this.enumAdapterProv.get(HINT_PREFIX, feature, item, node.getMenu());
            adapter.setHasText(true);
            String name = adapter.getNameOverride();
            if (name == null) {
                name = feature.getName();
            }
            item.setText(name);
            List accelerators = (List)feature.getHintValue(this.getHintName(ACCELERATOR_HINT_LIST), List.class);
            Map<String, String> acceleratorMap = this.createAcceleratorMap(accelerators);
            Object[] values = feature.getEnumerationSet().toArray();
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                JRadioButtonMenuItem menuItem = this.factory.createRadioButton();
                if (accelerators != null) {
                    KeyStroke accelerator;
                    String accel = null;
                    if (acceleratorMap != null) {
                        String valToString = values[i].toString();
                        accel = acceleratorMap.get(valToString);
                    } else {
                        String string = accel = accelerators.size() > i ? (String)accelerators.get(i) : null;
                    }
                    if (accel != null && (accelerator = KeyStroke.getKeyStroke(accel = accel.replace(PLATFORM_MODIFIER, this.platformMask))) != null) {
                        menuItem.setAccelerator(accelerator);
                    }
                }
                adapter.addItem(menuItem, values[i]);
            }
        }
        return adapter;
    }

    private Map<String, String> createAcceleratorMap(List<String> accelerators) {
        HashMap<String, String> accelMap = new HashMap<String, String>();
        if (accelerators != null) {
            for (String accel : accelerators) {
                if (accel == null || !accel.contains("[") || !accel.contains("]")) continue;
                String key = accel.substring(accel.indexOf("[") + 1, accel.indexOf("]"));
                String value = accel.replace("[" + key + "]", "");
                value = value.trim();
                accelMap.put(key, value);
            }
        }
        if (accelMap.size() == 0) {
            return null;
        }
        return accelMap;
    }

    @Override
    public void addSubmenu(Submenu submenu) {
        if (LocationDebug.MENUS.show()) {
            this.logger.message((Object)this, "addSubmenu", "Adding menu " + this.getPath() + "->" + submenu.getName() + " at position " + submenu.getOrder());
        }
        this.children.put(submenu.getName(), submenu);
        this.menus.put(submenu.getMenu(), submenu);
    }

    @Override
    public void removeSubmenu(Submenu submenu) {
        this.children.remove(submenu.getName());
    }

    @Override
    public boolean containsSubmenu(String name) {
        return this.children.containsKey(name);
    }

    @Override
    public Submenu getSubmenu(String name) {
        return this.children.get(name);
    }

    @Override
    public void setSubmenuShowing(String name, boolean show) {
        Submenu submenu = this.children.get(name);
        if (submenu == null) {
            throw new IllegalArgumentException("Requested submenu '" + name + "' is not a child of this parent");
        }
        if (show) {
            if (submenu.isShowing()) {
                return;
            }
            this.add(submenu.getMenu(), submenu.getOrder());
            submenu.setShowing(true);
        } else {
            submenu.setShowing(false);
            this.remove(submenu.getMenu());
        }
    }

    @Override
    public void add(JMenuItem item, float order) {
        if (LocationDebug.MENUS.show()) {
            this.logger.message((Object)this, "add", "Adding item '" + this.getPath() + "->" + item.getText() + "' at position " + order);
        }
        this.menuContainer.doAdd(item, order);
    }

    @Override
    public void remove(JMenuItem item) {
        if (LocationDebug.MENUS.show()) {
            this.logger.message((Object)this, "remove", "Removing item '" + this.getPath() + "->" + item.getText() + "'");
        }
        this.menuContainer.doRemove(item);
    }

    @Override
    public String getPath() {
        return this.menu.getText();
    }

    private String getHintName(String hint) {
        return HINT_PREFIX + hint;
    }

    class MenuSorter
    implements Comparator<JMenuItem> {
        StringComparator cmp = new StringComparator(false, 1);

        MenuSorter() {
        }

        @Override
        public int compare(JMenuItem o1, JMenuItem o2) {
            return this.cmp.compare(o1.getText(), o2.getText());
        }
    }

    private static class VisibilityController
    implements ContainerListener,
    ComponentListener {
        private JMenu menu;

        public VisibilityController(JMenu menu) {
            this.menu = menu;
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            Component c = e.getChild();
            c.addComponentListener(this);
            if (c.isVisible()) {
                this.menu.setVisible(true);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            Component c = e.getChild();
            c.removeComponentListener(this);
            this.updateMenuVisible();
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.menu.setVisible(true);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.updateMenuVisible();
        }

        private void updateMenuVisible() {
            boolean vis = false;
            for (Component c : this.menu.getMenuComponents()) {
                if (!c.isVisible()) continue;
                vis = true;
                break;
            }
            this.menu.setVisible(vis);
        }
    }
}

