/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia;

import com.elluminate.groupware.multimedia.MediaLibrary;
import com.elluminate.groupware.multimedia.MediaLibraryEntry;
import com.elluminate.groupware.multimedia.StreamCache;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.jinx.TransmitStatusEvent;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;

public class ResponderMediaLibrary
extends MediaLibrary {
    public ResponderMediaLibrary() {
        super(null);
    }

    @Override
    public void remove(int id) {
        throw new RuntimeException("Remove operation not supported from responders.");
    }

    public String lookupName(int id) {
        RMLEntry entry = (RMLEntry)this.get(id);
        if (entry != null) {
            return entry.getName();
        }
        return null;
    }

    @Override
    public void onChannelData(ChannelDataEvent event) {
        DataInputStream istr = null;
        DataOutputStream ostr = null;
        RMLEntry entry = null;
        String name = null;
        String type = null;
        ChannelDataEvent resp = null;
        ProtocolBuffer buf = null;
        try {
            istr = event.read();
            switch (event.getCommand()) {
                case 22: {
                    buf = event.getBuffer();
                    istr.close();
                    istr = buf.readHeader(4);
                    int id = istr.readInt();
                    istr.close();
                    istr = null;
                    entry = (RMLEntry)this.get(id);
                    if (entry == null) break;
                    long posn = entry.getPosition() + (long)buf.getSize();
                    entry.setPosition(posn);
                    long unacked = entry.getPosition() - entry.getAcknowledged();
                    if (unacked < 16000L) break;
                    resp = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)23);
                    ostr = resp.write();
                    ostr.writeInt(entry.getID());
                    ostr.writeInt((int)unacked);
                    ostr.close();
                    this.channel.onChannelData(resp);
                    entry.setAcknowledged(entry.getPosition());
                    break;
                }
                case 20: {
                    int id = istr.readInt();
                    this.delete(id);
                    break;
                }
                case 18: {
                    int id = istr.readInt();
                    name = istr.readUTF();
                    type = istr.readUTF();
                    long len = istr.readLong();
                    long posn = istr.readLong();
                    String auth = istr.readUTF();
                    entry = (RMLEntry)this.get(id);
                    if (entry == null) {
                        entry = new RMLEntry(id, len, name, type);
                        this.insert(id, entry);
                    }
                    entry.setPosition(posn);
                    break;
                }
            }
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"onChannelData", (Throwable)ex, (boolean)true);
        }
        if (istr != null) {
            try {
                istr.close();
            }
            catch (IOException io) {
                // empty catch block
            }
        }
    }

    @Override
    public void transmitStatusChange(TransmitStatusEvent e) {
    }

    @Override
    public void removeProxy(short addr) {
    }

    @Override
    public void startHook(int id) {
        MediaLibraryEntry ent = this.get(id);
        if (ent == null) {
            return;
        }
        if (ent.isComplete()) {
            return;
        }
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)24);
        try {
            DataOutputStream ostr = e.write();
            ostr.writeInt(id);
            ostr.close();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"startHook", (Throwable)ex, (boolean)true);
            return;
        }
        this.channel.onChannelData(e);
    }

    @Override
    public void addProxy(short addr) {
        if (addr != 0) {
            throw new IllegalArgumentException("Only the server may be a client proxy.");
        }
        if (this.channel == null) {
            throw new IllegalStateException("Cannot add procy when not connected.");
        }
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)21);
        try {
            DataOutputStream ostr = e.write();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                MediaLibraryEntry ent = (MediaLibraryEntry)i.next();
                ent.encodeStatus(ostr, this.getConnection().getAddress());
                ent.setAcknowledged(ent.getPosition());
            }
            ostr.writeInt(0);
            ostr.close();
            this.channel.onChannelData(e);
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"addProxy", (Throwable)ex, (boolean)true);
        }
    }

    class RMLEntry
    extends MediaLibraryEntry {
        long posn;

        public RMLEntry(int id, long len, String nm, String type) {
            super(id, len, null, nm, type);
            this.posn = 0L;
        }

        @Override
        public long getPosition() {
            return this.posn;
        }

        public void setPosition(long where) {
            this.posn = where;
        }

        @Override
        public StreamCache getCache() {
            return null;
        }

        @Override
        public void setCache(StreamCache cache) {
        }
    }
}

