/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia;

import com.elluminate.groupware.multimedia.MultimediaProtocol;
import com.elluminate.groupware.multimedia.ResponderMediaLibrary;
import com.elluminate.groupware.multimedia.StringsProperties;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.DefaultProtocolResponder;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.VCRFile;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.IOException;

public class MultimediaResponder
extends DefaultProtocolResponder
implements ChannelListener,
ChannelDataListener {
    private ResponderMediaLibrary lib = null;
    private I18n i18n = I18n.create((Object)((Object)this));
    private I18nMessage mod = this.i18n.getMessage((PropertiesEnum)StringsProperties.MULTIMEDIARESPONDER_INDEXICON);
    private I18nMessage typePlay = this.i18n.getMessage((PropertiesEnum)StringsProperties.MULTIMEDIARESPONDER_INDEXTYPEPLAY);

    public MultimediaResponder(MultimediaProtocol protocol) {
        super((JinxProtocol)protocol);
        this.lib = new ResponderMediaLibrary();
        this.setChannelListener(this);
        this.setChannelDataListener(this);
    }

    public void join(Connection connection, String channel) {
        super.join(connection, channel);
        this.lib.setChannel(this.getChannel());
    }

    public void leave(String channel) {
        super.leave(channel);
        this.lib.setChannel(null);
    }

    public void channelStateChanged(ChannelEvent e) {
        switch (e.getState()) {
            case 1: {
                this.lib.addProxy((short)0);
                break;
            }
            case 2: {
                this.lib.removeProxy((short)0);
                break;
            }
        }
    }

    public void onChannelData(ChannelDataEvent e) {
        byte command = e.getCommand();
        byte category = (byte)(command & 0xFFFFFFF0);
        if (category == 16) {
            this.lib.onChannelData(e);
        } else if (command == 33) {
            try {
                DataInputStream istr = e.read();
                int id = istr.readInt();
                this.lib.startPlaying(id);
                I18nMessage name = new I18nMessage(this.lib.lookupName(id));
                VCRFile.IndexEntry indexEntry = new VCRFile.IndexEntry(this.mod, this.typePlay, name);
                this.fireNotableEventListeners("recording.index", indexEntry);
            }
            catch (IOException ex) {
                LogSupport.exception((Object)((Object)this), (String)"onChannelData", (Throwable)ex, (boolean)true);
            }
        }
    }
}

