/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia;

import com.elluminate.groupware.multimedia.MultimediaResponder;
import com.elluminate.jinx.Bytes;
import com.elluminate.jinx.JinxProtocolAdapter;
import com.elluminate.jinx.ProtocolResponder;
import com.elluminate.util.I18n;
import java.io.DataInputStream;
import java.io.IOException;

public class MultimediaProtocol
extends JinxProtocolAdapter {
    public static final String CHANNEL = "multimedia";
    public static final byte PRIORITY = 2;
    public static final String OS_PROPERTY = "multimedia.os";
    public static final byte UNKNOWN_OS = 0;
    public static final byte MAC_OS = 1;
    public static final byte WINDOWS_OS = 2;
    public static final byte LINUX_OS = 3;
    public static final byte SOLARIS_OS = 4;
    public static final byte IOS_OS = 5;
    public static final byte ANDRIOD_OS = 6;
    public static final byte CATEGORY = -16;
    public static final byte CAT_LIBRARY = 16;
    public static final byte CAT_EVENT = 32;
    public static final byte CAT_ID = 48;
    public static final byte LIB_LOAD = 17;
    public static final byte LIB_PUSH = 18;
    public static final byte LIB_RESUME = 19;
    public static final byte LIB_DELETE = 20;
    public static final byte LIB_SYNC = 21;
    public static final byte LIB_DATA = 22;
    public static final byte LIB_ACK = 23;
    public static final byte LIB_URGENT = 24;
    public static final byte LIB_ERROR = 25;
    public static final byte LIB_STATUS = 26;
    public static final byte EVENT_PLAY = 33;
    public static final byte EVENT_STOP = 34;
    public static final byte EVENT_ERROR = 35;
    public static final byte ID_REQUEST = 49;
    public static final byte ID_ASSIGN = 50;
    public static final int NULL_ID = 0;
    public static final int RED_PERCENT = 49;
    public static final int ORANGE_PERCENT = 74;
    public static final int YELLOW_PERCENT = 94;
    public static final int CYAN_PERCENT = 99;
    public static final int GREEN_PERCENT = 100;
    public static final int[] STATUS_PCT = new int[]{49, 74, 94, 99, 100};
    private I18n i18n = I18n.create((Object)((Object)this));
    private MultimediaResponder responder = null;

    public MultimediaProtocol() {
        this.defineChannel(CHANNEL, (byte)2);
        this.defineProperty(OS_PROPERTY, (byte)0, Bytes.get((byte)0));
    }

    public String commandToString(byte cmd) {
        switch (cmd) {
            case 17: {
                return "LibraryLoad";
            }
            case 18: {
                return "LibraryPush";
            }
            case 19: {
                return "LibraryResume";
            }
            case 20: {
                return "LibraryDelete";
            }
            case 21: {
                return "LibrarySync";
            }
            case 22: {
                return "LibraryData";
            }
            case 23: {
                return "LibraryACK";
            }
            case 24: {
                return "LibraryUrgent";
            }
            case 25: {
                return "LibraryError";
            }
            case 26: {
                return "LibraryStatus";
            }
            case 33: {
                return "Play";
            }
            case 34: {
                return "Stop";
            }
            case 35: {
                return "Error";
            }
            case 49: {
                return "IDRequest";
            }
            case 50: {
                return "IDAssign";
            }
        }
        return "[***** UNKNOWN COMMAND " + cmd + " *****]";
    }

    public String messageToString(byte cmd, DataInputStream str) {
        String desc = this.commandToString(cmd);
        try {
            switch (cmd) {
                case 17: {
                    String name = str.readUTF();
                    desc = desc + " - " + name;
                    break;
                }
                case 18: {
                    int id = str.readInt();
                    String name = str.readUTF();
                    String type = str.readUTF();
                    long length = str.readLong();
                    long position = str.readLong();
                    String auth = str.readUTF();
                    desc = desc + " - [" + id + "(" + auth + "):" + name + "(" + type + "," + position + "/" + length + ")]";
                    break;
                }
                case 19: {
                    int id = str.readInt();
                    long position = str.readLong();
                    desc = desc + " - ID " + id + ", from offset " + position;
                    break;
                }
                case 21: {
                    desc = desc + ":";
                    int id = str.readInt();
                    while (id > 0) {
                        String name = str.readUTF();
                        String type = str.readUTF();
                        long length = str.readLong();
                        long position = str.readLong();
                        String auth = str.readUTF();
                        desc = desc + "\n    [" + id + "(" + auth + "): " + name + "(" + type + "," + position + "/" + length + ")]";
                        id = str.readInt();
                    }
                    break;
                }
                case 20: {
                    int id = str.readInt();
                    desc = desc + " - ID=" + id;
                    break;
                }
                case 22: {
                    desc = desc + " - ID=" + str.readInt() + "," + str.available() + " bytes of data";
                    break;
                }
                case 23: {
                    desc = desc + " - ID=" + str.readInt() + "," + str.readInt() + " bytes received.";
                    break;
                }
                case 26: {
                    StringBuffer buf = new StringBuffer(desc);
                    buf.append(":");
                    int id = str.readInt();
                    while (id > 0) {
                        short percent = str.readByte();
                        buf.append("\n    [");
                        buf.append(id);
                        buf.append("(");
                        if (percent == 100) {
                            buf.append("complete,");
                        } else if (percent >= 0) {
                            buf.append("loading(");
                            buf.append(percent);
                            buf.append("),");
                        } else {
                            buf.append("incomplete(");
                            buf.append(-percent);
                            buf.append("),");
                        }
                        for (int i = 0; i < STATUS_PCT.length; ++i) {
                            percent = str.readShort();
                            if (i != 0) {
                                buf.append("/");
                            }
                            buf.append(percent);
                        }
                        buf.append(")]");
                        id = str.readInt();
                    }
                    desc = buf.toString();
                    break;
                }
                case 25: 
                case 35: {
                    String msg = str.readUTF();
                    String context = str.readUTF();
                    String details = str.readUTF();
                    desc = desc + this.i18n.getStringLegacy(msg, new Object[]{context, details});
                    break;
                }
                case 24: 
                case 33: {
                    int id = str.readInt();
                    desc = desc + " - ID=" + id;
                    break;
                }
                case 50: {
                    int seq = str.readInt();
                    int id = str.readInt();
                    String dh = str.readUTF();
                    desc = desc + " - seq=" + seq + ", ID=" + id + ", dh='" + dh + "'";
                    break;
                }
                case 49: {
                    int seq = str.readInt();
                    String dh = str.readUTF();
                    desc = desc + " - seq=" + seq + ", dh='" + dh + "'";
                    break;
                }
            }
        }
        catch (IOException ex) {
            desc = desc + " - " + ex + " while decoding message.";
        }
        return desc;
    }

    public ProtocolResponder getResponder() {
        if (this.responder == null) {
            this.responder = new MultimediaResponder(this);
        }
        return this.responder;
    }
}

