/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.multimedia;

import com.elluminate.groupware.multimedia.MediaLibraryEntry;
import com.elluminate.groupware.multimedia.StreamCache;
import com.elluminate.groupware.multimedia.StreamProxy;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.TransmitStatusEvent;
import com.elluminate.jinx.TransmitStatusListener;
import com.elluminate.util.I18n;
import com.elluminate.util.log.LogSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class MediaLibrary
implements ChannelDataListener,
TransmitStatusListener {
    protected static final int WINDOW_SIZE = 32000;
    protected I18n i18n = I18n.create((Object)this);
    protected Channel channel = null;
    private HashMap entries = new HashMap();
    private PropertyChangeListener listener = null;

    public MediaLibrary(Channel chnl) {
        this.channel = chnl;
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String nm = e.getPropertyName();
                if (nm.equals("location")) {
                    StreamCache streamCache = (StreamCache)e.getSource();
                }
            }
        };
    }

    public void setChannel(Channel chnl) {
        this.channel = chnl;
    }

    public Iterator iterator() {
        return Collections.unmodifiableCollection(this.entries.values()).iterator();
    }

    public Set keys() {
        return new HashSet(this.entries.keySet());
    }

    public MediaLibraryEntry get(int id) {
        return (MediaLibraryEntry)this.entries.get(new Integer(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(int id, MediaLibraryEntry entry) {
        MediaLibrary mediaLibrary = this;
        synchronized (mediaLibrary) {
            HashMap newEntries = (HashMap)this.entries.clone();
            newEntries.put(new Integer(id), entry);
            this.entries = newEntries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MediaLibraryEntry delete(int id) {
        MediaLibraryEntry ent = null;
        MediaLibrary mediaLibrary = this;
        synchronized (mediaLibrary) {
            HashMap newEntries = (HashMap)this.entries.clone();
            ent = (MediaLibraryEntry)newEntries.remove(new Integer(id));
            this.entries = newEntries;
        }
        return ent;
    }

    public boolean contains(int id) {
        return this.entries.containsKey(new Integer(id));
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public int size() {
        return this.entries.size();
    }

    public void startPlaying(int id) {
        MediaLibraryEntry ent = this.get(id);
        if (ent != null) {
            ent.startPlaying();
        }
        this.startHook(id);
    }

    public void stopPlaying(int id) {
        MediaLibraryEntry ent = this.get(id);
        if (ent != null) {
            ent.stopPlaying();
        }
        this.stopHook(id);
    }

    protected void startHook(int id) {
    }

    protected void stopHook(int id) {
    }

    public abstract void remove(int var1);

    public abstract void onChannelData(ChannelDataEvent var1);

    public abstract void transmitStatusChange(TransmitStatusEvent var1);

    public abstract void addProxy(short var1);

    public abstract void removeProxy(short var1);

    private int computeWindow(short addr) {
        return 32000;
    }

    protected Connection getConnection() {
        if (this.channel == null) {
            return null;
        }
        return this.channel.getConnection();
    }

    public Object getLock() {
        if (this.channel == null) {
            return this;
        }
        return this.getConnection().getMessageLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ArrayList<MediaLibraryEntry> disposal = new ArrayList<MediaLibraryEntry>();
        MediaLibrary mediaLibrary = this;
        synchronized (mediaLibrary) {
            Iterator i = this.entries.values().iterator();
            while (i.hasNext()) {
                MediaLibraryEntry entry = (MediaLibraryEntry)i.next();
                i.remove();
                disposal.add(entry);
            }
        }
        Iterator i = disposal.iterator();
        while (i.hasNext()) {
            MediaLibraryEntry entry = (MediaLibraryEntry)i.next();
            i.remove();
            entry.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnectProxy(StreamProxy proxy) {
        short addr = proxy.getAddress();
        MediaLibrary mediaLibrary = this;
        synchronized (mediaLibrary) {
            for (MediaLibraryEntry entry : this.entries.values()) {
                proxy.disconnect(entry);
                if (entry.getSource() != addr) continue;
                entry.setSource((short)-32767);
            }
        }
    }

    protected void sendError(short addr, String msg, String context, String details) {
        if (addr == -32767) {
            LogSupport.error((Object)this, (String)"sendError", (String)this.i18n.getStringLegacy(msg, new Object[]{context, details}));
            return;
        }
        try {
            ChannelDataEvent e = ChannelDataEvent.getInstance((Object)this, (short)addr, (byte)25);
            DataOutputStream str = e.write();
            str.writeUTF(msg);
            str.writeUTF(context);
            str.writeUTF(details);
            str.close();
            this.channel.onChannelData(e);
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"sendError", (Throwable)ex, (boolean)true);
        }
    }
}

