/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.swingsupport;

import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class WBLineBorder
extends AbstractBorder {
    private AbstractToolModel tool = null;
    private boolean borderPainted = true;

    public WBLineBorder(AbstractToolModel tool) {
        if (tool == null) {
            throw new NullPointerException("null tool not allowed");
        }
        this.tool = tool;
    }

    public AbstractToolModel getTool() {
        return this.tool;
    }

    public Color getLineColor() {
        return (Color)this.tool.getColor().getColor();
    }

    public int getThickness() {
        return Math.round(((BasicStroke)this.tool.getStroke().getStroke()).getLineWidth());
    }

    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    public void setBorderPainted(boolean b) {
        this.borderPainted = b;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets ins) {
        ins.top = ins.bottom = this.getThickness();
        ins.right = ins.bottom;
        ins.left = ins.bottom;
        return ins;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!this.borderPainted) {
            return;
        }
        int thickness = 1;
        BasicStroke stroke = null;
        Color color = Color.BLACK;
        if (this.tool != null) {
            stroke = (BasicStroke)this.tool.getStroke().getStroke();
            thickness = Math.round(stroke.getLineWidth());
            color = (Color)this.tool.getColor().getColor();
        }
        Graphics2D g2 = null;
        try {
            g2 = (Graphics2D)g.create();
            if (color != null) {
                g2.setColor(color);
            }
            if (stroke != null) {
                g2.setStroke(stroke);
            }
            g2.drawRect(x, y, width - 1, height - 1);
        }
        finally {
            if (g2 != null) {
                g2.dispose();
            }
        }
    }
}

