/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.groupware.whiteboard.AttributeChangeListener;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.AttributeEditorInterface;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ToolActivationListener;
import com.elluminate.groupware.whiteboard.interfaces.ToolSelectionListener;
import com.elluminate.groupware.whiteboard.module.WhiteboardBean;
import com.elluminate.groupware.whiteboard.module.WhiteboardModule;
import com.elluminate.groupware.whiteboard.module.ui.VerticalFlowLayout;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.AbstractToolEditorUI;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.QuickColorPanel;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.QuickEditorPanel;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.QuickStrokePanel;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.TabPropertiesChangeListener;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.ToolFontEditorUI;
import com.elluminate.groupware.whiteboard.module.ui.menu.QuickEditorInterface;
import com.elluminate.groupware.whiteboard.module.ui.menu.StringsProperties;
import com.elluminate.groupware.whiteboard.module.ui.menu.ToolPropertiesPanelInterface;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.GroupToolChangeEvent;
import com.elluminate.groupware.whiteboard.tools.GroupToolChangeListener;
import com.elluminate.groupware.whiteboard.tools.GroupToolModel;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.TargetLayoutSize;
import com.elluminate.gui.component.GrowableHeightPlaceholder;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;

public class ToolPropertiesPanel
extends JPanel
implements AttributeChangeListener,
TabPropertiesChangeListener,
ToolSelectionListener,
GroupToolChangeListener,
ToolActivationListener {
    private static I18n i18n = I18n.create((Object)new Object(){});
    private static final boolean AUTO_APPLY_DEFAULT = true;
    private static final int TAB_PLACEMENT = 1;
    private WhiteboardContext context;
    private ScreenModel screen;
    private HashMap tabMap = new HashMap();
    private LinkedList snapins = new LinkedList();
    private HashSet toolSlipTools = new HashSet();
    private LinkedList tools = new LinkedList();
    private ToolPropertiesPanelInterface owner;
    private JPanel dialogPanel = new JPanel(new BorderLayout(0, 6));
    private JTabbedPane propertiesPanel = new JTabbedPane();
    private JPanel buttonPanel = new JPanel(new GridBagLayout());
    private JButton okButton = new JButton();
    private JButton applyButton = new JButton();
    private JButton cancelButton = new JButton();
    private JComponent quickEditorsPanel = null;
    private boolean setAutoApply = false;
    private boolean modifyDefault = true;
    private int suppressApply = 0;
    private LinkedList quickEditors = new LinkedList();
    private boolean evaluating = false;
    private TabPropertiesChangeListener quickTabListener = new QuickTabPropertiesChangeListener();
    private FeatureBroker broker;
    private ComponentFeature quickEditorsFeature;

    public ToolPropertiesPanel(WhiteboardContext context, ScreenModel screen, ToolPropertiesPanelInterface owner) {
        super(new BorderLayout());
        this.context = context;
        this.screen = screen;
        this.owner = owner;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"constructor", (Throwable)ex, (boolean)true);
        }
        context.addAttributeChangeListener((AttributeChangeListener)this);
    }

    private void jbInit() throws Exception {
        this.add((Component)this.dialogPanel, "Center");
        this.okButton.setText(i18n.getString((PropertiesEnum)StringsProperties.TOOLPROPERTIESDIALOG_OKTEXT));
        this.applyButton.setText(i18n.getString((PropertiesEnum)StringsProperties.TOOLPROPERTIESDIALOG_APPLYTEXT));
        this.cancelButton.setText(i18n.getString((PropertiesEnum)StringsProperties.TOOLPROPERTIESDIALOG_CANCELTEXT));
        this.buttonPanel.add((Component)new JPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JButton b = this.okButton;
        if (Platform.getLAF() == 502) {
            b = this.cancelButton;
        }
        this.buttonPanel.add((Component)b, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 6, 6), 0, 0));
        this.buttonPanel.add((Component)this.applyButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 6, 6), 0, 0));
        b = this.cancelButton;
        if (Platform.getLAF() == 502) {
            b = this.okButton;
        }
        this.buttonPanel.add((Component)b, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 6, 0), 0, 0));
        this.buttonPanel.add((Component)new JPanel(), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolPropertiesPanel.this.okButtonAction(e);
            }
        });
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolPropertiesPanel.this.applyButtonAction(e);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolPropertiesPanel.this.cancelButtonAction(e);
            }
        });
        this.dialogPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 0, 2));
        this.dialogPanel.add((Component)this.propertiesPanel, "Center");
        this.dialogPanel.add((Component)this.buttonPanel, "South");
        if (this.screen != null) {
            this.populateProperties(this.screen);
        }
        this.propertiesPanel.setTabPlacement(1);
    }

    public JComponent quickEditorsFactory(FeatureBroker broker) {
        if (this.quickEditorsPanel == null) {
            try {
                this.quickEditorsPanel = new QuickEditorsContainer();
                GrowableHeightPlaceholder mock = new GrowableHeightPlaceholder();
                QuickColorPanel colorPanel = new QuickColorPanel(this.context);
                QuickStrokePanel stroke = new QuickStrokePanel(this.context);
                ToolFontEditorUI fonts = new ToolFontEditorUI();
                fonts.add((Component)new JSeparator(1), 0);
                stroke.add((Component)new JSeparator(1), 0);
                colorPanel.setOpaque(false);
                stroke.setOpaque(false);
                fonts.setOpaque(false);
                this.quickEditorsPanel.addContainerListener((ContainerListener)mock);
                this.quickEditorsPanel.add((Component)mock);
                this.quickEditorsPanel.add(colorPanel);
                this.quickEditorsPanel.add(stroke);
                this.quickEditorsPanel.add(fonts);
                fonts.setContext(this.context);
                this.quickEditors.add(colorPanel);
                this.quickEditors.add(stroke);
                this.quickEditors.add(fonts);
                colorPanel.validateQuickVisibility();
                stroke.validateQuickVisibility();
                fonts.validateQuickVisibility();
                colorPanel.addTabPropertiesChangeListener(this.quickTabListener);
                stroke.addTabPropertiesChangeListener(this.quickTabListener);
                fonts.addTabPropertiesChangeListener(this.quickTabListener);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"quickEditorsFactory", (Throwable)ex, (boolean)true);
            }
        }
        if (broker != null && this.quickEditorsFeature == null) {
            this.broker = broker;
            ComponentAdapter evalListener = new ComponentAdapter(){
                private Runnable evaluator = new Runnable(){

                    @Override
                    public void run() {
                        ToolPropertiesPanel.this.evaluateQuickEditorPublication();
                    }
                };

                @Override
                public void componentHidden(ComponentEvent ev) {
                    SwingRunnerSupport.invokeLater((Runnable)this.evaluator);
                }
            };
            for (Object obj : this.quickEditors) {
                if (!(obj instanceof QuickEditorPanel)) continue;
                QuickEditorPanel qEdPan = (QuickEditorPanel)obj;
                qEdPan.addComponentListener(evalListener);
            }
            WhiteboardModule wbdMod = ((WhiteboardBean)this.context.getBean()).getModule();
            String name = i18n.getString((PropertiesEnum)StringsProperties.TOOLPROPERTIESDIALOG_DIALOGTITLE);
            this.quickEditorsFeature = broker.createComponentFeature((Object)wbdMod, "/whiteboard/ui/quickEditors", (Component)this.quickEditorsPanel, name, null);
            this.evaluateQuickEditorPublication();
        }
        return this.quickEditorsPanel;
    }

    public void setToolSlipTool(AbstractToolModel tool, boolean isTemplate) {
        if (!(tool == null || isTemplate && !this.modifyDefault || this.toolSlipTools.contains(tool))) {
            this.toolSlipTools.add(tool);
            this.setAutoApply = !this.toolSlipTools.isEmpty();
            this.addTool(tool);
            this.setAutoApply(this.setAutoApply);
            this.evaluateQuickEditorPublication();
        }
    }

    public void unsetToolSlipTool(AbstractToolModel tool) {
        if (tool != null && this.toolSlipTools.contains(tool)) {
            this.removeTool(tool);
        }
        this.toolSlipTools.remove(tool);
        this.setAutoApply(!this.toolSlipTools.isEmpty());
        this.evaluateQuickEditorPublication();
    }

    public void clearToolSlipTools() {
        Iterator iter = this.toolSlipTools.iterator();
        while (iter.hasNext()) {
            AbstractToolModel tool = (AbstractToolModel)iter.next();
            this.removeTool(tool);
            iter.remove();
        }
        this.setAutoApply(!this.toolSlipTools.isEmpty());
        this.evaluateQuickEditorPublication();
    }

    private void setAutoApply(boolean setAutoApply) {
        this.setAutoApply = setAutoApply;
        if (setAutoApply == this.applyButton.isVisible()) {
            this.okButton.setVisible(!setAutoApply);
            this.applyButton.setVisible(!setAutoApply);
        }
    }

    public void populateProperties(ScreenModel screen) {
        boolean addSelection;
        boolean bl = addSelection = screen != this.screen;
        if (this.screen != null) {
            this.screen.removeToolSelectionListener((ToolSelectionListener)this);
        }
        if (addSelection) {
            AbstractToolModel[] toolArray = new AbstractToolModel[this.tools.size()];
            toolArray = this.tools.toArray(toolArray);
            for (int i = 0; i < toolArray.length; ++i) {
                this.removeTool(toolArray[i]);
            }
        }
        if (screen != null) {
            Iterator iter = screen.getSelectedToolListIterator();
            while (iter.hasNext()) {
                this.addTool((AbstractToolModel)iter.next());
            }
            if (addSelection) {
                screen.addToolSelectionListener((ToolSelectionListener)this);
            }
        }
        this.screen = screen;
        this.evaluateQuickEditorPublication();
    }

    private void addTool(AbstractToolModel tool) {
        if (tool instanceof GroupToolModel) {
            for (int i = 0; i < tool.getChildCount(); ++i) {
                if (!(tool.getChildAt(i) instanceof AbstractToolModel)) continue;
                this.addTool((AbstractToolModel)tool.getChildAt(i));
            }
            ((GroupToolModel)tool).addGroupToolChangeListener((GroupToolChangeListener)this);
        } else {
            ++this.suppressApply;
            if (!this.okButton.isEnabled()) {
                this.okButton.setEnabled(true);
            }
            if (this.applyButton.isEnabled()) {
                this.applyButton.setEnabled(false);
            }
            try {
                for (AbstractAttribute attribute : tool.getAttributeList()) {
                    if (attribute.isDisplayEditorOnActivation()) continue;
                    this.addToPanel(attribute);
                }
                this.tools.add(tool);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"addTool", (Throwable)ex, (boolean)true);
            }
            --this.suppressApply;
        }
    }

    private void removeTool(AbstractToolModel tool) {
        if (tool instanceof GroupToolModel) {
            ((GroupToolModel)tool).removeGroupToolChangeListener((GroupToolChangeListener)this);
            for (int i = 0; i < tool.getChildCount(); ++i) {
                if (!(tool.getChildAt(i) instanceof AbstractToolModel)) continue;
                this.removeTool((AbstractToolModel)tool.getChildAt(i));
            }
        } else {
            List activeOnlyAttributes = tool.getActiveAttributes();
            ++this.suppressApply;
            if (!this.okButton.isEnabled()) {
                this.okButton.setEnabled(true);
            }
            if (this.applyButton.isEnabled()) {
                this.applyButton.setEnabled(false);
            }
            try {
                if (this.tools.remove(tool)) {
                    for (AbstractAttribute attribute : tool.getAttributeList()) {
                        if (activeOnlyAttributes.contains(attribute)) continue;
                        this.removeFromPanel(attribute);
                    }
                }
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"removeTool", (Throwable)ex, (boolean)true);
            }
            --this.suppressApply;
        }
    }

    public void groupToolAdded(GroupToolChangeEvent e) {
        GroupToolModel grp = (GroupToolModel)e.getSource();
        WBNode node = e.getTool();
        if (node instanceof AbstractToolModel && this.tools.contains(grp) && !this.tools.contains(node)) {
            this.addTool((AbstractToolModel)node);
        }
        this.evaluateQuickEditorPublication();
    }

    public void groupToolRemoved(GroupToolChangeEvent e) {
        WBNode node = e.getTool();
        if (node instanceof AbstractToolModel && this.tools.contains(node)) {
            this.removeTool((AbstractToolModel)node);
        }
        this.evaluateQuickEditorPublication();
    }

    private void addToPanel(AbstractAttribute attribute) {
        if (attribute.getPanelKey() != null && attribute.getEditorUI() != null) {
            if (attribute.needsEditor()) {
                int tabIndex;
                ContentPanel housing;
                TabPanel tabPanel = (TabPanel)this.tabMap.get(attribute.getPanelKey());
                if (tabPanel == null) {
                    tabPanel = new TabPanel(attribute);
                    this.tabMap.put(attribute.getPanelKey(), tabPanel);
                    housing = new ContentPanel();
                    for (tabIndex = 0; tabIndex < this.propertiesPanel.getTabCount() && this.propertiesPanel.getTitleAt(tabIndex).compareTo(attribute.getTabName()) <= 0; ++tabIndex) {
                    }
                    this.propertiesPanel.insertTab(attribute.getTabName(), attribute.getTabIcon(), housing, attribute.getTabToolTip(), tabIndex);
                } else {
                    tabIndex = this.propertiesPanel.indexOfTab(attribute.getTabName());
                    housing = (ContentPanel)this.propertiesPanel.getComponentAt(tabIndex);
                }
                if (tabPanel.addAttribute(attribute)) {
                    housing.addSnapin(tabPanel.getPanel(attribute));
                    this.owner.pack();
                    this.repaint();
                }
                if (!tabPanel.isEmpty() && !this.propertiesPanel.isEnabledAt(tabIndex)) {
                    this.propertiesPanel.setEnabledAt(tabIndex, !tabPanel.isEmpty());
                    int oldIndex = this.propertiesPanel.getSelectedIndex();
                    if (!this.propertiesPanel.isEnabledAt(oldIndex)) {
                        this.propertiesPanel.setSelectedIndex(tabIndex);
                    }
                }
            }
            this.quickEditorsAddAttribute(attribute);
        }
    }

    private void quickEditorsAddAttribute(AbstractAttribute attribute) {
        for (Object object : this.quickEditors) {
            if (!(object instanceof QuickEditorInterface)) continue;
            ((QuickEditorInterface)object).addQuickAttribute(attribute, this);
        }
    }

    private void removeFromPanel(AbstractAttribute attribute) {
        if (attribute.getPanelKey() != null) {
            this.quickEditorsRemoveAttribute(attribute);
            TabPanel tabPanel = (TabPanel)this.tabMap.get(attribute.getPanelKey());
            if (tabPanel != null) {
                int tabIndex = this.propertiesPanel.indexOfTab(attribute.getTabName());
                JPanel snapin = tabPanel.getPanel(attribute);
                if (snapin != null && tabPanel.removeAttribute(attribute)) {
                    ContentPanel housing = (ContentPanel)this.propertiesPanel.getComponentAt(tabIndex);
                    housing.removeSnapin(snapin);
                    if (housing.isEmpty()) {
                        this.propertiesPanel.removeTabAt(tabIndex);
                        this.tabMap.remove(attribute.getPanelKey());
                        this.revalidate();
                    }
                }
                if (tabPanel.isEmpty() && this.propertiesPanel.isEnabledAt(tabIndex)) {
                    this.propertiesPanel.setEnabledAt(tabIndex, false);
                    for (int i = 0; i < this.propertiesPanel.getTabCount(); ++i) {
                        if (!this.propertiesPanel.isEnabledAt(i)) continue;
                        this.propertiesPanel.setSelectedIndex(i);
                        break;
                    }
                }
            }
        }
    }

    private void quickEditorsRemoveAttribute(AbstractAttribute attribute) {
        for (Object object : this.quickEditors) {
            if (!(object instanceof QuickEditorInterface)) continue;
            ((QuickEditorInterface)object).removeQuickAttribute(attribute);
        }
    }

    private boolean applyChanges() {
        boolean error = false;
        for (AttributeEditorInterface ui : this.snapins) {
            if (ui.isApplyValid()) continue;
            ModalDialog.showMessageDialog((Component)this, (Object)i18n.getString((PropertiesEnum)StringsProperties.TOOLPROPERTIESDIALOG_SNAPINERROR, new Object[]{ui.getDisplayName(), ui.getTabName()}), (String)i18n.getString((PropertiesEnum)StringsProperties.TOOLPROPERTIESDIALOG_SNAPINERRORTITLE), (int)0);
            error = true;
        }
        if (!error) {
            if (!this.okButton.isEnabled()) {
                this.okButton.setEnabled(true);
            }
            if (this.applyButton.isEnabled()) {
                this.applyButton.setEnabled(false);
            }
            Iterator iter = this.snapins.iterator();
            while (iter.hasNext()) {
                ((AttributeEditorInterface)iter.next()).applyChanges();
            }
            this.evaluateAttributes();
        }
        return !error;
    }

    private void processQuickChange(AbstractToolEditorUI ui) {
        if (ui.isApplyValid()) {
            ui.applyChanges();
        }
        this.evaluateAttributes();
        this.context.getController().requestFocus();
    }

    @Override
    public void onEvaluate(AbstractToolEditorUI ui) {
        if (!this.evaluating) {
            this.evaluateAttributes();
        }
    }

    public void onAttributeChange(AbstractAttribute attribute) {
        if (!this.evaluating) {
            this.evaluateAttributes();
        }
    }

    public void evaluateAttributes() {
        Iterator iter = this.snapins.iterator();
        while (iter.hasNext()) {
            ((AttributeEditorInterface)iter.next()).evaluateAttributes();
        }
        iter = this.quickEditors.iterator();
        while (iter.hasNext()) {
            ((AttributeEditorInterface)iter.next()).evaluateAttributes();
        }
        this.evaluateQuickEditorPublication();
    }

    public void evaluateQuickEditorPublication() {
        if (this.broker != null && this.quickEditorsFeature != null) {
            boolean published = false;
            for (Object obj : this.quickEditors) {
                AbstractToolEditorUI qEd;
                if (!(obj instanceof AbstractToolEditorUI) || !(qEd = (AbstractToolEditorUI)obj).isVisible()) continue;
                published = true;
            }
            this.broker.setFeaturePublished((Feature)this.quickEditorsFeature, published);
        }
    }

    private void okButtonAction(ActionEvent e) {
        this.applyChanges();
        this.exitDialog();
    }

    private void applyButtonAction(ActionEvent e) {
        this.applyChanges();
    }

    private void cancelButtonAction(ActionEvent e) {
        this.exitDialog();
    }

    private void exitDialog() {
        this.owner.setVisible(false);
    }

    @Override
    public void onTabPropertiesChange(AbstractToolEditorUI ui) {
        if (this.suppressApply == 0) {
            if (this.setAutoApply) {
                this.applyChanges();
            } else {
                if (!this.okButton.isEnabled()) {
                    this.okButton.setEnabled(true);
                }
                if (!this.applyButton.isEnabled()) {
                    this.applyButton.setEnabled(true);
                }
            }
        }
        this.context.getController().requestFocus();
    }

    public void onSelectTool(AbstractToolModel tool) {
        this.addTool(tool);
        this.evaluateQuickEditorPublication();
    }

    public void onDeSelectTool(AbstractToolModel tool) {
        this.removeTool(tool);
        this.evaluateQuickEditorPublication();
    }

    public AbstractToolEditorUI getQuickEditor(String className) {
        Class<?> cl = null;
        try {
            cl = Class.forName(className);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)("Looking for Quick Editor: " + className), (Throwable)ex, (boolean)true);
            return null;
        }
        AbstractToolEditorUI editor = null;
        for (AbstractToolEditorUI checkEditor : this.quickEditors) {
            if (checkEditor.getClass() != cl) continue;
            editor = checkEditor;
            break;
        }
        return editor;
    }

    public void onActivateTool(AbstractToolModel tool) {
        try {
            for (AbstractAttribute attribute : tool.getActiveAttributes()) {
                this.addToPanel(attribute);
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"onActivateTool", (Throwable)ex, (boolean)true);
        }
        this.evaluateQuickEditorPublication();
    }

    public void onDeActivateTool(AbstractToolModel tool) {
        try {
            for (AbstractAttribute attribute : tool.getActiveAttributes()) {
                this.removeFromPanel(attribute);
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"onDeActivateTool", (Throwable)ex, (boolean)true);
        }
        this.evaluateQuickEditorPublication();
    }

    class ContentPanel
    extends JPanel {
        JPanel topPanel = new JPanel(new VerticalFlowLayout(5, 3, 1));
        JPanel fillerPanel = new JPanel();
        int snapinCount = 0;

        public ContentPanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.topPanel, "North");
            this.add((Component)this.fillerPanel, "Center");
        }

        public void addSnapin(JPanel panel) {
            this.topPanel.add(panel);
            ++this.snapinCount;
        }

        public void removeSnapin(JPanel panel) {
            this.topPanel.remove(panel);
            --this.snapinCount;
        }

        public boolean isEmpty() {
            return this.snapinCount == 0;
        }
    }

    private class QuickEditorsContainer
    extends JPanel
    implements TargetLayoutSize {
        QuickEditorsContainer() {
            this.setLayout(new BoxLayout(this, 0));
        }

        public Dimension getTargetLayoutSize() {
            int width = 0;
            int maxAscent = 0;
            int maxDescent = 0;
            for (Component c : this.getComponents()) {
                if (!c.isVisible()) continue;
                Dimension size = c instanceof QuickEditorPanel ? ((QuickEditorPanel)c).getTargetSize() : c.getPreferredSize();
                width += size.width;
                float align = c.getAlignmentY();
                int ascent = (int)(align * (float)size.height);
                int descent = size.height - ascent;
                maxAscent = Math.max(maxAscent, ascent);
                maxDescent = Math.max(maxDescent, descent);
            }
            Insets ins = this.getInsets();
            return new Dimension(width + ins.left + ins.right, maxAscent + maxDescent + ins.top + ins.bottom);
        }
    }

    private class QuickTabPropertiesChangeListener
    implements TabPropertiesChangeListener {
        private QuickTabPropertiesChangeListener() {
        }

        @Override
        public void onTabPropertiesChange(AbstractToolEditorUI ui) {
            ToolPropertiesPanel.this.evaluating = true;
            ToolPropertiesPanel.this.processQuickChange(ui);
            ToolPropertiesPanel.this.evaluating = false;
        }

        @Override
        public void onEvaluate(AbstractToolEditorUI ui) {
            ToolPropertiesPanel.this.onEvaluate(ui);
        }
    }

    class TabPanel {
        HashMap attributeMap = new HashMap();
        int enabledUIs = 0;

        public TabPanel(AbstractAttribute attribute) {
        }

        public JPanel getPanel(AbstractAttribute attribute) {
            return (JPanel)this.attributeMap.get(attribute.getDisplayName());
        }

        public boolean addAttribute(AbstractAttribute attribute) {
            boolean instanceCreated = false;
            AttributeEditorInterface ui = (AttributeEditorInterface)this.attributeMap.get(attribute.getDisplayName());
            if (ui == null) {
                ui = attribute.getEditorUI().newInstance();
                this.attributeMap.put(attribute.getDisplayName(), ui);
                instanceCreated = true;
                ToolPropertiesPanel.this.snapins.add(ui);
                ui.addTabPropertiesChangeListener((Object)ToolPropertiesPanel.this);
                if (ui.getBorder() instanceof TitledBorder) {
                    ((TitledBorder)ui.getBorder()).setTitle(attribute.getDisplayName());
                }
            }
            ui.addAttribute(attribute);
            ++this.enabledUIs;
            return instanceCreated;
        }

        public boolean removeAttribute(AbstractAttribute attribute) {
            AttributeEditorInterface ui = (AttributeEditorInterface)this.attributeMap.get(attribute.getDisplayName());
            if (ui == null) {
                LogSupport.error((Object)this, (String)"removeAttribute", (String)("no ui for: " + attribute));
            }
            if (ui == null || ui.removeAttribute(attribute)) {
                // empty if block
            }
            --this.enabledUIs;
            return !this.attributeMap.containsKey(attribute.getDisplayName());
        }

        public boolean isEmpty() {
            return this.enabledUIs == 0;
        }
    }
}

