/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.module.ui.AccessibleListener;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.module.ui.menu.ScreenPropertiesPanel;
import com.elluminate.groupware.whiteboard.module.ui.menu.ScreenPropertiesPanelListener;
import com.elluminate.groupware.whiteboard.module.ui.menu.StringsProperties;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.tree.TreePath;

public class ScreenPropertiesDialog
extends EasyDialog
implements AccessibleListener,
ScreenPropertiesPanelListener {
    private static I18n i18n = I18n.create((Object)new Object(){});
    private ScreenPropertiesPanel propertiesPanel;
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton applyButton = new JButton();
    private TreePath[] paths;
    private boolean haveChanges = false;
    private WhiteboardContext context;

    public ScreenPropertiesDialog(WhiteboardContext context, TreePath[] paths) {
        super((Component)context.getDialogParentFrame(), i18n.getString((PropertiesEnum)StringsProperties.SCREENPROPERTIESDIALOG_TITLE), true);
        this.setResizable(true);
        this.context = context;
        this.paths = paths;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"constructor", (Throwable)ex, (boolean)true);
        }
        ((ControllerPane)context.getController()).addAccessibleListener(this);
    }

    private void jbInit() throws Exception {
        this.propertiesPanel = new ScreenPropertiesPanel(this.context, this);
        this.propertiesPanel.populateScreens(this.paths);
        this.okButton.setText(i18n.getString((PropertiesEnum)StringsProperties.SCREENPROPERTIESDIALOG_OKTEXT));
        this.cancelButton.setText(i18n.getString((PropertiesEnum)StringsProperties.SCREENPROPERTIESDIALOG_CANCELTEXT));
        this.applyButton.setText(i18n.getString((PropertiesEnum)StringsProperties.SCREENPROPERTIESDIALOG_APPLYTEXT));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScreenPropertiesDialog.this.okButtonAction(e);
            }
        });
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScreenPropertiesDialog.this.applyButtonAction(e);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScreenPropertiesDialog.this.cancelButtonAction(e);
            }
        });
        this.setHaveChanges(this.haveChanges);
        this.setContent(this.propertiesPanel);
        this.addActionButton(this.okButton, true);
        this.addAlternateActionButton(this.applyButton);
        this.addCancelButton(this.cancelButton);
    }

    private void setHaveChanges(boolean changes) {
        this.haveChanges = changes;
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ScreenPropertiesDialog.this.applyButton.setEnabled(ScreenPropertiesDialog.this.haveChanges && ScreenPropertiesDialog.this.propertiesPanel.isSizeValid());
            }
        });
    }

    @Override
    public void onScreenPropertiesPanel() {
        this.setHaveChanges(true);
    }

    private void okButtonAction(ActionEvent e) {
        if (this.haveChanges && this.propertiesPanel.isSizeValid()) {
            this.setVisible(!this.propertiesPanel.updateScreens());
            this.updateChange();
        } else {
            this.setVisible(false);
        }
    }

    private void cancelButtonAction(ActionEvent e) {
        this.setVisible(false);
    }

    private void applyButtonAction(ActionEvent e) {
        this.setHaveChanges(false);
        if (this.propertiesPanel.updateScreens()) {
            this.propertiesPanel.populateScreens(this.paths);
        }
        this.updateChange();
    }

    private void updateChange() {
        this.context.getController().processScaleChange();
    }

    @Override
    public void onAccessible(boolean accessible) {
        if (!accessible) {
            ((ControllerPane)this.context.getController()).removeAccessibleListener(this);
            this.setVisible(false);
        }
    }
}

