/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ControllerPaneInterface;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.module.ui.ScreenGotoListener;
import com.elluminate.groupware.whiteboard.module.ui.menu.WBAbstractAction;
import java.awt.event.ActionEvent;

public class PrevScreenAction
extends WBAbstractAction
implements ScreenGotoListener {
    public PrevScreenAction(WhiteboardContext context) {
        super(context, null, "PrevScreenMenu");
        ((ControllerPane)context.getController()).getCanvas().addScreenGotoListener(this);
        this.updateEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.performAction();
    }

    @Override
    public void actionPerformed(ActionFeatureEvent e) {
        this.performAction();
    }

    private void performAction() {
        ControllerPaneInterface ctlr = this.context.getController();
        ScreenModel scr = this.getPrevScreen((WBNode)ctlr.getScreen());
        if (scr instanceof ScreenModel) {
            ctlr.gotoUIScreen(scr.getObjectID(), false);
        }
    }

    private ScreenModel getPrevScreen(WBNode currentScreen) {
        WBNode parent = currentScreen.getBoardParent();
        if (parent != null) {
            int index = currentScreen.getIndex();
            for (int i = index - 1; i >= 0; --i) {
                WBNode scr = parent.getChildAt(i);
                if (!(scr instanceof ScreenModel)) continue;
                return (ScreenModel)scr;
            }
        }
        return null;
    }

    private void updateEnabled() {
        ScreenModel currentScreen;
        WBNode parent;
        if (this.context.getController().canNavigate() && (parent = (currentScreen = this.context.getController().getScreen()).getBoardParent()) != null) {
            int index = currentScreen.getIndex();
            for (int i = index - 1; i >= 0; --i) {
                WBNode scr = parent.getChildAt(i);
                if (!(scr instanceof ScreenModel)) continue;
                this.setEnabled(true);
                return;
            }
        }
        this.setEnabled(false);
    }

    @Override
    public void onScreenGoto(ScreenModel oldScreen, ScreenModel newScreen) {
        this.updateEnabled();
    }
}

