/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.module.PrintWhiteboardWriter;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.module.ui.menu.PathSelectionDialog;
import com.elluminate.groupware.whiteboard.module.ui.menu.StringsProperties;
import com.elluminate.groupware.whiteboard.module.ui.menu.WBAbstractAction;
import com.elluminate.gui.ModalDialog;
import com.elluminate.util.PropertiesEnum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.tree.TreePath;

public class NavPrintAction
extends WBAbstractAction {
    TreePath[] paths;
    TreePath[] pathsToProcess;
    int depth;
    int selectedDepth;
    PathSelectionDialog selectionDialog = null;

    public NavPrintAction(WhiteboardContext context, Object housing, TreePath[] paths, int depth) {
        super(context, housing, "NavPrintAction");
        this.depth = depth;
        this.setPaths(paths);
    }

    public void setPaths(TreePath[] paths) {
        this.paths = paths;
    }

    @Override
    public boolean isInteractive() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.performAction();
    }

    @Override
    public void actionPerformed(ActionFeatureEvent e) {
        this.performAction();
    }

    private void performAction() {
        if (this.context.getController().isProprietary()) {
            ModalDialog.showMessageDialogAsync((int)-1, (Component)this.context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.NAVPRINTACTION_PROPRIETARYSAVE), (String)i18n.getString((PropertiesEnum)StringsProperties.NAVPRINTACTION_PROPRIETARYSAVETITLE), (int)1);
            return;
        }
        this.pathsToProcess = this.paths;
        this.selectedDepth = this.depth;
        if (this.selectionDialog == null) {
            this.selectionDialog = new PathSelectionDialog(this.context, 1, true, true, true);
        }
        if (this.pathsToProcess == null || this.pathsToProcess.length == 0) {
            this.selectionDialog.setDepthNeeded(false);
            this.selectionDialog.setVisible(this.pathsToProcess, this.depth);
            if (this.selectionDialog.isCancelled()) {
                return;
            }
            this.pathsToProcess = this.selectionDialog.getPaths();
            this.selectedDepth = this.selectionDialog.getDepth();
            if (this.depth < Integer.MAX_VALUE) {
                this.depth = this.selectedDepth;
            }
        }
        if (this.context.getController().isProprietary()) {
            return;
        }
        if (this.pathsToProcess == null || this.pathsToProcess.length == 0) {
            ModalDialog.showMessageDialogAsync((int)-1, (Component)this.context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.EXPORTACTIONS_NOPATHS), (String)i18n.getString((PropertiesEnum)StringsProperties.EXPORTACTIONS_NOPATHSTITLE), (int)0);
            return;
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat printerPageFormat = null;
        if (printerJob != null) {
            printerPageFormat = printerJob.defaultPage();
            printerPageFormat.setOrientation(0);
        }
        if (printerJob != null) {
            printerPageFormat = printerJob.pageDialog(printerPageFormat);
        }
        Book printerBook = new Book();
        this.pathsToProcess = ActionUtilities.orderPaths((TreePath[])this.pathsToProcess, (WhiteboardContext)this.context);
        if (!((ControllerPane)this.context.getController()).isProprietary()) {
            PrintWhiteboardWriter writer = new PrintWhiteboardWriter(this.pathsToProcess, this.selectedDepth);
            printerBook.append(writer, printerPageFormat, writer.getScreenCount());
            if (printerJob != null) {
                printerJob.setPageable(printerBook);
                if (printerJob.printDialog()) {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException pE) {
                        ModalDialog.showMessageDialogAsync((int)-1, (Component)this.context.getDialogParentFrame(), (Object)i18n.getString((PropertiesEnum)StringsProperties.NAVPRINTACTION_PRINTEXCEPTION, new Object[]{pE.getMessage()}), (String)i18n.getString((PropertiesEnum)StringsProperties.NAVPRINTACTION_PRINTEXCEPTIONTITLE), (int)0);
                    }
                }
            }
        }
    }
}

