/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.menu;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.module.ui.menu.WBAbstractAction;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import java.awt.event.ActionEvent;
import java.util.Iterator;

public class AlignMiddleAction
extends WBAbstractAction {
    ScreenModel screen;

    public AlignMiddleAction(WhiteboardContext context, Object housing, ScreenModel screen) {
        super(context, housing, "AlignMiddleAction");
        this.setScreen(screen);
    }

    public void setScreen(ScreenModel screen) {
        this.screen = screen;
        this.setEnabled(screen != null && screen.getSelectedToolList().size() > 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        double xHorizontalMiddle;
        Iterator iter = this.screen.getSelectedToolList().iterator();
        if (this.screen.getSelectedToolCount() == 1) {
            xHorizontalMiddle = (double)this.screen.getScreenSize().width / 2.0;
        } else {
            AbstractToolModel anchor = (AbstractToolModel)iter.next();
            xHorizontalMiddle = anchor.getLocation().getX() + anchor.getSize().getWidth() / 2.0;
        }
        while (iter.hasNext()) {
            AbstractToolModel tool = (AbstractToolModel)iter.next();
            if (xHorizontalMiddle - tool.getSize().getWidth() / 2.0 == tool.getLocation().getX()) continue;
            tool.setLocation(xHorizontalMiddle - tool.getSize().getWidth() / 2.0, tool.getLocation().getY());
        }
    }
}

