/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.dnd;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.GeometryUtils;
import com.elluminate.groupware.whiteboard.dataModel.ImageWriterGraphics;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.NoUIProgress;
import com.elluminate.groupware.whiteboard.xml.WhiteboardDataFile;
import com.elluminate.util.log.LogSupport;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class WBNodeSelection
implements Transferable {
    private String selectionXML = null;
    private Image selectionImage = null;
    private WhiteboardContext context = null;
    private static int wrapper = 10;
    public static final DataFlavor wbXMLFlavor = new DataFlavor("application/x-java-serialized-object;source=Elluminate;class=java.io.BufferedInputStream", "WBXMLString");
    private static DataFlavor[] flavors = new DataFlavor[]{wbXMLFlavor, DataFlavor.imageFlavor};

    public WBNodeSelection(WhiteboardContext context, List nodes) {
        this.context = context;
        this.selectionXML = this.getWBDString(context.getController().getScreen());
        this.selectionImage = this.getScreenImage(context.getController().getScreen());
    }

    private String getWBDString(ScreenModel screen) {
        try {
            ScreenModel[] proxyScreens = new ScreenModel[]{screen.proxySelectedTools()};
            NoUIProgress progress = new NoUIProgress();
            WhiteboardDataFile jdom = new WhiteboardDataFile(this.context);
            return jdom.writeToString(proxyScreens, (ProgressUpdate)progress);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"getWBDString()", (Throwable)ex, (boolean)true);
            return null;
        }
    }

    private Image getScreenImage(ScreenModel screen) {
        BufferedImage image = null;
        try {
            ScreenModel screenProxy = screen.proxySelectedTools();
            Rectangle screenSize = new Rectangle(new Point(0, 0), screenProxy.getScreenSize());
            Rectangle imageSize = null;
            Rectangle toolRectangle = null;
            Iterator it = screenProxy.iterateTools();
            while (it.hasNext()) {
                AbstractToolModel tool = (AbstractToolModel)it.next();
                toolRectangle = GeometryUtils.normalRectangle((Rectangle)tool.getBounds(), toolRectangle);
                if (imageSize == null) {
                    imageSize = new Rectangle(toolRectangle).intersection(screenSize);
                    continue;
                }
                imageSize = imageSize.union(toolRectangle).intersection(screenSize);
            }
            NoUIProgress progress = new NoUIProgress();
            image = ImageWriterGraphics.processToolToImage(null, (Iterator)screenProxy.iterateTools(), (int)0, (int)0, (int)screenSize.width, (int)screenSize.height, (boolean)true, null, (ProgressUpdate)progress);
            int x = imageSize.x > 0 ? imageSize.x : 0;
            int y = imageSize.y > 0 ? imageSize.y : 0;
            int width = imageSize.width > 0 ? imageSize.width : -imageSize.width;
            int height = imageSize.height > 0 ? imageSize.height : -imageSize.height;
            BufferedImage subImage = image.getSubimage(x, y, width, height);
            return subImage;
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"getScreenImage()", (Throwable)ex, (boolean)false);
            return null;
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(DataFlavor.imageFlavor)) {
            return this.selectionImage;
        }
        if (flavor.equals(wbXMLFlavor)) {
            BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(this.selectionXML.getBytes("UTF-8")));
            return in;
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

