/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.attributeEditors;

import com.elluminate.groupware.whiteboard.ButtonBehaviour;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.AttributeEditorInterface;
import com.elluminate.groupware.whiteboard.attributes.PointerImageAttribute;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.AbstractToolEditorUI;
import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.QuickColorPanel;
import com.elluminate.groupware.whiteboard.module.ui.menu.QuickEditorInterface;
import com.elluminate.groupware.whiteboard.module.ui.menu.ToolPropertiesPanel;
import com.elluminate.platform.Platform;
import com.elluminate.util.image.gif.AnimationFrame;
import com.elluminate.util.image.gif.AnimationInstance;
import com.elluminate.util.image.gif.ImageObject;
import com.elluminate.util.log.LogSupport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;

public class QuickPointerPanel
extends AbstractToolEditorUI
implements QuickEditorInterface {
    private static final Dimension BUTTON_SIZE = new Dimension(32, 32);
    private Action buttonAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            QuickPointerPanel.this.haveChanges = true;
            QuickPointerPanel.this.buttonAction(e);
        }
    };
    private ImageButton noPointerButton = null;
    private ImageButton selectedButton = null;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private HashMap buttonsByName = new HashMap();
    private HashMap pointerSources = new HashMap();
    private LinkedList attributes = new LinkedList();
    private boolean enabled = false;
    private boolean evaluating = false;
    private boolean haveChanges = false;
    private WhiteboardContext context;

    public QuickPointerPanel(WhiteboardContext context) {
        this.context = context;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"constructor", (Throwable)ex, (boolean)true);
        }
    }

    void jbInit() throws Exception {
        this.setLayout(new BoxLayout(this, 0));
        this.makeButtons();
    }

    public AttributeEditorInterface newInstance() {
        QuickColorPanel ui = new QuickColorPanel(this.context);
        ui.setContext(this.context);
        return ui;
    }

    private void makeButtons() {
        this.noPointerButton = new ImageButton(null, null);
        this.context.getButtonBehaviour().setButtonBehaviour((AbstractButton)this.noPointerButton, ButtonBehaviour.normalBorder, false);
        StringTokenizer tokens = PointerImageAttribute.getPointerNames();
        while (tokens.hasMoreTokens()) {
            String pointerName = tokens.nextToken();
            ImageButton button = new ImageButton(this.buttonAction, pointerName);
            this.add(button);
            this.buttonGroup.add(button);
            this.context.getButtonBehaviour().setButtonBehaviour((AbstractButton)button, ButtonBehaviour.normalBorder, false);
            this.buttonsByName.put(pointerName, button);
        }
        this.buttonGroup.add(this.noPointerButton);
        this.enableButtons(false);
    }

    private void enableButtons(boolean enable) {
        Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            if (button.isEnabled() == enable) continue;
            button.setEnabled(enable);
        }
    }

    private void buttonAction(ActionEvent e) {
        ButtonBehaviour.showBehaviours((ButtonGroup)this.buttonGroup);
        this.selectedButton = (ImageButton)e.getSource();
        if (this.selectedButton.isSelected() && !this.evaluating) {
            this.fireTabPropertiesChange(this);
        }
    }

    @Override
    public void addQuickAttribute(AbstractAttribute attribute, ToolPropertiesPanel panel) {
        if (attribute.isQuickAttribute() && attribute instanceof PointerImageAttribute) {
            String attributeGroup = attribute.getName();
            QuickEditorInterface.RefCount refCount = (QuickEditorInterface.RefCount)this.pointerSources.get(attributeGroup);
            if (refCount == null) {
                refCount = new QuickEditorInterface.RefCount();
                this.pointerSources.put(attributeGroup, refCount);
            }
            refCount.addRef();
            this.attributes.add(attribute);
            this.validateQuickVisibility();
            this.evaluateAttributes();
        }
    }

    @Override
    public void removeQuickAttribute(AbstractAttribute attribute) {
        if (attribute.isQuickAttribute() && attribute instanceof PointerImageAttribute) {
            String attributeGroup = attribute.getName();
            QuickEditorInterface.RefCount refCount = (QuickEditorInterface.RefCount)this.pointerSources.get(attributeGroup);
            if (refCount == null) {
                return;
            }
            refCount.removeRef();
            if (refCount.isEmpty()) {
                this.pointerSources.remove(attributeGroup);
            }
            this.attributes.remove(attribute);
            this.evaluateAttributes();
        }
    }

    @Override
    public void validateQuickVisibility() {
        this.enabled = this.pointerSources.size() == 1;
        this.enableButtons(this.enabled);
        this.setVisible(this.enabled);
    }

    public void setContext(WhiteboardContext context) {
        this.context = context;
    }

    public void addAttribute(AbstractAttribute attribute) {
        this.addQuickAttribute(attribute, null);
    }

    public boolean removeAttribute(AbstractAttribute attribute) {
        this.removeQuickAttribute(attribute);
        return this.pointerSources.size() == 0;
    }

    public void applyChanges() {
        if (this.noPointerButton.isSelected() || !this.haveChanges) {
            return;
        }
        this.haveChanges = false;
        for (PointerImageAttribute attribute : this.attributes) {
            String pointerName = this.selectedButton.getButtonName();
            attribute.setPointerImageName(pointerName);
        }
        this.fireEvaluate(this);
    }

    public void evaluateAttributes() {
        AbstractButton button = null;
        AbstractButton selectedButton = null;
        this.evaluating = true;
        int buttonCount = 0;
        this.validateQuickVisibility();
        if (this.isEnabled()) {
            for (PointerImageAttribute attribute : this.attributes) {
                button = (AbstractButton)this.buttonsByName.get(attribute.getImageName());
                if (button == selectedButton) continue;
                selectedButton = button;
                if (++buttonCount <= 1) continue;
            }
        }
        if (buttonCount == 1 && selectedButton != null) {
            if (!this.buttonGroup.isSelected(selectedButton.getModel())) {
                this.buttonGroup.setSelected(selectedButton.getModel(), true);
            }
        } else if (!this.buttonGroup.isSelected(this.noPointerButton.getModel())) {
            this.buttonGroup.setSelected(this.noPointerButton.getModel(), true);
        }
        ButtonBehaviour.showBehaviours((ButtonGroup)this.buttonGroup);
        this.evaluating = false;
    }

    public boolean isApplyValid() {
        return true;
    }

    public String getTabName() {
        return "QuickPointer";
    }

    public String getDisplayName() {
        return "QuickPointer";
    }

    class ImageButton
    extends JToggleButton {
        private ImageObject imageObject = null;
        private String pointerName;
        private int x = 0;
        private int y = 0;
        private int width = 0;
        private int height = 0;
        private AnimationInstance animationInstance = null;
        private ImageIcon buttonImage = null;
        private boolean waiting = false;
        private int frameIndex = 0;
        private long animationTime;
        private boolean canAnimate = false;
        private boolean hovering = false;
        private MouseAdapter hoverListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ImageButton.this.hovering = true;
                ImageButton.this.frameIndex = 0;
                ImageButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ImageButton.this.hovering = false;
                ImageButton.this.repaint();
            }
        };

        public ImageButton(Action buttonAction, String pointerName) {
            this.addActionListener(buttonAction);
            this.pointerName = pointerName;
            this.addMouseListener(this.hoverListener);
            if (pointerName != null) {
                this.imageObject = PointerImageAttribute.getPointerImage((String)pointerName).getAnimatedButtonImageObject();
                if (this.imageObject != null) {
                    this.setPreferredSize(new Dimension(this.width, this.height));
                    this.width = Math.min(BUTTON_SIZE.width - 0, this.imageObject.getWidth());
                    this.height = Math.min(BUTTON_SIZE.height - 0, this.imageObject.getHeight());
                    this.x = (BUTTON_SIZE.width - this.width) / 2;
                    this.y = (BUTTON_SIZE.height - this.height) / 2;
                    if (this.imageObject.getFrameCount() > 1) {
                        this.canAnimate = true;
                    }
                    this.animationInstance = new Animation(this.imageObject);
                }
                this.buttonImage = PointerImageAttribute.getPointerImage((String)pointerName).getButtonImage();
            }
            this.setSelectedIcon(null);
            this.setIcon(null);
            this.setDisabledIcon(null);
            this.setPreferredSize(BUTTON_SIZE);
            this.setMinimumSize(BUTTON_SIZE);
            this.setFocusable(false);
            if (Platform.getLAF() == 502) {
                this.putClientProperty("JButton.buttonType", "toolbar");
            }
            this.frameIndex = 0;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.animationInstance != null) {
                if (this.isSelected()) {
                    g.setColor(Color.black);
                }
                if (this.canAnimate && this.hovering) {
                    Image img = this.animationInstance.getAnimationFrame(this.imageObject).getImage();
                    g.drawImage(img, this.x, this.y, this.width, this.height, null);
                    this.animationInstance.imageRendered(this.imageObject);
                } else {
                    g.drawImage(this.buttonImage.getImage(), this.x, this.y, this.width, this.height, null);
                }
            }
        }

        public void flush() {
            this.imageObject.flush();
        }

        public String getButtonName() {
            return this.pointerName;
        }

        class Animation
        extends AnimationInstance {
            Animation(ImageObject imageObject) {
                super(imageObject);
            }

            protected boolean canAnimate() {
                return ImageButton.this.canAnimate && ImageButton.this.hovering;
            }

            protected void animate(int xOffset, int yOffset, int width, int height) {
                ImageButton.this.repaint();
            }

            protected AnimationFrame getFrame() {
                return ImageButton.this.animationInstance.getAnimationFrame(ImageButton.this.imageObject);
            }
        }
    }
}

