/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui.attributeEditors;

import com.elluminate.groupware.whiteboard.module.ui.attributeEditors.StringsProperties;
import com.elluminate.gui.GuiUtils;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.elluminate.util.event.ThrowableListener;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class QuickAlphaPicker
extends JPanel {
    private static final Dimension ICON_SIZE = new Dimension(12, 12);
    private I18n i18n = I18n.create((Object)this);
    private JLabel label = new JLabel();
    private JToggleButton button = new JToggleButton();
    private JSlider slider = new JSlider(0, 255);
    private Popup popup = null;
    private AWTEventListener popupCancelListener;
    private ListenerRegistry<ChangeListener> changeListeners;
    private int curAlpha = -1;

    public QuickAlphaPicker(ThrowableListener tl) {
        super(null);
        this.setOpaque(false);
        this.changeListeners = new ListenerRegistry(tl);
        Font f = this.label.getFont();
        this.label.setFont(f.deriveFont((float)Math.max(10, f.getSize() - 2)));
        this.label.setHorizontalTextPosition(2);
        this.button.setFocusable(false);
        this.button.setIcon(this.i18n.getIcon((PropertiesEnum)StringsProperties.QUICKALPHAPICKER_PULLDOWNICON));
        this.button.setRolloverIcon(this.i18n.getIcon((PropertiesEnum)StringsProperties.QUICKALPHAPICKER_PULLDOWNROLLOVERICON));
        this.button.setRolloverSelectedIcon(this.i18n.getIcon((PropertiesEnum)StringsProperties.QUICKALPHAPICKER_PULLDOWNROLLOVERICON));
        this.button.setSelectedIcon(this.i18n.getIcon((PropertiesEnum)StringsProperties.QUICKALPHAPICKER_PULLDOWNSELECTEDICON));
        this.button.setBorder(null);
        this.button.setBorderPainted(false);
        this.button.setContentAreaFilled(false);
        this.slider.setPreferredSize(new Dimension(128, this.slider.getPreferredSize().height));
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ev) {
                if (QuickAlphaPicker.this.isPopupShowing()) {
                    QuickAlphaPicker.this.setAlpha(QuickAlphaPicker.this.slider.getValue());
                }
            }
        });
        this.popupCancelListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent ev) {
                if (ev.getID() == 501) {
                    if (!(ev instanceof MouseEvent)) {
                        return;
                    }
                    MouseEvent me = (MouseEvent)ev;
                    Component cmp = me.getComponent();
                    if (cmp == QuickAlphaPicker.this.slider) {
                        return;
                    }
                    QuickAlphaPicker.this.hidePopup();
                    QuickAlphaPicker.this.button.setSelected(false);
                    if (UIManager.getBoolean("PopupMenu.consumeEventOnClose")) {
                        me.consume();
                    }
                }
            }
        };
        this.add(this.label);
        this.add(this.button);
        this.setupPreferredSize();
        this.clearAlpha();
        this.button.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                if (!QuickAlphaPicker.this.button.isSelected()) {
                    QuickAlphaPicker.this.showPopup();
                }
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                if (QuickAlphaPicker.this.button.isSelected() != QuickAlphaPicker.this.isPopupShowing()) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            QuickAlphaPicker.this.button.setSelected(QuickAlphaPicker.this.isPopupShowing());
                        }
                    });
                }
            }
        });
    }

    private void setupPreferredSize() {
        String oldText = this.label.getText();
        this.label.setText(this.getAlphaText(-1));
        Dimension s = this.label.getPreferredSize();
        int w = s.width;
        int h = s.height;
        this.label.setText(this.getAlphaText(255));
        s = this.label.getPreferredSize();
        w = Math.max(w, s.width);
        this.label.setText(oldText);
        w += 8;
        s = this.button.getPreferredSize();
        w += s.width;
        h = Math.max(h, s.height);
        Insets ins = this.getInsets();
        this.setPreferredSize(new Dimension(w += ins.left + ins.right, h += ins.top + ins.bottom));
    }

    @Override
    public void doLayout() {
        Insets ins = this.getInsets();
        int w = this.getWidth();
        int h = this.getHeight();
        int maxHeight = h - ins.top - ins.bottom;
        int x = ins.left;
        int y = ins.top;
        Dimension s = this.label.getPreferredSize();
        int h2 = Math.min(maxHeight, s.height);
        int dy = (h - h2 + 1) / 2;
        this.label.setLocation(x, y + dy);
        this.label.setSize(s.width, h2);
        s = this.button.getPreferredSize();
        h2 = Math.min(maxHeight, s.height);
        dy = (h - h2 + 1) / 2;
        this.button.setLocation(w - s.width, y + dy);
        this.button.setSize(s.width, h2);
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add((Object)l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove((Object)l);
    }

    private void fireChangeListeners() {
        FiringFunctor<ChangeListener> ff = new FiringFunctor<ChangeListener>(){
            ChangeEvent ev = null;

            public void fire(ChangeListener l) {
                if (this.ev == null) {
                    this.ev = new ChangeEvent(QuickAlphaPicker.this);
                }
                l.stateChanged(this.ev);
            }
        };
        this.changeListeners.fire((FiringFunctor)ff);
    }

    public int getAlpha() {
        return this.curAlpha;
    }

    public void clearAlpha() {
        this.setAlpha(-1);
    }

    public void setAlpha(int alpha) {
        if (alpha < -1 || alpha > 255) {
            alpha = -1;
        }
        if (alpha == this.curAlpha) {
            return;
        }
        this.curAlpha = alpha;
        this.label.setText(this.getAlphaText(this.curAlpha));
        this.fireChangeListeners();
    }

    public String getTriggerButtonToolTipText() {
        return this.button.getToolTipText();
    }

    public void setTriggerButtonToolTipText(String text) {
        this.button.setToolTipText(text);
    }

    private boolean isPopupShowing() {
        return this.popup != null;
    }

    private void showPopup() {
        if (this.isPopupShowing()) {
            return;
        }
        Toolkit tKit = Toolkit.getDefaultToolkit();
        tKit.addAWTEventListener(this.popupCancelListener, 501L);
        this.slider.setValue(this.curAlpha >= 0 && this.curAlpha <= 255 ? this.curAlpha : 255);
        Dimension dim = this.slider.getPreferredSize();
        Point loc = this.button.getLocationOnScreen();
        loc.y += this.button.getHeight();
        Insets scrnInsets = new Insets(0, 0, 0, 0);
        Rectangle scrnBounds = GuiUtils.getDeviceBounds((int)loc.x, (int)loc.y, (Component)this.button, (Insets)scrnInsets);
        scrnBounds.x += scrnInsets.left;
        scrnBounds.y += scrnInsets.top;
        scrnBounds.width -= scrnInsets.left + scrnInsets.right;
        scrnBounds.height -= scrnInsets.top + scrnInsets.bottom;
        if (loc.x + dim.width > scrnBounds.x + scrnBounds.width) {
            loc.x = scrnBounds.x + scrnBounds.width - dim.width - 1;
        }
        if (loc.x < scrnBounds.x) {
            loc.x = scrnBounds.x + 1;
        }
        if (loc.y + dim.height > scrnBounds.y + scrnBounds.height) {
            loc.y -= this.button.getHeight() + dim.height;
        }
        if (loc.y < scrnBounds.y) {
            loc.y = scrnBounds.y + 1;
        }
        PopupFactory f = PopupFactory.getSharedInstance();
        this.popup = f.getPopup(this, this.slider, loc.x, loc.y);
        this.popup.show();
    }

    private void hidePopup() {
        Popup p = this.popup;
        this.popup = null;
        if (p != null) {
            p.hide();
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        tk.removeAWTEventListener(this.popupCancelListener);
    }

    private String getAlphaText(int alpha) {
        if (alpha < 0 || alpha > 255) {
            return null;
        }
        return this.i18n.getString((PropertiesEnum)StringsProperties.QUICKALPHAPICKER_GENERICALPHATEXT, new Object[]{(alpha * 100 + 127) / 255});
    }

    private Icon getAlphaIcon(final int alpha) {
        if (alpha < 0 || alpha > 255) {
            return null;
        }
        Icon icon = new Icon(){
            private int width;
            private int height;
            {
                this.width = ICON_SIZE.width;
                this.height = ICON_SIZE.height;
            }

            @Override
            public int getIconHeight() {
                return this.height;
            }

            @Override
            public int getIconWidth() {
                return this.width;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (alpha >= 0 && alpha <= 255) {
                    g.setColor(Color.WHITE);
                    g.fillRect(x, y, this.width, this.height);
                    g.setColor(new Color(0, 0, 0, alpha));
                    g.fillRect(x, y, this.width, this.height);
                } else {
                    g.setColor(c.getBackground());
                    g.fillRect(x, y, this.width, this.height);
                    int checkerboard = 4;
                    Color c1 = Color.LIGHT_GRAY.brighter();
                    Color c2 = Color.GRAY;
                    int w = checkerboard;
                    int h = checkerboard;
                    for (int col = 0; col < (this.height + checkerboard - 1) / checkerboard; ++col) {
                        w = checkerboard;
                        if ((col + 1) * checkerboard > this.height) {
                            h = checkerboard - ((col + 1) * checkerboard - this.height);
                        }
                        for (int row = 0; row < (this.width + checkerboard - 1) / checkerboard; ++row) {
                            if ((row + 1) * checkerboard > this.width) {
                                w = checkerboard - ((row + 1) * checkerboard - this.width);
                            }
                            g.setColor(col % 2 == row % 2 ? c1 : c2);
                            g.fillRect(x + row * checkerboard, y + col * checkerboard, w, h);
                        }
                    }
                }
            }
        };
        return icon;
    }
}

