/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;

public class TransferableTreeNode
extends DefaultMutableTreeNode
implements Transferable {
    static final int TREE = 0;
    static final int STRING = 1;
    static final int PLAIN_TEXT = 2;
    public static final DataFlavor DEFAULT_MUTABLE_TREENODE_FLAVOR = new DataFlavor(DefaultMutableTreeNode.class, "Default Mutable Tree Node");
    static DataFlavor[] flavors = new DataFlavor[]{DEFAULT_MUTABLE_TREENODE_FLAVOR, DataFlavor.stringFlavor, DataFlavor.plainTextFlavor};
    private DefaultMutableTreeNode data;

    public TransferableTreeNode(DefaultMutableTreeNode data) {
        this.data = data;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        Object returnObject;
        if (flavor.equals(flavors[0])) {
            Object userObject = this.data.getUserObject();
            returnObject = this.data;
        } else if (flavor.equals(flavors[1])) {
            Object userObject = this.data.getUserObject();
            returnObject = userObject == null ? this.data.toString() : userObject.toString();
        } else if (flavor.equals(flavors[2])) {
            Object uesrObject = this.data.getUserObject();
            String string = this.userObject == null ? this.data.toString() : this.userObject.toString();
            returnObject = new ByteArrayInputStream(string.getBytes("Unicode"));
        } else {
            throw new UnsupportedFlavorException(flavor);
        }
        return returnObject;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        boolean returnValue = false;
        int n = flavors.length;
        for (int i = 0; i < n; ++i) {
            if (!flavor.equals(flavors[i])) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }
}

