/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.module.ui.ToolSlip;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.util.ExternalDataBean;
import com.elluminate.util.log.LogSupport;
import java.awt.event.ActionEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;

public class ToolSlipEvent
extends EventObject {
    public static final int TOOL_GENESIS = 0;
    public static final int TOOL_FINALIZATION = 1;
    public static final int TOOL_DEATH = 2;
    public static final int TOOL_INSTALLATION = 3;
    public static final int TOOL_REGENERATION = 4;
    private int type = -1;
    private AbstractToolModel tool = null;
    private AbstractToolModel toolTemplate = null;
    private WBNode container = null;
    private ScreenModel screen;
    private ActionEvent actionEvent;
    private boolean reciprocal = false;
    private ExternalDataBean toolData = null;

    public ToolSlipEvent(ToolSlip source, ScreenModel screen, ActionEvent actionEvent, int type, AbstractToolModel tool, AbstractToolModel template, WBNode container, boolean reciprocal) {
        super(source);
        this.type = type;
        this.toolTemplate = template;
        this.screen = screen;
        this.actionEvent = actionEvent;
        this.tool = tool;
        this.container = container;
        this.reciprocal = reciprocal;
        if (!container.isContainer()) {
            throw new RuntimeException("ToolSlipEvent Container: " + container + ", is not a container.");
        }
        if (tool != null && type != 1) {
            tool.setCreating(type == 0);
            template.getContext().getController().setToolCreche(tool);
            ((ControllerPane)tool.getContext().getController()).setToolSlipTool(tool, false);
        }
    }

    public ToolSlipEvent(ToolSlip source, ScreenModel screen, ActionEvent actionEvent, int type, AbstractToolModel tool, AbstractToolModel template, WBNode container, boolean reciprocal, ExternalDataBean toolData) {
        this(source, screen, actionEvent, type, tool, template, container, reciprocal);
        this.toolData = toolData;
    }

    public int getType() {
        return this.type;
    }

    public AbstractToolModel getTool() {
        return this.tool;
    }

    public AbstractToolModel getToolTemplate() {
        return this.toolTemplate;
    }

    public WBNode getContainer() {
        return this.container;
    }

    public void creationMouseEvent(MouseEvent e) {
        this.makeRealTool();
        if (this.tool != null) {
            this.processResponse(this.tool.creationMouseEvent(e));
        }
    }

    public void creationKeyEvent(KeyEvent e) {
        this.makeRealTool();
        if (this.tool != null) {
            this.processResponse(this.tool.creationKeyEvent(e));
        }
    }

    public void creationInputMethodEvent(InputMethodEvent e) {
        this.makeRealTool();
        if (this.tool != null) {
            this.processResponse(this.tool.creationInputTextChanged(e));
        }
    }

    private void makeRealTool() {
        if (this.tool == null) {
            this.tool = this.toolData == null ? this.toolTemplate.toolFactory(this.screen, this.container, this.actionEvent, this.reciprocal) : this.toolTemplate.toolFactory(this.toolData, this.screen, this.container, this.reciprocal);
            if (this.tool == null) {
                LogSupport.error((Object)this, (String)"makeRealTool", (String)("toolFactory returned null for: " + this.toolTemplate));
            }
            this.toolTemplate.getContext().getController().setToolCreche(this.tool);
            ((ControllerPane)this.toolTemplate.getContext().getController()).setToolSlipTool(this.tool, false);
        }
    }

    public void processResponse(int response) {
        if (this.getContainer() instanceof WBNode && this.getContainer().isDeleted()) {
            response = 3;
        }
        switch (response) {
            case 3: {
                this.tool.endCreating();
                ((ControllerPane)this.tool.getContext().getController()).unsetToolSlipTool(this.tool);
                ((ControllerPane)this.toolTemplate.getContext().getController()).setNextMode();
                this.tool = null;
                break;
            }
            case 1: {
                this.tool.endCreating();
                if (this.tool.isInitialized()) {
                    ToolSlipEvent event = new ToolSlipEvent((ToolSlip)this.source, this.screen, this.actionEvent, 1, this.tool, this.toolTemplate, this.container, this.reciprocal);
                    ((ToolSlip)this.source).fireToolSlipListeners(event);
                }
                ((ControllerPane)this.tool.getContext().getController()).unsetToolSlipTool(this.tool);
                ((ControllerPane)this.toolTemplate.getContext().getController()).setNextMode();
                this.tool = null;
                ((ControllerPane)this.toolTemplate.getContext().getController()).setSelectMode();
                break;
            }
            case 2: 
            case 9: {
                ToolSlipEvent event;
                this.tool.endCreating();
                if (this.tool.isInitialized()) {
                    event = new ToolSlipEvent((ToolSlip)this.source, this.screen, this.actionEvent, 1, this.tool, this.toolTemplate, this.container, this.reciprocal);
                    ((ToolSlip)this.source).fireToolSlipListeners(event);
                }
                ((ControllerPane)this.tool.getContext().getController()).unsetToolSlipTool(this.tool);
                ScreenModel newScreen = this.container instanceof ScreenModel ? (ScreenModel)this.container : this.container.findScreenParent();
                AbstractToolModel newTool = this.toolTemplate.toolFactory(this.screen, this.container, this.reciprocal, this.tool);
                if (response == 9) {
                    newTool.setActionName("stamper");
                }
                event = new ToolSlipEvent((ToolSlip)this.source, newScreen, this.actionEvent, 0, newTool, this.toolTemplate, this.container, this.reciprocal);
                this.tool = null;
                ((ToolSlip)this.source).setNewEvent(event);
                break;
            }
            case 8: {
                do {
                    ToolSlipEvent event;
                    this.tool.endCreating();
                    if (this.tool.isInitialized()) {
                        event = new ToolSlipEvent((ToolSlip)this.source, this.screen, this.actionEvent, 1, this.tool, this.toolTemplate, this.container, this.reciprocal);
                        ((ToolSlip)this.source).fireToolSlipListeners(event);
                    }
                    ((ControllerPane)this.tool.getContext().getController()).unsetToolSlipTool(this.tool);
                    ScreenModel newScreen = this.container instanceof ScreenModel ? (ScreenModel)this.container : this.container.findScreenParent();
                    AbstractToolModel newTool = this.toolTemplate.toolFactory(this.screen, this.container, this.reciprocal, this.tool);
                    event = new ToolSlipEvent((ToolSlip)this.source, newScreen, this.actionEvent, 0, newTool, this.toolTemplate, this.container, this.reciprocal);
                    this.tool = null;
                    ((ToolSlip)this.source).setNewEvent(event);
                    this.tool = newTool;
                } while (this.tool.continuedResponse() == 8);
                break;
            }
            case 6: {
                this.tool.endCreating();
                if (!this.tool.isInitialized()) break;
                ToolSlipEvent event = new ToolSlipEvent((ToolSlip)this.source, this.screen, this.actionEvent, 3, this.tool, this.toolTemplate, this.container, this.reciprocal);
                ((ToolSlip)this.source).fireToolSlipListeners(event);
                break;
            }
            case 7: {
                ((ControllerPane)this.tool.getContext().getController()).unsetToolSlipTool(this.tool);
                ScreenModel newScreen = this.container instanceof ScreenModel ? (ScreenModel)this.container : this.container.findScreenParent();
                AbstractToolModel newTool = this.toolTemplate.toolFactory(this.screen, this.container, this.reciprocal, this.tool);
                ToolSlipEvent event = new ToolSlipEvent((ToolSlip)this.source, newScreen, this.actionEvent, 0, newTool, this.toolTemplate, this.container, this.reciprocal);
                this.tool = null;
                ((ToolSlip)this.source).setNewEvent(event);
                break;
            }
        }
    }

    @Override
    public String toString() {
        return "ToolSlipEvent: @" + Integer.toHexString(this.hashCode()) + "\n\tType: " + this.getType() + ", tool: " + this.tool;
    }
}

