/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WBCursorUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.WhiteboardDebug;
import com.elluminate.groupware.whiteboard.acl.ACLTerm;
import com.elluminate.groupware.whiteboard.dataModel.ACLChangeListener;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.DPoint;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.DataModelListener;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ToolSelectionListener;
import com.elluminate.groupware.whiteboard.interfaces.UniqueObjectID;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.module.ui.PasteClerk;
import com.elluminate.groupware.whiteboard.module.ui.PasteClerkContext;
import com.elluminate.groupware.whiteboard.module.ui.StringsProperties;
import com.elluminate.groupware.whiteboard.module.ui.ToolButton;
import com.elluminate.groupware.whiteboard.module.ui.ToolSlipEvent;
import com.elluminate.groupware.whiteboard.module.ui.ToolSlipListener;
import com.elluminate.groupware.whiteboard.module.ui.ToolStack;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.AsyncToolFactoryListener;
import com.elluminate.groupware.whiteboard.tools.BackgroundTool;
import com.elluminate.groupware.whiteboard.tools.PaletteImage;
import com.elluminate.groupware.whiteboard.tools.PointerToolModel;
import com.elluminate.gui.dnd.DropHelperInterface;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.ExternalDataBean;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.image.ImageMimeUtilities;
import com.elluminate.util.image.PICTImporter;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetContext;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ToolSlip
extends JPanel
implements ACLChangeListener,
ActionListener,
AsyncToolFactoryListener,
DataModelListener,
ToolSelectionListener,
DropHelperInterface {
    private static final int PALETTE_COLUMN_COUNT = 1;
    private static I18n i18n = I18n.create((Object)new Object(){});
    private static final List<ToolInfo> TOOLS = new ArrayList<ToolInfo>();
    private Map<Integer, Component> slots;
    private ControllerPane controllerPane;
    private LinkedList toolSlipListeners;
    private ButtonGroup toolButtonGroup;
    private LinkedList dynamicTools;
    private LinkedList<Window> windowsToQuiesce;
    private HashMap toolNames;
    private JPanel toolControls;
    private AbstractButton nextButton;
    private JToggleButton selectToolButton;
    private Cursor selectToolCursor;
    private ScreenModel screen;
    private ToolSlipEvent creatingEvent;
    private boolean toolSlipLocked;
    private boolean whiteboardAccessible;
    private boolean localEnabled;
    private boolean enabled;
    private boolean advancedControls;
    private boolean firstTime;
    private boolean quiescingTool;
    private WhiteboardContext context;
    private PasteClerk pasteClerk;

    public ToolSlip(WhiteboardContext context, ControllerPane controllerPane) {
        super(true);
        for (String ptrName : PointerToolModel.getPointerNameList()) {
            TOOLS.add(new ToolInfo("PointerTool", ptrName, 1));
        }
        TOOLS.addAll(Arrays.asList(new ToolInfo("PenTool", null, 2), new ToolInfo("HighlightTool", null, 2), new ToolInfo("TextEditorTool", null, 3), new ToolInfo("TextTool", null, 3), new ToolInfo("FilledRectangleTool", null, 4), new ToolInfo("FilledEllipseTool", null, 4), new ToolInfo("RectangleTool", null, 5), new ToolInfo("EllipseTool", null, 5), new ToolInfo("LineTool", null, 6), new ToolInfo("ImageTool", "fromScreenCapture", 7), new ToolInfo("ImageTool", "fromClipArt", 8)));
        this.slots = new TreeMap<Integer, Component>();
        this.toolSlipListeners = new LinkedList();
        this.toolButtonGroup = new ButtonGroup();
        this.dynamicTools = new LinkedList();
        this.windowsToQuiesce = new LinkedList();
        this.toolNames = new HashMap();
        this.toolControls = new JPanel(new PaletteLayout());
        this.nextButton = null;
        this.selectToolButton = new JToggleButton();
        this.screen = null;
        this.creatingEvent = null;
        this.toolSlipLocked = false;
        this.whiteboardAccessible = true;
        this.localEnabled = true;
        this.enabled = true;
        this.advancedControls = false;
        this.firstTime = true;
        this.quiescingTool = false;
        this.context = context;
        this.controllerPane = controllerPane;
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)this.toolControls, "North");
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.toolControls.setOpaque(false);
        this.toolControls.setAlignmentX(0.0f);
        this.toolControls.setAlignmentY(0.0f);
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setupButton(this.selectToolButton, i18n.getIcon("ToolSlip.selectIcon"), i18n.getIcon("ToolSlip.selectSelectedIcon"), i18n.getIcon("ToolSlip.selectRolloverIcon"), i18n.getString((PropertiesEnum)StringsProperties.TOOLSLIP_SELECTTIP));
        this.selectToolButton.addActionListener(this);
        this.addToSlot(this.selectToolButton, 0);
        this.toolButtonGroup.add(this.selectToolButton);
        try {
            boolean useWinRsrc = false;
            Image selectCursorImg = null;
            if (Platform.getPlatform() == 1) {
                try {
                    selectCursorImg = i18n.getImage("ToolSlip.win.selectCursor");
                    useWinRsrc = true;
                }
                catch (Throwable t) {
                    useWinRsrc = false;
                    LogSupport.message((Object)this, (String)"<init>", (String)("Failed to get Windows selectCursor image: " + t));
                }
            }
            if (selectCursorImg == null) {
                useWinRsrc = false;
                selectCursorImg = i18n.getImage("ToolSlip.selectCursor");
            }
            String hotspotString = null;
            if (useWinRsrc) {
                try {
                    hotspotString = i18n.getStringLegacy("ToolSlip.selectCursor.win.cursorHotSpot");
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (hotspotString == null) {
                hotspotString = i18n.getStringLegacy("ToolSlip.selectCursor.cursorHotSpot");
            }
            StringTokenizer tokenizer = new StringTokenizer(hotspotString);
            int x = Integer.parseInt(tokenizer.nextToken(","));
            int y = Integer.parseInt(tokenizer.nextToken());
            Point hotspot = new Point(x, y);
            String accessName = i18n.getStringLegacy("ToolSlip.selectCursor.cursorAccessibilityText");
            this.selectToolCursor = WBCursorUtils.createCustomCursor((Image)selectCursorImg, (Point)hotspot, (String)accessName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.selectToolCursor == null) {
            this.selectToolCursor = Cursor.getDefaultCursor();
        }
        controllerPane.setDefaultCanvasCursor(this.selectToolCursor);
        this.screen = controllerPane.getScreen();
        this.selectButton(this.selectToolButton);
        context.getDataModel().addDataModelListener((DataModelListener)this);
        this.pasteClerk = new PasteClerk(this.createPasteClerkContext());
    }

    private PasteClerkContext createPasteClerkContext() {
        return new PasteClerkContext(){

            @Override
            public ScreenModel getScreen() {
                return ToolSlip.this.controllerPane.getScreen();
            }

            @Override
            public AbstractToolModel getToolByName(String toolName, ScreenModel screen, ExternalDataBean toolData) {
                return ToolSlip.this.getToolByName(toolName, screen, toolData);
            }

            @Override
            public void pasteTools(ScreenModel screen, DPoint dloc, WBNode[] nodes) {
                ActionUtilities.pasteTools((ScreenModel)screen, (WhiteboardContext)ToolSlip.this.context, (DPoint)dloc, (WBNode[])nodes);
            }

            @Override
            public void setLocalSelectMode() {
                ToolSlip.this.setLocalSelectMode();
            }
        };
    }

    private void setupButton(AbstractButton button, Icon normalIcon, Icon selectedIcon, Icon rolloverIcon, String toolTip) {
        button.setToolTipText(toolTip);
        button.setIcon(normalIcon);
        if (selectedIcon != null) {
            button.setSelectedIcon(selectedIcon);
        }
        if (rolloverIcon != null) {
            button.setRolloverIcon(rolloverIcon);
            button.setRolloverSelectedIcon(rolloverIcon);
        }
        button.setFocusable(false);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        button.setBorder(null);
        button.setMargin(new Insets(0, 0, 0, 0));
    }

    private void selectToolButton_actionPerformed(ActionEvent e) {
        if (this.screen != null) {
            this.screen.deSelectAllTools();
        }
        if (!this.toolSlipLocked) {
            this.toolSlipLocked = true;
            this.quiesceTool();
            this.setLocalSelectMode();
            if (this.creatingEvent != null) {
                ToolSlipEvent event = new ToolSlipEvent(this, this.screen, e, 2, this.creatingEvent.getTool(), this.creatingEvent.getToolTemplate(), (WBNode)this.screen, false);
                this.fireToolSlipListeners(event);
                this.toolComplete();
            }
            this.toolSlipLocked = false;
        }
        this.controllerPane.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSelectTool(AbstractToolModel tool) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.setLocalSelectMode();
            this.evaluateEnable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDeSelectTool(AbstractToolModel tool) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.evaluateEnable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableAdvancedControls(boolean enable) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.advancedControls = enable;
            this.evaluateEnable();
        }
    }

    public void addToolSlipListener(ToolSlipListener l) {
        this.toolSlipListeners.add(l);
    }

    public void removeToolSlipListener(ToolSlipListener l) {
        this.toolSlipListeners.remove(l);
    }

    protected void fireToolSlipListeners(ToolSlipEvent toolSlipEvent) {
        ToolSlipListener[] listeners = new ToolSlipListener[this.toolSlipListeners.size()];
        listeners = this.toolSlipListeners.toArray(listeners);
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] == null) continue;
            try {
                listeners[i].onToolSlipEvent(toolSlipEvent);
                continue;
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"fireToolSlipListeners", (Throwable)ex, (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateToolSlip(ScreenModel screen) {
        AbstractButton button = null;
        AbstractButton testButton2 = null;
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (this.firstTime || !screen.isEditable()) {
                this.setLocalSelectMode();
            }
            for (AbstractButton testButton2 : this.dynamicTools) {
                if (!testButton2.isSelected()) continue;
                button = testButton2;
                break;
            }
            if (this.selectToolButton.isSelected()) {
                button = this.selectToolButton;
            }
            this.quiesceTool();
            if (this.firstTime) {
                for (ToolInfo info : TOOLS) {
                    try {
                        String name = info.name;
                        if ("".equals(name)) continue;
                        String action = info.action;
                        AbstractToolModel tool = (AbstractToolModel)this.context.getTemplateRegistry().getTemplate(name);
                        if (tool == null) continue;
                        this.addTool(tool, action, info.slot);
                        this.toolNames.put(name.toLowerCase(Locale.ENGLISH), tool);
                    }
                    catch (Exception ex1) {
                        LogSupport.exception((Object)this, (String)"populateToolSlip", (Throwable)ex1, (boolean)true);
                    }
                }
                for (Integer slotKey : this.slots.keySet()) {
                    Component cmp = this.slots.get(slotKey);
                    if (cmp == null) continue;
                    this.toolControls.add(cmp);
                }
                this.firstTime = false;
            }
            if (this.screen != null) {
                this.screen.removeACLChangeListener((ACLChangeListener)this);
                this.screen.removeToolSelectionListener((ToolSelectionListener)this);
            }
            this.screen = screen;
            if (this.screen != null) {
                this.screen.addACLChangeListener((ACLChangeListener)this);
                this.screen.addToolSelectionListener((ToolSelectionListener)this);
            }
            if ((button != this.selectToolButton || button == null) && button != null) {
                button.doClick();
            }
            this.evaluateEnable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeToolProperties() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            for (ToolInfo info : TOOLS) {
                String name = info.name;
                AbstractToolModel tool = (AbstractToolModel)this.context.getTemplateRegistry().getTemplate(name);
                if (tool == null) continue;
                this.context.getObjectManager().setObjectInMap((UniqueObjectID)tool);
                this.controllerPane.setToolSlipTool(tool, false);
                this.controllerPane.unsetToolSlipTool(tool);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void quiesceTool() {
        DataModel dataModel = this.windowsToQuiesce;
        synchronized (dataModel) {
            Iterator componentIter = this.windowsToQuiesce.iterator();
            while (componentIter.hasNext()) {
                Window window = (Window)componentIter.next();
                componentIter.remove();
                try {
                    window.setVisible(false);
                    window.dispose();
                }
                catch (Exception ex) {
                    LogSupport.exception((Object)this, (String)"quiesceTool, hide Window", (Throwable)ex, (boolean)true);
                }
            }
        }
        if (!this.quiescingTool) {
            dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                this.quiescingTool = true;
                try {
                    if (this.creatingEvent != null && this.creatingEvent.getTool() != null) {
                        this.creatingEvent.getTool().quiesceTool();
                        if (this.creatingEvent != null && this.creatingEvent.getTool() != null && this.creatingEvent.getTool().isInitialized()) {
                            this.creatingEvent.processResponse(1);
                        } else if (this.creatingEvent != null) {
                            this.creatingEvent.processResponse(3);
                        }
                    }
                    this.toolComplete();
                }
                catch (Exception ex) {
                    LogSupport.exception((Object)this, (String)"quiesceTool", (Throwable)ex, (boolean)true);
                }
                finally {
                    this.quiescingTool = false;
                }
            }
        }
    }

    private void selectButton(AbstractButton button) {
        if (!button.isSelected()) {
            button.setSelected(true);
        }
    }

    private void addTool(AbstractToolModel tool, String action, int slot) {
        ToolButton button = new ToolButton(tool, action, false);
        this.addToSlot(button, slot);
        this.dynamicTools.add(button);
        this.toolButtonGroup.add(button);
        button.addActionListener(this);
        if (tool.hasReciprocalAction()) {
            button = new ToolButton(tool, action, true);
            this.addToSlot(button, slot);
            this.dynamicTools.add(button);
            this.toolButtonGroup.add(button);
            button.addActionListener(this);
        }
    }

    private void addToSlot(AbstractButton btn, int slot) {
        Component cmp = this.slots.get(slot);
        if (cmp == null) {
            this.slots.put(slot, btn);
            return;
        }
        if (cmp instanceof ToolStack) {
            ToolStack stack = (ToolStack)cmp;
            btn.setBorder(null);
            stack.addButton(btn);
            return;
        }
        ToolStack stack = new ToolStack(this.context.getThrowableListener(), 0, 0);
        stack.setBorder(null);
        AbstractButton firstBtn = (AbstractButton)cmp;
        firstBtn.setBorder(null);
        btn.setBorder(null);
        stack.addButton(firstBtn);
        stack.addButton(btn);
        this.slots.put(slot, stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComponentToQuiesce(Window window) {
        LinkedList<Window> linkedList = this.windowsToQuiesce;
        synchronized (linkedList) {
            this.windowsToQuiesce.add(window);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean reciprocalAction = false;
        ToolButton button = null;
        if (e.getSource() == this.selectToolButton) {
            this.selectToolButton_actionPerformed(e);
            return;
        }
        this.controllerPane.requestFocus();
        if (!(e.getSource() instanceof ToolButton)) {
            return;
        }
        reciprocalAction = ((ToolButton)e.getSource()).isReciprocal();
        ScreenModel container = this.screen;
        if (this.screen.getSelectedToolCount() == 1) {
            // empty if block
        }
        if (!this.toolSlipLocked) {
            this.toolSlipLocked = true;
            this.nextButton = (AbstractButton)e.getSource();
            this.quiesceTool();
            button = (ToolButton)e.getSource();
            if (button != null && button.getTool().unselectOnCreation() && this.screen != null) {
                this.screen.deSelectAllTools();
            }
            if (button != null && button.isSelected()) {
                if (button.getTool().isContainer() || button.getTool() instanceof BackgroundTool) {
                    container = this.screen;
                }
                this.controllerPane.setToolSlipTool(button.getTool(), true);
                AbstractToolModel creatingTool = button.getTool();
                if (creatingTool != null) {
                    if (creatingTool.doesToolNeedInking()) {
                        AbstractToolModel tool = creatingTool.toolFactory((AsyncToolFactoryListener)this, this.screen, (WBNode)container, e, reciprocalAction);
                        if (tool != null) {
                            this.postToolSlipEvent(0, this.screen, (WBNode)container, e, tool, creatingTool, reciprocalAction);
                        } else {
                            this.setLocalSelectMode();
                        }
                    } else {
                        this.postToolSlipEvent(0, this.screen, (WBNode)container, e, null, creatingTool, reciprocalAction);
                    }
                } else {
                    this.setLocalSelectMode();
                }
            }
            this.nextButton = null;
            this.toolSlipLocked = false;
        }
    }

    private void postToolSlipEvent(int type, ScreenModel screen, WBNode container, ActionEvent srcEvent, AbstractToolModel tool, AbstractToolModel creatingTool, boolean reciprocal) {
        ToolSlipEvent event = new ToolSlipEvent(this, screen, srcEvent, type, tool, creatingTool, container, reciprocal);
        this.setNewEvent(event);
    }

    public void asyncToolFactoryCallback(ScreenModel screen, ActionEvent e, AbstractToolModel tool) {
        ScreenModel container = screen;
        ToolButton button = (ToolButton)e.getSource();
        AbstractToolModel creatingTool = button.getTool();
        boolean reciprocalAction = button.isReciprocal();
        this.postToolSlipEvent(tool != null ? 0 : 1, screen, (WBNode)container, e, tool, creatingTool, reciprocalAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewEvent(ToolSlipEvent event) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.creatingEvent = event;
            this.fireToolSlipListeners(this.creatingEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toolComplete() {
        this.controllerPane.setCanvasCursor(this.selectToolCursor);
        this.controllerPane.endComposition();
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (this.creatingEvent != null) {
                ToolSlipEvent event = this.creatingEvent;
                this.creatingEvent = null;
                if (event.getTool() != null) {
                    this.controllerPane.unsetToolSlipTool(event.getTool());
                    event.getTool().toolComplete();
                }
                this.controllerPane.unsetToolSlipTool(event.getToolTemplate());
            }
            this.fireToolSlipListeners(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectMode() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.quiesceTool();
            this.setLocalSelectMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLocalSelectMode() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.toolComplete();
            if (!this.selectToolButton.isSelected()) {
                this.selectButton(this.selectToolButton);
            }
            this.controllerPane.clearToolSlipTools();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextMode() {
        if (this.nextButton == null) {
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                this.setLocalSelectMode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWhiteboardAccessible(boolean whiteboardAccessible) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.whiteboardAccessible = whiteboardAccessible;
            this.evaluateEnable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabled(boolean enabled) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.localEnabled = enabled;
            this.evaluateEnable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onACLChange(ACLTerm aclTerm) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.evaluateEnable();
            if (this.screen != null) {
                this.setWhiteboardAccessible(this.screen.isAccessible());
            }
        }
    }

    private void evaluateEnable() {
        SwingRunnerSupport.invokeLater((Runnable)new EvaluateEnableRunnable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeAdded(WBNode addedNode, WBNode parentNode) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (addedNode instanceof AbstractToolModel && addedNode.getBoardParent() == this.screen) {
                this.evaluateEnable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeRemoved(WBNode removedNode, int removedIndex, WBNode parentNode) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (removedNode instanceof AbstractToolModel && (parentNode == this.screen || parentNode.getScreenParent() == this.screen)) {
                this.evaluateEnable();
            }
        }
    }

    public boolean objectDropped(Transferable transferable, DataFlavor chosen, Point location, Object extra) {
        Point realLocation = ActionUtilities.resolveLocation((Point)location, (ScreenModel)this.controllerPane.getScreen(), (WhiteboardContext)this.context);
        int scaledX = (int)(realLocation.getX() / this.context.getScaleX());
        int scaledY = (int)(realLocation.getY() / this.context.getScaleY());
        Point scaledLoc = new Point(scaledX, scaledY);
        return this.pasteClerk.objectDropped(transferable, chosen, scaledLoc, extra);
    }

    public void updateUI(int event, DropTargetContext context, DataFlavor flavor, int action, Point location) {
    }

    private void addToolsFromFileList(List transferFiles, List realToolList) {
        ExternalDataBean toolData = new ExternalDataBean();
        AbstractToolModel tool = null;
        for (File file : transferFiles) {
            toolData.setData((Object)file);
            tool = ImageMimeUtilities.isValidImageMimeFile((File)file) ? this.getToolByName("imagetool", this.screen, toolData) : this.getToolByName("texteditortool", this.screen, toolData);
            if (tool == null) continue;
            realToolList.add(tool);
        }
    }

    public boolean isDataValid(Transferable transferable, DataFlavor chosen, int action, Point location) {
        if (!this.whiteboardAccessible) {
            return false;
        }
        if (transferable == null) {
            return true;
        }
        Object data = null;
        try {
            data = transferable.getTransferData(chosen);
        }
        catch (Throwable t) {
            LogSupport.log((Object)this, (String)"isDataValid", (String)"Can't read data from the transferable.");
            if (WhiteboardDebug.DATAFLAVORS.show()) {
                LogSupport.log((Object)this, (String)"isDataValid", (String)Debug.getStackTrace((Throwable)t));
            }
            return false;
        }
        if (WhiteboardDebug.DATAFLAVORS.show()) {
            LogSupport.message(ToolSlip.class, (String)"isDataValid", (String)("t=" + transferable + " f=" + chosen + " data=" + data + " type=" + (data == null ? "" : data.getClass().getName())));
        }
        if (data == null) {
            return true;
        }
        if (data instanceof AbstractList) {
            try {
                AbstractList trList = (AbstractList)data;
                if (trList.size() < 1) {
                    return false;
                }
                for (int ix = 0; ix < trList.size(); ++ix) {
                    File file = (File)trList.get(ix);
                    String fileType = Platform.getMimeType((String)file.getName());
                    if (this.checkForPICTSupport(fileType) && ImageMimeUtilities.isValidImageMimeFile((File)file)) continue;
                    return false;
                }
                return true;
            }
            catch (Throwable ex) {
                if (WhiteboardDebug.DATAFLAVORS.show()) {
                    LogSupport.message(ToolSlip.class, (String)"isDataValid", (String)("Error processing transferable data: " + Debug.getStackTrace((Throwable)ex)));
                }
                return false;
            }
        }
        if (data instanceof PaletteImage) {
            return true;
        }
        if (data instanceof Image) {
            return true;
        }
        if (data instanceof Reader) {
            return true;
        }
        if (data instanceof InputStream) {
            return true;
        }
        return data instanceof String;
    }

    public boolean isSelectMode() {
        return this.selectToolButton.isSelected();
    }

    public AbstractToolModel getToolByName(String toolName, ScreenModel screen, ExternalDataBean toolData) {
        AbstractToolModel creatingTool = (AbstractToolModel)this.toolNames.get(toolName);
        AbstractToolModel realTool = null;
        if (creatingTool != null) {
            realTool = toolData != null ? creatingTool.toolFactory(toolData, screen, (WBNode)screen, false) : creatingTool.toolFactory(screen, (WBNode)screen, null, false);
        }
        return realTool;
    }

    private boolean checkForPICTSupport(String mimeType) {
        if (PICTImporter.isPICT((String)mimeType)) {
            return PICTImporter.isSupported();
        }
        return true;
    }

    class EvaluateEnableRunnable
    implements Runnable {
        EvaluateEnableRunnable() {
        }

        @Override
        public void run() {
            boolean isRoot = ToolSlip.this.screen instanceof ScreenRoot;
            boolean whiteboardAccessible = ToolSlip.this.screen == null ? false : ToolSlip.this.screen.isAccessible();
            ToolSlip.this.enabled = (ToolSlip.this.whiteboardAccessible || ToolSlip.this.screen != null && ToolSlip.this.screen.isAccessible()) && whiteboardAccessible && ToolSlip.this.localEnabled && !isRoot && !ToolSlip.this.context.isPlayback();
            if (!ToolSlip.this.enabled) {
                ToolSlip.this.setLocalSelectMode();
            }
            ToolSlip.this.selectToolButton.setEnabled(ToolSlip.this.localEnabled);
            Iterator iter = ToolSlip.this.dynamicTools.iterator();
            while (iter.hasNext()) {
                ((AbstractButton)iter.next()).setEnabled(ToolSlip.this.enabled);
            }
        }
    }

    private static class PaletteLayout
    extends GridLayout {
        public PaletteLayout() {
            super(0, 1, 2, 2);
        }
    }

    private static class ToolInfo {
        String name;
        String action;
        int slot;

        ToolInfo(String name, String action, int slot) {
            this.name = name;
            this.action = action;
            this.slot = slot;
        }
    }
}

