/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.gui.FontUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ToolCellRenderer
extends DefaultTreeCellRenderer {
    private int bottomGap = 8;
    private WhiteboardContext context;
    private Font defaultFont = UIManager.getFont("Tree.font");
    private Icon icon = null;

    public ToolCellRenderer(WhiteboardContext context) {
        this.context = context;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefferedSize = super.getPreferredSize();
        return new Dimension(prefferedSize.width, prefferedSize.height + this.bottomGap);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel renderer = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        this.icon = null;
        if (value instanceof DisplayNode && tree.isVisible()) {
            Font font = this.defaultFont;
            WBNode peer = ((DisplayNode)value).whiteboardPeer();
            if (peer instanceof WBNode) {
                if (!((DisplayNode)value).isOnline()) {
                    renderer.setForeground(Color.gray);
                    font = FontUtils.setFontStyle((Font)font, (int)2);
                } else {
                    font = FontUtils.setFontStyle((Font)font, (int)0);
                }
                renderer.setFont(font);
                this.icon = peer.getIcon();
            }
        }
        return renderer;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public Icon getLeafIcon() {
        return this.icon;
    }

    @Override
    public Icon getOpenIcon() {
        return this.icon;
    }

    @Override
    public Icon getClosedIcon() {
        return this.icon;
    }

    @Override
    public Icon getDefaultLeafIcon() {
        return this.icon;
    }

    @Override
    public Icon getDefaultOpenIcon() {
        return this.icon;
    }

    @Override
    public Icon getDefaultClosedIcon() {
        return this.icon;
    }

    @Override
    public Icon getDisabledIcon() {
        return this.icon;
    }

    public void setCellGap(int bottomGap) {
        this.bottomGap = bottomGap;
    }

    public void resetIcon() {
        this.icon = null;
    }
}

