/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class ToolCellEditor
extends DefaultTreeCellEditor {
    WhiteboardContext context;

    public ToolCellEditor(JTree tree, DefaultTreeCellRenderer renderer, WhiteboardContext context) {
        this(tree, renderer, null, context);
    }

    public ToolCellEditor(JTree tree, DefaultTreeCellRenderer renderer, TreeCellEditor editor, WhiteboardContext context) {
        super(tree, renderer, editor);
        this.context = context;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        DisplayNode displayNode;
        JTree tree;
        TreePath path;
        MouseEvent event;
        Object object;
        if (super.isCellEditable(anEvent) && anEvent instanceof MouseEvent && (object = (event = (MouseEvent)anEvent).getSource()) instanceof JTree && (path = (tree = (JTree)object).getPathForLocation(event.getX(), event.getY())).getLastPathComponent() instanceof DisplayNode && (displayNode = (DisplayNode)path.getLastPathComponent()).whiteboardPeer() instanceof AbstractToolModel) {
            AbstractToolModel tool = (AbstractToolModel)displayNode.whiteboardPeer();
            return tool.isEditable();
        }
        return false;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        DisplayNode displayNode;
        Object object = anEvent.getSource();
        if (object instanceof DisplayNode && (displayNode = (DisplayNode)object).whiteboardPeer() instanceof AbstractToolModel) {
            AbstractToolModel tool = (AbstractToolModel)displayNode.whiteboardPeer();
            ScreenModel screen = tool.findScreenParent();
            if (ObjectUID.isMyNode((WBNode)tool) && screen.canDeleteOwnTools()) {
                return true;
            }
            return screen.canDeleteOthersTools();
        }
        return false;
    }
}

