/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JToggleButton;

public class ToolButton
extends JToggleButton {
    private static final Insets NO_MARGIN = new Insets(0, 0, 0, 0);
    private String actionName;
    AbstractToolModel tool;
    boolean reciprocal = false;

    public ToolButton(AbstractToolModel tool, String action, boolean reciprocal) {
        this.tool = tool;
        this.actionName = action;
        this.reciprocal = reciprocal;
        if (action != null) {
            this.setActionCommand(action);
            this.setToolTipText(tool.getToolTip(action, reciprocal));
        } else {
            this.setToolTipText(tool.getToolTip(reciprocal));
        }
        this.setIcon(tool.getButtonStateIcon(action, "default", reciprocal));
        Icon icon = tool.getButtonStateIcon(action, "disabled", reciprocal);
        if (icon != null) {
            this.setDisabledIcon(icon);
        }
        if ((icon = tool.getButtonStateIcon(action, "selected", reciprocal)) != null) {
            this.setSelectedIcon(icon);
            this.setPressedIcon(icon);
        }
        if ((icon = tool.getButtonStateIcon(action, "armed", reciprocal)) != null) {
            this.setPressedIcon(icon);
        }
        if ((icon = tool.getButtonStateIcon(action, "rollover", reciprocal)) != null) {
            this.setRolloverIcon(icon);
            this.setRolloverSelectedIcon(icon);
        }
        this.setFocusable(false);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setBorder(null);
        this.setMargin(NO_MARGIN);
    }

    public boolean isReciprocal() {
        return this.reciprocal;
    }

    public String getActionName() {
        return this.actionName;
    }

    public AbstractToolModel getTool() {
        return this.tool;
    }
}

