/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.module.ui.DndTree;
import com.elluminate.util.I18n;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.UIManager;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MainNavDndTree
extends DndTree {
    private TreePath hoveredPath = null;
    private TreePath currentScreenPath = null;
    protected static final Color DefaultBackgroundColor = Color.decode("#DFE1E3");
    protected static final Color HoveredRowBackgroundColor = Color.decode("#ECEDEE");
    protected static final Color CurrentScreenRowBackgroundColor = Color.WHITE;
    protected static final Color SelectedRowBackgroundColor = DefaultBackgroundColor;
    private static final Color[] CurrentScreenRowDecorationColors = new Color[]{Color.decode("#BDBDBD"), Color.decode("#E9E9E9"), Color.decode("#F1F1F1"), Color.decode("#F8F8F8")};
    private static final Color[] HoveredRowDecorationColors = new Color[]{Color.decode("#D1D3D4"), Color.decode("#E3E4E5"), Color.decode("#E6E7E9"), Color.decode("#E9EAEB")};

    public MainNavDndTree(WhiteboardContext context) {
        super(context);
        this.setBackground(DefaultBackgroundColor);
        this.setPaintsOwnDnd(false);
        boolean old = UIManager.getBoolean("Tree.paintLines");
        UIManager.put("Tree.paintLines", false);
        NavTreeUI ui = new NavTreeUI();
        super.setUI((TreeUI)ui);
        ui.setupIcons();
        UIManager.put("Tree.paintLines", old);
    }

    public void setUI(TreeUI ui) {
        TreeUI old = this.getUI();
        if (old == null || ui instanceof NavTreeUI || !(old instanceof NavTreeUI)) {
            super.setUI(ui);
        }
    }

    protected void paintComponent(Graphics g) {
        Rectangle selectedRowBounds;
        int[] selectedRows;
        Rectangle currScreenRowBounds;
        Rectangle hoveredRowBounds;
        Rectangle rectangle = hoveredRowBounds = this.hoveredPath != null && !this.isPathSelected(this.hoveredPath) ? this.getPathBounds(this.hoveredPath) : null;
        if (hoveredRowBounds != null) {
            g.setColor(HoveredRowBackgroundColor);
            g.fillRect(0, hoveredRowBounds.y, this.getWidth(), hoveredRowBounds.height);
        }
        Rectangle rectangle2 = currScreenRowBounds = this.currentScreenPath != null && !this.isPathSelected(this.currentScreenPath) ? this.getPathBounds(this.currentScreenPath) : null;
        if (currScreenRowBounds != null) {
            g.setColor(CurrentScreenRowBackgroundColor);
            g.fillRect(0, currScreenRowBounds.y, this.getWidth(), currScreenRowBounds.height);
        }
        if ((selectedRows = this.getSelectionRows()) != null) {
            selectedRowBounds = null;
            g.setColor(UIManager.getColor("Tree.selectionBackground"));
            for (int i = 0; i < selectedRows.length; ++i) {
                int row = selectedRows[i];
                selectedRowBounds = this.getRowBounds(row);
                if (selectedRowBounds == null) continue;
                g.fillRect(0, selectedRowBounds.y, this.getWidth(), selectedRowBounds.height);
            }
        }
        super.paintComponent(g);
        if (hoveredRowBounds != null) {
            this.drawRowDecoration(g, hoveredRowBounds, HoveredRowDecorationColors);
        }
        if (currScreenRowBounds != null) {
            this.drawRowDecoration(g, currScreenRowBounds, CurrentScreenRowDecorationColors);
        }
        if (selectedRows != null) {
            selectedRowBounds = null;
            int prevRow = -2;
            g.setColor(DefaultBackgroundColor);
            for (int i = 0; i < selectedRows.length; ++i) {
                int row = selectedRows[i];
                if (row == prevRow + 1 && (selectedRowBounds = this.getRowBounds(row)) != null) {
                    g.drawLine(0, selectedRowBounds.y, this.getWidth(), selectedRowBounds.y);
                }
                prevRow = row;
            }
        }
        this.paintDndTargets(g);
    }

    private void drawRowDecoration(Graphics g, Rectangle rowBounds, Color[] decorationColors) {
        for (int i = 0; i < decorationColors.length; ++i) {
            g.setColor(decorationColors[i]);
            int currY = rowBounds.y + i;
            g.drawLine(0, currY, this.getWidth(), currY);
            currY = rowBounds.y + rowBounds.height - i - 1;
            g.drawLine(0, currY, this.getWidth(), currY);
        }
    }

    public int getRowForYPos(int yPos) {
        int closestRow = this.getClosestRowForLocation(0, yPos);
        if (closestRow >= 0) {
            Rectangle closestRowBounds = this.getRowBounds(closestRow);
            if (yPos < closestRowBounds.y || yPos > closestRowBounds.y + closestRowBounds.height) {
                closestRow = -1;
            }
        }
        return closestRow;
    }

    private void setHoveredPath(TreePath path) {
        boolean shouldSetPath;
        boolean bl = this.hoveredPath == null ? path != null : (shouldSetPath = !this.hoveredPath.equals(path));
        if (shouldSetPath) {
            this.hoveredPath = path;
            this.repaint();
        }
    }

    private void processMouseMotion(MouseEvent e) {
        if (e.getID() == 503) {
            TreePath path = this.getPathForRow(this.getRowForYPos(e.getY()));
            this.setHoveredPath(path);
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        this.processMouseMotion(e);
        super.processMouseMotionEvent(e);
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.getID() == 505) {
            this.setHoveredPath(null);
        } else if (e.getID() == 502) {
            int selRow;
            TreePath eventPath = this.getClosestPathForLocation(e.getX(), e.getY());
            boolean eventInComponent = this.getRowForLocation(e.getX(), e.getY()) >= 0;
            boolean eventInExpandControl = this.isEventInExpandControl(eventPath, e);
            if (!eventInComponent && !eventInExpandControl && (selRow = this.getRowForYPos(e.getY())) >= 0) {
                this.selectRowForEvent(selRow, e);
            }
        }
    }

    public boolean isTopLevelPath(TreePath path) {
        if (path == null) {
            return false;
        }
        TreeNode node = (TreeNode)path.getLastPathComponent();
        return node.getParent() != null && node.getParent().getParent() == null;
    }

    public int getHoveredRow() {
        return this.getRowForPath(this.hoveredPath);
    }

    public int getCurrentScreenRow() {
        return this.getRowForPath(this.currentScreenPath);
    }

    public void setCurrentScreenPath(TreePath path) {
        if (this.isTopLevelPath(path)) {
            this.currentScreenPath = null;
        }
        if (this.currentScreenPath != path) {
            this.currentScreenPath = path;
            this.repaint();
        }
    }

    public void setCurrentScreenRow(int row) {
        this.setCurrentScreenPath(this.getPathForRow(row));
    }

    public void selectRowForEvent(int row, MouseEvent event) {
        this.selectPathForEvent(this.getPathForRow(row), event);
    }

    public void selectPathForEvent(TreePath path, MouseEvent event) {
        NavTreeUI ui = (NavTreeUI)this.getUI();
        ui.selectPathForEvent(path, event);
    }

    public boolean isEventInExpandControl(TreePath path, MouseEvent event) {
        NavTreeUI ui = (NavTreeUI)this.getUI();
        return ui.isLocationInExpandControl(path, event.getX(), event.getY());
    }

    private class NavTreeUI
    extends BasicTreeUI {
        public void setupIcons() {
            I18n i18n = I18n.create((Object)new Object(){});
            this.setExpandedIcon(i18n.getIcon("NavigatorPane.treeExpandedIcon"));
            this.setCollapsedIcon(i18n.getIcon("NavigatorPane.treeCollapsedIcon"));
        }

        @Override
        protected void selectPathForEvent(TreePath path, MouseEvent event) {
            super.selectPathForEvent(path, event);
        }

        @Override
        protected boolean isLocationInExpandControl(TreePath arg0, int arg1, int arg2) {
            return super.isLocationInExpandControl(arg0, arg1, arg2);
        }
    }
}

