/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.AbstractUI;
import com.elluminate.groupware.whiteboard.tools.LineToolModel;
import com.elluminate.groupware.whiteboard.tools.LineUIInterface;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;

public class LineUI
extends AbstractUI
implements LineUIInterface {
    public void draw(Graphics g, AbstractToolModel tool) {
        Line2D line = (Line2D)tool.getUIData();
        if (line == null) {
            line = new Line2D.Double();
            tool.setUIData((Object)line);
        }
        LineToolModel lineTool = (LineToolModel)tool;
        if (tool.isUIInvalid()) {
            Rectangle rect = lineTool.getBounds();
            line.setLine(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height);
            tool.setUIInvalid(false);
        }
        Graphics2D g2 = (Graphics2D)g;
        try {
            g2.setColor((Color)lineTool.getColor().getColor());
            g2.setStroke((BasicStroke)lineTool.getStroke().getStroke());
            g2.draw(line);
        }
        catch (Throwable ex) {
            // empty catch block
        }
    }

    public static Object drawLine(Object object, Object strokeObject, Graphics g, Color color, int x1, int y1, int x2, int y2) {
        Line2D line = !(object instanceof Line2D) ? new Line2D.Double(x1, y1, x2, y2) : (Line2D)object;
        if (strokeObject instanceof BasicStroke) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(color);
            g2.setStroke((BasicStroke)strokeObject);
            g2.draw(line);
        }
        return line;
    }
}

