/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.ShutdownListener;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.WBImage;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.dataModel.WhiteboardModel;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.interfaces.UniqueObjectID;
import com.elluminate.groupware.whiteboard.module.ui.ImageUI;
import com.elluminate.groupware.whiteboard.module.ui.StringsProperties;
import com.elluminate.groupware.whiteboard.tools.BackgroundTool;
import com.elluminate.groupware.whiteboard.tools.ImageToolModel;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.swing.CDialog;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class IMGLoadDialog
extends CDialog
implements ProgressUpdate {
    private static final I18n i18n = I18n.create((Object)new Object(){});
    private static final String NULL_IMAGE = i18n.getString((PropertiesEnum)StringsProperties.IMGDIALOG_NULLIMAGE);
    private WhiteboardContext context = null;
    private File[] filesToLoad = null;
    private WBImage[] images = null;
    private int modalReturn = 64;
    private Point origin = null;
    private JProgressBar progress = null;
    private WhiteboardModel modelRead = null;
    private int delta = 0;
    private JPanel panel = new JPanel();
    private GridBagLayout progressLayout = new GridBagLayout();
    private JLabel fileName = new JLabel();
    private JProgressBar readProgress = new JProgressBar();
    private String progressName;
    private int nameWidth = 0;
    private Thread imageLoader = null;
    private boolean runningFileProcessing = false;

    public IMGLoadDialog(WhiteboardContext context, Frame frame, String title, File[] filesToLoad, boolean modal) {
        super(frame, title, modal);
        this.getRootPane().putClientProperty("Window.style", "small");
        this.origin = frame.getLocationOnScreen();
        this.context = context;
        this.filesToLoad = filesToLoad;
        this.images = new WBImage[filesToLoad.length];
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)((Object)this), (String)"constructor", (Throwable)ex, (boolean)true);
        }
    }

    void jbInit() throws Exception {
        this.panel.setLayout(this.progressLayout);
        this.setLabelText(this.fileName, "");
        this.fileName.setHorizontalAlignment(0);
        this.readProgress.setMinimumSize(new Dimension(300, 16));
        this.readProgress.setPreferredSize(new Dimension(300, 16));
        this.fileName.setPreferredSize(new Dimension(250, 23));
        this.readProgress.setStringPainted(true);
        this.getContentPane().add(this.panel);
        this.panel.add((Component)this.fileName, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.panel.add((Component)this.readProgress, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (IMGLoadDialog.this.imageLoader != null) {
                    IMGLoadDialog.this.imageLoader.start();
                }
            }
        });
    }

    public void processFile(boolean b) {
        ImageLoadRunnable loader = new ImageLoadRunnable();
        this.imageLoader = new WorkerThread((Runnable)loader, "Whiteboard Image Loader");
        this.imageLoader.setDaemon(true);
        Dimension paneSize = this.getSize();
        Frame appFrame = this.context.getDialogParentFrame();
        Point screenLocation = appFrame.getLocation();
        Dimension screenSize = appFrame.getSize();
        this.setLocation(screenLocation.x + (screenSize.width - paneSize.width) / 2, screenLocation.y + (screenSize.height - paneSize.height) / 2);
        if (b) {
            this.setVisible(b);
        } else {
            this.imageLoader.start();
        }
    }

    private WhiteboardModel importImages(WBImage[] images) {
        Rectangle area = new Rectangle();
        WhiteboardModel whiteboardModel = new WhiteboardModel(this.context);
        whiteboardModel.setTemplate(this.context);
        if (images == null) {
            return whiteboardModel;
        }
        Integer max = new Integer(this.filesToLoad.length);
        for (int index = 0; index < this.filesToLoad.length && this.runningFileProcessing; ++index) {
            this.setString(i18n.getString((PropertiesEnum)StringsProperties.IMGDIALOG_SCREENCREATE, new Object[]{new Integer(index), max}));
            if (images[index] == null) continue;
            this.setLabelText(this.fileName, images[index].getImageFilename());
            ScreenModel screen = new ScreenModel(ActionUtilities.nextScreenName(null, (WhiteboardContext)this.context) + " - " + images[index].getDisplayName(), this.context);
            screen.setTemplate(this.context);
            screen.setOriginator();
            this.context.getObjectManager().setObjectInMap((UniqueObjectID)screen);
            BackgroundTool background = new BackgroundTool(this.context);
            background.setTemplate(this.context);
            background.setOriginator();
            this.context.getObjectManager().setObjectInMap((UniqueObjectID)background);
            whiteboardModel.add((WBNode)screen);
            screen.add((WBNode)background);
            if (images[index] != null) {
                String fileName = images[index].getImageFilename();
                int screenWidth = images[index].getSize().width;
                int screenHeight = images[index].getSize().height;
                if (screenWidth == 0 && screenHeight == 0) {
                    ModalDialog.showMessageDialog((Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.IMGDIALOG_BADSIZE, new Object[]{fileName}), (String)i18n.getString((PropertiesEnum)StringsProperties.IMGDIALOG_BADSIZETITLE), (int)0);
                }
                if (screenWidth < 1014) {
                    screenWidth = 1014;
                }
                if (screenHeight < 835) {
                    screenHeight = 835;
                }
                screen.setScreenSize(screenWidth, screenHeight);
                if (images[index] != null) {
                    area.width = images[index].getSize().width;
                    area.height = images[index].getSize().height;
                    int widthGap = screen.getScreenSize().width - area.width;
                    int heightGap = screen.getScreenSize().height - area.height;
                    area.x = widthGap / 2;
                    area.y = heightGap / 2;
                    ImageToolModel imageTool = new ImageToolModel(this.context, images[index].getImageBytes(), images[index].getImageFilename(), images[index].getDisplayName(), area);
                    this.context.getObjectManager().setObjectInMap((UniqueObjectID)imageTool);
                    imageTool.setOriginator();
                    imageTool.setFrameVisible(false);
                    background.add((WBNode)imageTool);
                    images[index].delete();
                }
            }
            this.setValue(this.progress.getValue() + 1);
        }
        return whiteboardModel;
    }

    public WhiteboardModel getModel() {
        return this.modelRead;
    }

    public void setMaximum(final int value) {
        this.delta = value / 100;
        if (this.progress != null) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    IMGLoadDialog.this.progress.setMaximum(value);
                }
            });
        }
    }

    public void incrementMaximum(final int increment) {
        if (this.progress != null) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    IMGLoadDialog.this.progress.setMaximum(IMGLoadDialog.this.progress.getMaximum() + increment);
                }
            });
        }
    }

    public int getValue() {
        return this.progress != null ? this.progress.getValue() : 0;
    }

    public void setValue(final int value) {
        if (this.progress != null && (value - this.delta >= this.progress.getValue() || value >= this.progress.getMaximum())) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    IMGLoadDialog.this.progress.setValue(value);
                }
            });
        }
    }

    public void setLabelText(final JLabel label, final String string) {
        if (label != null) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    label.setText(string);
                }
            });
        }
    }

    public void setString(final String string) {
        if (this.progress != null) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    IMGLoadDialog.this.progress.setString(string);
                }
            });
        }
    }

    public void setValue(WBElement element) {
        this.setValue(element.getInstanceCount());
    }

    public void setFilename(String name) {
        this.progressName = name;
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                IMGLoadDialog.this.fileName.setText(IMGLoadDialog.this.progressName);
            }
        });
    }

    private class ImageLoadRunnable
    implements Runnable,
    ShutdownListener {
        private ImageLoadRunnable() {
        }

        public void onShutdown() {
            IMGLoadDialog.this.runningFileProcessing = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IMGLoadDialog.this.runningFileProcessing = true;
            try {
                IMGLoadDialog.this.progress = IMGLoadDialog.this.readProgress;
                IMGLoadDialog.this.setMaximum(IMGLoadDialog.this.filesToLoad.length * 2);
                Integer max = new Integer(IMGLoadDialog.this.filesToLoad.length);
                for (int i = 0; i < IMGLoadDialog.this.filesToLoad.length && IMGLoadDialog.this.runningFileProcessing; ++i) {
                    block9: {
                        IMGLoadDialog.this.setString(i18n.getString((PropertiesEnum)StringsProperties.IMGDIALOG_FILEREADING, new Object[]{new Integer(i), max}));
                        try {
                            IMGLoadDialog.this.setLabelText(IMGLoadDialog.this.fileName, IMGLoadDialog.this.filesToLoad[i].getName());
                            ((IMGLoadDialog)IMGLoadDialog.this).images[i] = ImageUI.loadImage(IMGLoadDialog.this.filesToLoad[i], IMGLoadDialog.this.context, null, null, null, (Component)((Object)IMGLoadDialog.this));
                            if (IMGLoadDialog.this.images[i] != null && IMGLoadDialog.this.images[i].getMediaData() != null) break block9;
                            IMGLoadDialog.this.setVisible(false);
                            return;
                        }
                        catch (Exception e) {
                            IMGLoadDialog.this.setVisible(false);
                            ModalDialog.showMessageDialog((Component)IMGLoadDialog.this.context.getDialogParentFrame(), (Object)e.getMessage(), (String)i18n.getString((PropertiesEnum)StringsProperties.IMGDIALOG_ERRORREADINGIMG, new Object[]{IMGLoadDialog.this.filesToLoad[i].getName()}), (int)0);
                            IMGLoadDialog.this.runningFileProcessing = false;
                            return;
                        }
                    }
                    IMGLoadDialog.this.setValue(i);
                    continue;
                }
                IMGLoadDialog.this.modelRead = IMGLoadDialog.this.importImages(IMGLoadDialog.this.images);
            }
            finally {
                IMGLoadDialog.this.runningFileProcessing = false;
            }
            IMGLoadDialog.this.setVisible(false);
        }
    }
}

