/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.module.ui.DnDropTargetListener;
import com.elluminate.groupware.whiteboard.module.ui.DndTree;
import com.elluminate.groupware.whiteboard.module.ui.TransferableTreePath;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class DnDragGestureListener
implements DragGestureListener,
DragSourceListener {
    private WhiteboardContext context;
    private ArrayList<ImageElement> dragImages = new ArrayList();
    private Rectangle ghostRectangle = new Rectangle();
    private int iconHeight = 0;
    private Point lastMousePoint = new Point();
    private DnDropTargetListener dropTargetListener = null;
    private Point dropListenerLocation = null;
    private boolean dragSource = true;
    private TreePath[] selectedPaths = null;
    private boolean sourceNodeInBackground = false;
    private ScreenModel sourceNodeParentScreen = null;
    private ArrayList<WBNode> sourceNodes = new ArrayList();
    private TreePath[] sourceTreePaths;
    private Point startDragPoint = new Point();
    private DndTree tree;

    public void setDropTargetListener(DnDropTargetListener dropTargetListener) {
        this.dropTargetListener = dropTargetListener;
    }

    public DnDragGestureListener(WhiteboardContext context, DndTree tree) {
        this.context = context;
        this.tree = tree;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        ArrayList<TreePath> pathArrayList = new ArrayList<TreePath>();
        JTree tree = (JTree)dragGestureEvent.getComponent();
        if (tree != (DndTree)((Object)dragGestureEvent.getComponent())) {
            return;
        }
        this.startDragPoint = dragGestureEvent.getDragOrigin();
        this.dragImages.clear();
        this.sourceNodes.clear();
        this.dropListenerLocation = null;
        this.selectedPaths = tree.getSelectionPaths();
        if (this.selectedPaths == null) {
            return;
        }
        this.selectedPaths = ActionUtilities.pruneRootChildren((TreePath[])this.selectedPaths);
        for (int i = 0; i < this.selectedPaths.length; ++i) {
            Rectangle raPath;
            TreePath path = this.selectedPaths[i];
            WBNode sourceNode = ActionUtilities.getWBNode((TreePath)path);
            if (path.getLastPathComponent() != sourceNode.getDisplayPeer() || sourceNode == null || sourceNode instanceof ScreenRoot || sourceNode instanceof ScreenModel && !((ScreenModel)sourceNode).canDelete() || sourceNode.isBackground()) continue;
            this.sourceNodeParentScreen = sourceNode.getScreenParent();
            if (sourceNode instanceof AbstractToolModel && ((AbstractToolModel)sourceNode).isInBackground() && !this.sourceNodeParentScreen.canEditBackground() || (raPath = tree.getPathBounds(path)) == null) continue;
            boolean isLeaf = tree.getModel().isLeaf(path.getLastPathComponent());
            JLabel lbl = (JLabel)tree.getCellRenderer().getTreeCellRendererComponent(tree, path.getLastPathComponent(), false, tree.isExpanded(path), isLeaf, tree.getRowForPath(path), false);
            lbl.setSize((int)raPath.getWidth(), (int)raPath.getHeight());
            Icon icon = lbl.getIcon();
            int nStartOfText = icon == null ? 0 : icon.getIconWidth() + lbl.getIconTextGap();
            this.iconHeight = ScreenModel.getStaticIcon() != null ? ScreenModel.getStaticIcon().getIconHeight() : lbl.getHeight();
            ImageElement dragImage = new ImageElement((int)raPath.getWidth(), (int)raPath.getHeight(), 3);
            dragImage.setOffset(raPath.x - this.startDragPoint.x, raPath.y - this.startDragPoint.y);
            Graphics2D g2 = dragImage.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setComposite(AlphaComposite.getInstance(2, 0.5f));
            lbl.paint(g2);
            g2.setComposite(AlphaComposite.getInstance(4, 0.5f));
            g2.setPaint(new GradientPaint(nStartOfText, 0.0f, SystemColor.controlShadow, tree.getWidth(), 0.0f, new Color(255, 255, 255, 0)));
            g2.fillRect(nStartOfText, 0, tree.getWidth(), dragImage.getHeight());
            g2.dispose();
            this.dragImages.add(dragImage);
            this.sourceNodes.add(sourceNode);
            pathArrayList.add(path);
        }
        if (pathArrayList.size() == 0) {
            return;
        }
        TransferableTreePath transferable = new TransferableTreePath(pathArrayList, this.sourceNodes, this.context);
        dragGestureEvent.startDrag(null, null, new Point(5, 5), transferable, this);
        this.dragSource = true;
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        if (!dsde.getLocation().equals(this.lastMousePoint)) {
            if (this.dropTargetListener != null) {
                this.dropTargetListener.repaintCueZone();
            }
            this.lastMousePoint = dsde.getLocation();
            this.dropListenerLocation = dsde.getLocation();
        }
    }

    public void repaintDraggedImage(JTree tree) {
        tree.repaint(this.ghostRectangle);
        if (this.dropTargetListener != null) {
            this.dropTargetListener.repaintCueZone();
        }
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
        this.dropListenerLocation = null;
        this.repaintDraggedImage((JTree)((Object)this.tree));
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
        this.dropListenerLocation = null;
        this.repaintDraggedImage((JTree)((Object)this.tree));
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        JTree tree = (JTree)dsde.getDragSourceContext().getComponent();
        if (tree instanceof DndTree) {
            Graphics2D g2 = (Graphics2D)tree.getGraphics();
            tree.repaint(this.ghostRectangle.getBounds());
        }
        this.dragSource = false;
        this.dropListenerLocation = null;
        if (this.dropTargetListener != null) {
            this.dropTargetListener.endDropCleanup();
        }
    }

    public Point getLocation() {
        return this.dropListenerLocation;
    }

    public void paintDraggedImages(Graphics g, Point pt) {
        Rectangle paintRect = null;
        if (pt == null) {
            return;
        }
        for (int i = 0; i < this.dragImages.size(); ++i) {
            ImageElement dragImage = this.dragImages.get(i);
            int x = pt.x + dragImage.getOffset().x;
            int y = pt.y + dragImage.getOffset().y;
            if (paintRect == null) {
                paintRect = new Rectangle(x, y, dragImage.getWidth(), dragImage.getHeight());
                this.ghostRectangle.setRect(paintRect);
            } else {
                ((Rectangle2D)paintRect).setRect(x, y, dragImage.getWidth(), dragImage.getHeight());
                Rectangle.union(this.ghostRectangle, paintRect, this.ghostRectangle);
            }
            g.drawImage(dragImage, x, y, null);
        }
    }

    class ImageElement
    extends BufferedImage {
        private Point offset;

        public ImageElement(int width, int height, int type) {
            super(width, height, type);
            this.offset = new Point();
        }

        public Point getOffset() {
            return this.offset;
        }

        public void setOffset(int xOffset, int yOffset) {
            this.offset = new Point(xOffset, yOffset);
        }

        public void setOffset(Point offset) {
            this.offset = offset;
        }
    }
}

