/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.DisplayModel;
import com.elluminate.groupware.whiteboard.dataModel.DisplayNode;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.module.ui.StringsProperties;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.gui.ModalDialog;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Component;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DisplayUtilities {
    private static I18n i18n = I18n.create((Object)new Object(){});

    private DisplayUtilities() {
    }

    public static DisplayModel createScreenTreeModel(WBNode nodeRoot, WhiteboardContext context) {
        DisplayNode root = new DisplayNode((Object)"DisplayRoot", true);
        nodeRoot.setDisplayPeer(root);
        DisplayModel displayModel = new DisplayModel(root, true, context);
        DisplayUtilities.addScreens(root, nodeRoot.iterateScreens());
        return displayModel;
    }

    static void addScreens(DisplayNode node, Iterator screens) {
        if (screens == null) {
            return;
        }
        while (screens.hasNext()) {
            Object object = screens.next();
            if (!(object instanceof ScreenModel)) continue;
            ScreenModel screen = (ScreenModel)object;
            screen.createPeer();
            DisplayUtilities.addScreens(screen.getDisplayPeer(), screen.iterateScreens());
        }
    }

    public static void selectPeerScreens(TreePath[] paths, WhiteboardContext context, JTree navigatorTree) {
        if (paths == null || paths.length == 0) {
            return;
        }
        for (int i = 0; i < paths.length; ++i) {
            ScreenModel screenParent;
            DisplayNode displayNode;
            if (!(paths[i].getLastPathComponent() instanceof DisplayNode) || !((displayNode = (DisplayNode)paths[i].getLastPathComponent()).whiteboardPeer() instanceof ScreenModel)) continue;
            ScreenModel screen = (ScreenModel)displayNode.whiteboardPeer();
            if (screen instanceof ScreenRoot) {
                screenParent = screen;
                navigatorTree.removeSelectionPath(paths[i]);
            } else {
                screenParent = (ScreenModel)screen.getParent();
            }
            Iterator iter = screenParent.iterateScreens();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof ScreenModel)) continue;
                ScreenModel screenToSelect = (ScreenModel)obj;
                TreePath path = new TreePath(context.getDataModel().getDisplayModel().getPathToRoot((TreeNode)screenToSelect.getDisplayPeer()));
                if (navigatorTree.isPathSelected(path)) continue;
                navigatorTree.expandPath(path);
                navigatorTree.addSelectionPath(path);
            }
        }
    }

    public static void deleteScreens(TreePath[] paths, WhiteboardContext context) {
        DisplayUtilities.deleteScreens(ActionUtilities.pathsToNodes((TreePath[])paths), context);
    }

    public static void deleteScreens(WBNode[] screensIn, WhiteboardContext context) {
        ScreenModel watching;
        Long watchingUID;
        if (screensIn == null || screensIn.length == 0) {
            return;
        }
        String title = i18n.getString((PropertiesEnum)StringsProperties.CONTROLLERPANE_DELETEPAGECONFIRMTITLE);
        String text = i18n.getString((PropertiesEnum)StringsProperties.CONTROLLERPANE_DELETESELECTEDPAGESCONFIRMTEXT);
        int choice = ModalDialog.showConfirmDialog((Component)context.getDialogParentFrame(), (Object)text, (String)title, (int)0);
        if (choice != 0) {
            return;
        }
        LinkedList<WBNode> deletable = new LinkedList<WBNode>();
        for (int i = 0; i < screensIn.length; ++i) {
            if (!((ScreenModel)screensIn[i]).canDelete() || screensIn[i] instanceof ScreenRoot && ((ScreenRoot)screensIn[i]).getGroupID() != 0) continue;
            deletable.add(screensIn[i]);
        }
        if (deletable.isEmpty()) {
            return;
        }
        WBNode[] screens = new WBNode[deletable.size()];
        watching = ActionUtilities.getGotoTarget((WBNode[])(screens = deletable.toArray(screens)), (int)-1, null, (Long)(watchingUID = (watching = context.getController().getScreen()) == null ? null : watching.getObjectID()));
        if (watching != null) {
            ((ControllerPane)context.getController()).setSelectMode();
            context.getController().gotoUIScreen(watching.getObjectID(), false);
        }
        ActionUtilities.deleteScreens((WBNode[])screens, (WhiteboardContext)context);
    }

    public static DisplayModel createToolTreeModel(ScreenModel screen, WhiteboardContext context) {
        DisplayNode root = new DisplayNode((Object)screen.getScreenName(), true);
        DisplayModel displayModel = new DisplayModel(root, true, context);
        root.setUserObject((Object)screen);
        screen.setToolTreeModel(displayModel);
        DisplayUtilities.addTools(root, screen.iterateTools());
        return displayModel;
    }

    static void addTools(DisplayNode node, Iterator tools) {
        if (tools == null) {
            return;
        }
        while (tools.hasNext()) {
            Object object = tools.next();
            if (!(object instanceof AbstractToolModel)) continue;
            ((AbstractToolModel)object).createPeer();
        }
    }
}

