/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.imps.ScalableComponent;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.GeometryUtils;
import com.elluminate.groupware.whiteboard.dataModel.ScreenChangeEvent;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ToolSelectionEntry;
import com.elluminate.groupware.whiteboard.interfaces.ToolSelectionListener;
import com.elluminate.groupware.whiteboard.interfaces.VisibleObject;
import com.elluminate.groupware.whiteboard.listeners.ScreenChangeListener;
import com.elluminate.groupware.whiteboard.module.WhiteboardBean;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.module.ui.ScreenGotoListener;
import com.elluminate.groupware.whiteboard.module.ui.swingsupport.WBUIComponent;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.ToolRenderer;
import com.elluminate.util.log.LogSupport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;

public class Canvas
extends JPanel
implements ScreenChangeListener,
ScalableComponent {
    private static final int ANTI_ALIAS_OVERPAINT = 1;
    private WhiteboardContext context;
    private Rectangle selectionRectangle = new Rectangle();
    private boolean showSelectionRectangle = false;
    private boolean paintingStream = false;
    private boolean repaintAll = true;
    private HashSet screenGotoListeners = new HashSet();
    private ScreenModel screen = null;
    private HashMap wbUIComponents = new HashMap();

    public Canvas() {
        this((WhiteboardContext)null);
    }

    public Canvas(WhiteboardContext context) {
        super(null);
        this.context = context;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"constructor", (Throwable)ex, (boolean)true);
        }
    }

    private void jbInit() throws Exception {
        this.setBackground(Color.white);
        this.setEnabled(true);
        this.setMinimumSize(WhiteboardContext.DEFAULT_SIZE);
        this.setPreferredSize(WhiteboardContext.DEFAULT_SIZE);
        this.enableEvents(8L);
    }

    @Override
    protected void paintChildren(Graphics g) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        Graphics pg = g.create();
        try {
            Graphics2D g2 = (Graphics2D)pg;
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paintComponent(g2);
            if (this.screen != null && !this.context.isSeeking()) {
                if (this.context.isScaled()) {
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g2.transform(AffineTransform.getScaleInstance(this.context.getScaleX(), this.context.getScaleY()));
                }
                this.paintInternal(g2, g, false);
            } else {
                g.setColor(Color.black);
                g.fillRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
        }
        finally {
            pg.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintUnscaled(Graphics g) {
        Graphics pg = g.create();
        try {
            Graphics2D g2 = (Graphics2D)pg;
            g.setColor(Color.white);
            Rectangle clip = g.getClipBounds();
            if (clip != null) {
                g.fillRect(clip.x, clip.y, clip.width, clip.height);
            } else {
                g.fillRect(0, 0, this.getUnscaledSize().width, this.getUnscaledSize().height);
            }
            this.paintInternal(g2, pg, true);
        }
        finally {
            pg.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintInternal(Graphics2D g2, Graphics unmodifiedG, boolean noScale) {
        WhiteboardContext whiteboardContext = this.context;
        synchronized (whiteboardContext) {
            if (this.screen == null) {
                return;
            }
            boolean oldNoScale = this.context.maskAutoScale(noScale);
            try {
                Iterator ink = this.screen.iterateTools();
                while (ink.hasNext()) {
                    Object obj = ink.next();
                    try {
                        if (!(obj instanceof VisibleObject)) continue;
                        VisibleObject vObj = (VisibleObject)obj;
                        if (g2.getClipBounds() != null && !GeometryUtils.intersects((Rectangle)g2.getClipBounds(), (Rectangle)vObj.getVBounds())) continue;
                        ((VisibleObject)obj).render((Graphics)g2, unmodifiedG);
                    }
                    catch (Exception ex) {}
                }
                g2.setColor(Color.black);
                g2.setStroke(new BasicStroke(1.0f));
                if (!this.screen.selectedToolListIsEmpty()) {
                    Iterator iter = this.screen.getSelectedToolListIterator();
                    while (iter.hasNext()) {
                        try {
                            AbstractToolModel paintingTool = (AbstractToolModel)iter.next();
                            ToolSelectionEntry.paintSelectionRect((Graphics)g2, (AbstractToolModel)paintingTool);
                        }
                        catch (Exception ex1) {}
                    }
                }
                if (this.showSelectionRectangle) {
                    try {
                        ToolSelectionEntry.paintDragOutline((Graphics)g2, (Rectangle)this.selectionRectangle);
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                }
                if (this.context.getController().getToolCreche() != null) {
                    try {
                        this.context.getController().getToolCreche().render((Graphics)g2, (Graphics)g2);
                    }
                    catch (Exception ex3) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                LogSupport.exception((Object)this, (String)"paint", (Throwable)e, (boolean)true);
            }
            finally {
                this.context.maskAutoScale(oldNoScale);
            }
        }
    }

    @Override
    public void repaint(Rectangle rect) {
        this.repaint(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        try {
            if (this.repaintAll) {
                this.repaintAll = false;
                super.repaint();
            } else {
                if (!this.context.isScaled()) {
                    super.repaint(0L, x, y, width, height);
                    return;
                }
                double newX = (double)x * this.context.getScaleX();
                double newWidth = (double)width * this.context.getScaleX();
                double newY = (double)y * this.context.getScaleY();
                double newHeight = (double)height * this.context.getScaleY();
                super.repaint((int)Math.floor(newX) - 1, (int)Math.floor(newY) - 1, (int)Math.ceil(newWidth) + 1, (int)Math.ceil(newHeight) + 1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void repaint() {
        super.repaint();
        this.repaintAll = true;
    }

    public void repaintAll() {
        super.repaint();
        this.repaintAll = true;
    }

    public void setSelectionRectangle(Point press, Point release) {
        if (this.showSelectionRectangle) {
            this.repaint(this.selectionRectangle.x - 1, this.selectionRectangle.y - 1, this.selectionRectangle.width + 2 + 1, this.selectionRectangle.height + 2 + 1);
        }
        this.selectionRectangle.x = Math.min(press.x, release.x);
        this.selectionRectangle.y = Math.min(press.y, release.y);
        this.selectionRectangle.width = Math.max(release.x, press.x) - this.selectionRectangle.x;
        this.selectionRectangle.height = Math.max(release.y, press.y) - this.selectionRectangle.y;
        this.showSelectionRectangle = true;
        this.repaint(this.selectionRectangle.x - -1, this.selectionRectangle.y - -1, this.selectionRectangle.width + 2 + 1, this.selectionRectangle.height + 2 + 1);
    }

    public void clearSelectionRectangle() {
        this.showSelectionRectangle = false;
        this.repaint(this.selectionRectangle.x - 1, this.selectionRectangle.y - 1, this.selectionRectangle.width + 2 + 1, this.selectionRectangle.height + 2 + 1);
    }

    public void noteScreen(ScreenModel newScreen) {
        ScreenModel oldScreen = this.screen;
        Long oldUID = oldScreen == null ? null : oldScreen.getObjectID();
        Long newUID = newScreen == null ? null : newScreen.getObjectID();
        this.context.getDataExporter().goneToScreen(oldUID, newUID);
        if (oldScreen != null) {
            oldScreen.removeScreenUIListener((ScreenChangeListener)this);
            this.context.getDataExporter().removeViewedScreen(oldScreen.getObjectID());
        }
        this.context.getDataExporter().addViewedScreen(newScreen.getObjectID());
        this.screen = newScreen;
        this.screen.addScreenUIListener((ScreenChangeListener)this);
        ((ControllerPane)this.context.getController()).processScaleChange();
        this.fireScreenGotoListeners(oldScreen, newScreen);
        this.context.fireCanvasChangeListeners();
        this.repaintAll();
    }

    public Dimension getUnscaledSize() {
        return this.screen == null ? new Dimension() : this.screen.getScreenSize();
    }

    public double getScaleFactorX() {
        return this.context.getScaleX();
    }

    public double getScaleFactorY() {
        return this.context.getScaleY();
    }

    public void setSize() {
        if (this.context.isScaled()) {
            Dimension size = ((ControllerPane)this.context.getController()).getViewSize();
            if (size.equals(this.getPreferredSize())) {
                return;
            }
            super.repaint();
            this.setMinimumSize(size);
            this.setPreferredSize(size);
            super.repaint();
        } else {
            if (this.screen.getScreenSize().equals(this.getPreferredSize())) {
                return;
            }
            super.repaint();
            this.setPreferredSize(this.screen.getScreenSize());
            super.repaint();
        }
    }

    public ScreenModel getScreen() {
        return this.screen;
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    @Override
    public boolean isRequestFocusEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScreenGotoListener(ScreenGotoListener l) {
        HashSet hashSet = this.screenGotoListeners;
        synchronized (hashSet) {
            if (!this.screenGotoListeners.contains(l)) {
                this.screenGotoListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScreenGotoListener(ScreenGotoListener l) {
        HashSet hashSet = this.screenGotoListeners;
        synchronized (hashSet) {
            this.screenGotoListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireScreenGotoListeners(ScreenModel oldScreen, ScreenModel newScreen) {
        HashSet hashSet = this.screenGotoListeners;
        synchronized (hashSet) {
            for (Map.Entry entry : this.wbUIComponents.entrySet()) {
                try {
                    AbstractToolModel tool = (AbstractToolModel)entry.getKey();
                    WBUIComponent ui = (WBUIComponent)entry.getValue();
                    ui.setVisible(tool.getScreenParent() == this.getScreen());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator iter = this.screenGotoListeners.iterator();
            while (iter.hasNext()) {
                try {
                    ((ScreenGotoListener)((Object)iter.next())).onScreenGoto(oldScreen, newScreen);
                }
                catch (Throwable t) {}
            }
        }
    }

    public void onScreenChange(ScreenChangeEvent sce) {
        if (this.screen != sce.getSource()) {
            LogSupport.error((String)("Screen change event from screen: " + sce.getSource().getScreenName() + ", monitoring: " + this.screen.getScreenName()));
            return;
        }
        if (sce.getObject() instanceof String) {
            ((WhiteboardBean)this.context.getBean()).setTitleScreenName((String)sce.getObject());
        } else if (sce.getObject() instanceof VisibleObject) {
            VisibleObject v = (VisibleObject)sce.getObject();
            this.repaint(v.getVBounds().x, v.getVBounds().y, v.getVBounds().width + 2, v.getVBounds().height + 2);
        } else if (sce.getObject() instanceof Rectangle) {
            Rectangle paintBounds = (Rectangle)sce.getObject();
            this.repaint(paintBounds.x, paintBounds.y, paintBounds.width + 2, paintBounds.height + 2);
        } else {
            this.repaint();
        }
    }

    public WBUIComponent getUIComponent(AbstractToolModel tool) {
        if (!this.wbUIComponents.containsKey(tool)) {
            try {
                if (tool instanceof ToolRenderer) {
                    Class<?> cls = Class.forName(((ToolRenderer)tool).getRendererClassName());
                    Class[] params = new Class[]{AbstractToolModel.class};
                    Object[] args = new Object[]{tool};
                    Constructor<?> cons = cls.getConstructor(params);
                    WBUIComponent renderer = (WBUIComponent)cons.newInstance(args);
                    this.wbUIComponents.put(tool, renderer);
                }
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"cannot create Editor UI!", (Throwable)ex, (boolean)true);
            }
        }
        return (WBUIComponent)this.wbUIComponents.get(tool);
    }

    public void addComponent(WBUIComponent renderer) {
        this.add(renderer.getUI());
        this.validate();
        this.getScreen().addToolSelectionListener((ToolSelectionListener)renderer);
        this.getScreen().addScreenUIListener((ScreenChangeListener)renderer);
    }

    public void disposeUIComponent(AbstractToolModel tool) {
        try {
            if (this.wbUIComponents.containsKey(tool)) {
                WBUIComponent renderer = (WBUIComponent)this.wbUIComponents.get(tool);
                this.getScreen().removeToolSelectionListener((ToolSelectionListener)renderer);
                this.wbUIComponents.remove(tool);
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"cannot dispose of Editor UI!", (Throwable)ex, (boolean)true);
        }
    }

    public void removeComponent(WBUIComponent renderer) {
        try {
            if (renderer != null) {
                this.remove(renderer.getUI());
                this.getScreen().removeToolSelectionListener((ToolSelectionListener)renderer);
                this.getScreen().removeScreenUIListener((ScreenChangeListener)renderer);
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"cannot dispose of Editor UI!", (Throwable)ex, (boolean)true);
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }
}

