/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.ui;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.WhiteboardDebug;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.DPoint;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.module.ui.dnd.WBNodeSelection;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.GroupToolModel;
import com.elluminate.gui.dnd.DataFlavorManager;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;

public class ActionUtilities2 {
    private ActionUtilities2() {
    }

    public static void cutSelectedTools(ScreenModel screen, WhiteboardContext context) {
        if (!context.isAccessible(screen) || !screen.canCopy() || screen.selectedToolListIsEmpty()) {
            return;
        }
        LinkedList toolList = ActionUtilities.getToolsEligibleForDeletion((ScreenModel)screen);
        if (toolList.isEmpty()) {
            return;
        }
        AbstractToolModel[] cutTools = new AbstractToolModel[toolList.size()];
        cutTools = toolList.toArray(cutTools);
        try {
            if (cutTools.length > 0) {
                ActionUtilities2.placeOnSystemClipboard(context, Arrays.asList(cutTools));
            }
            ActionUtilities.cutToolTree((WhiteboardContext)context, (AbstractToolModel[])cutTools, (boolean)true);
        }
        catch (Exception ex) {
            LogSupport.exception(ActionUtilities2.class, (String)"cutSelectedTools", (Throwable)ex, (boolean)true);
        }
    }

    public static void copySelectedTools(ScreenModel screen, WhiteboardContext context) {
        if (!context.isAccessible(screen) || screen.selectedToolListIsEmpty() || !screen.canCopy()) {
            return;
        }
        ArrayList<AbstractToolModel> clones = new ArrayList<AbstractToolModel>();
        AbstractToolModel[] tools = new AbstractToolModel[screen.getSelectedToolCount()];
        tools = screen.getSelectedToolList().toArray(tools);
        ActionUtilities.sortToIndexOrder((WBNode[])tools);
        try {
            int i;
            for (i = 0; i < tools.length; ++i) {
                AbstractToolModel tool;
                if (tools[i] == null || (tool = (AbstractToolModel)tools[i].clone()) == null) continue;
                tool.setInConference(false);
                tool.propagateInConference();
                clones.add(tool);
            }
            screen.setPasteOffset(10.0);
            ActionUtilities2.placeOnSystemClipboard(context, clones);
            for (i = 0; i < tools.length; ++i) {
                if (tools[i] == null) continue;
                if (!(tools[i] instanceof GroupToolModel)) {
                    // empty if block
                }
                tools[i].findScreenParent().deSelectTool(tools[i]);
            }
        }
        catch (Exception ex) {
            LogSupport.exception(ActionUtilities2.class, (String)"copySelectedTools", (Throwable)ex, (boolean)true);
        }
    }

    private static void placeOnSystemClipboard(WhiteboardContext context, List nodes) throws Exception {
        ControllerPane controller = (ControllerPane)context.getController();
        Clipboard clipboard = controller.getToolkit().getSystemClipboard();
        WBNodeSelection toolSelection = new WBNodeSelection(context, nodes);
        if (toolSelection != null) {
            clipboard.setContents(toolSelection, controller);
        }
    }

    public static void pasteSelectedTools(ScreenModel screen, WhiteboardContext context, DPoint location) {
        Transferable content = ActionUtilities2.getValidClipboardContent(context);
        if (!context.isAccessible(screen) || content == null) {
            return;
        }
        DataFlavorManager dfManager = ((ControllerPane)context.getController()).getDataFlavorManager();
        DataFlavor chosen = dfManager.chooseBestFlavor(content);
        if (chosen == null) {
            return;
        }
        if (dfManager.getDropHelper(chosen).isDataValid(content, chosen, 0, null)) {
            Point loc = null;
            if (location != null) {
                loc = location.getIntLocation();
            }
            dfManager.getDropHelper(chosen).objectDropped(content, chosen, loc, (Object)screen);
        }
    }

    public static boolean isValidClipboardContent(WhiteboardContext context) {
        ControllerPane controller = (ControllerPane)context.getController();
        Clipboard clipboard = controller.getToolkit().getSystemClipboard();
        DataFlavorManager dfManager = controller.getDataFlavorManager();
        Transferable content = clipboard.getContents(controller);
        if (content != null) {
            DataFlavor chosen = dfManager.chooseBestFlavor(content);
            if (WhiteboardDebug.DATAFLAVORS.show()) {
                LogSupport.message(ActionUtilities2.class, (String)"isValidClipboardContent()", (String)"available DataFlavors:");
                DataFlavor[] fl = content.getTransferDataFlavors();
                for (int i = 0; i < fl.length; ++i) {
                    LogSupport.message(ActionUtilities2.class, (String)"isValidClipboardContent()", (String)(i + 1 + ": " + fl[i].getMimeType()));
                }
                LogSupport.message(ActionUtilities2.class, (String)"isValidClipboardContent()", (String)("Chosen: " + chosen));
            }
            if (chosen != null) {
                if (dfManager.getDropHelper(chosen).isDataValid(content, chosen, 0, null)) {
                    if (WhiteboardDebug.DATAFLAVORS.show()) {
                        LogSupport.message(ActionUtilities2.class, (String)"isValidClipboardContent()", (String)"Clipboard data is available");
                    }
                    return true;
                }
                if (WhiteboardDebug.DATAFLAVORS.show()) {
                    LogSupport.message(ActionUtilities2.class, (String)"isValidClipboardContent()", (String)"Clipboard data is not available");
                }
            }
        }
        return false;
    }

    public static Transferable getValidClipboardContent(WhiteboardContext context) {
        ControllerPane controller = (ControllerPane)context.getController();
        Clipboard clipboard = controller.getToolkit().getSystemClipboard();
        DataFlavorManager dfManager = controller.getDataFlavorManager();
        Transferable content = clipboard.getContents(controller);
        if (content != null && dfManager.isFlavorSupported(content)) {
            return content;
        }
        return null;
    }

    public static Point translateMouseLocation(Point iLoc, Component srcComponent, WhiteboardContext context) {
        Point canvasLoc = SwingUtilities.convertPoint((ControllerPane)context.getController(), iLoc, ((ControllerPane)context.getController()).getCanvas());
        double scaleX = context.getScaleX();
        double scaleY = context.getScaleY();
        if (scaleX != 1.0 && scaleY != 1.0) {
            double newX = Math.abs(scaleX) > 1.0E-9 ? canvasLoc.getX() / scaleX : canvasLoc.getX();
            double newY = Math.abs(scaleY) > 1.0E-9 ? canvasLoc.getY() / scaleY : canvasLoc.getY();
            int xTranslate = (int)newX - canvasLoc.x;
            int yTranslate = (int)newY - canvasLoc.y;
            canvasLoc.translate(xTranslate, yTranslate);
        }
        return canvasLoc;
    }
}

