/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.presentations;

import com.elluminate.groupware.whiteboard.WhiteboardDebug;
import com.elluminate.groupware.whiteboard.module.imageloading.WBImageUtils;
import com.elluminate.groupware.whiteboard.module.presentations.FileEntry;
import com.elluminate.groupware.whiteboard.module.presentations.PowerPointImport;
import com.elluminate.groupware.whiteboard.module.presentations.PresentationImage;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;

public class PresentationSlide {
    public static final String PNG_MIME_TYPE = "image/png";
    public static final String PNG_FILE_SUFFIX = ".png";
    public static final String JPEG_MIME_TYPE = "image/jpeg";
    public static final String JPEG_FILE_SUFFIX = ".jpg";
    private static final String BKGND_NAME = "BG";
    private static final String ROOT_NAME = "Slide";
    public static final int JPEG_COMPRESSION = 85;
    public static final int PNG_COMPRESSION = 9;
    public static final int PNG_THRESHOLD = 24576;
    public static final int MAX_PNG_PERCENTAGE = 250;
    public static final int PNG_DIFF_MAX_THRESHOLD = 65536;
    public static final int DIFF_MAX_LEN_RATIO = 350;
    private int slideIndex;
    private String title;
    private int maxWidth;
    private int maxHeight;
    private String altText = null;
    private List<String> notes = new ArrayList<String>();
    private boolean followMasterBackground;
    FileEntry jpegBkgnd;
    FileEntry pngBkgnd;
    FileEntry jpegFg;
    FileEntry pngFg;
    PresentationImage[] outputImages = null;
    String containingDirectory;

    public PresentationSlide(int slideIndex, char flag, String title, String containingDirectory, int typeOfSlide, int wbWidth, int wbHeight, PowerPointImport.PowerPointLoadDialog progress, FileEntry.Factory factory) {
        String bkgName;
        String bkgContainer;
        File bgDir;
        this.slideIndex = slideIndex;
        this.followMasterBackground = flag == 'T';
        this.title = title;
        this.containingDirectory = containingDirectory;
        this.maxWidth = wbWidth;
        this.maxHeight = wbHeight;
        this.pngFg = factory.make(slideIndex, containingDirectory, ROOT_NAME, PNG_MIME_TYPE, progress);
        this.jpegFg = factory.make(slideIndex, containingDirectory, ROOT_NAME, JPEG_MIME_TYPE, progress);
        if (!this.pngFg.isEmpty() && this.jpegFg.isEmpty()) {
            try {
                Image img = this.pngFg.getImage();
                File f = new File(this.jpegFg.getPath());
                ImageSupport.saveAsJPEG((Image)img, (int)85, (File)f);
                this.jpegFg.reinitialize();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        if ((bgDir = new File(containingDirectory, BKGND_NAME)).isDirectory()) {
            bkgContainer = bgDir.toString();
            bkgName = ROOT_NAME;
        } else {
            bkgContainer = containingDirectory;
            bkgName = "SlideBG";
        }
        this.pngBkgnd = factory.make(slideIndex, bkgContainer, bkgName, PNG_MIME_TYPE, progress);
        this.jpegBkgnd = factory.make(slideIndex, bkgContainer, bkgName, JPEG_MIME_TYPE, progress);
        if (!this.pngBkgnd.isEmpty() && this.jpegBkgnd.isEmpty()) {
            try {
                Image img = this.pngBkgnd.getImage();
                File f = new File(this.jpegBkgnd.getPath());
                ImageSupport.saveAsJPEG((Image)img, (int)85, (File)f);
                this.jpegBkgnd = factory.make(slideIndex, bkgContainer, "SlideBG", JPEG_MIME_TYPE, progress);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
    }

    public static double toKB(long n) {
        return (double)((n * 10L + 1023L) / 1024L) / 10.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processSlide(PowerPointImport.PowerPointLoadDialog progress) {
        boolean haveForeground = !this.jpegFg.isEmpty() || !this.pngFg.isEmpty();
        boolean haveBackground = !this.jpegBkgnd.isEmpty() || !this.pngBkgnd.isEmpty();
        boolean havePNGs = !this.pngFg.isEmpty() && !this.pngBkgnd.isEmpty();
        boolean haveJPEGs = !this.jpegFg.isEmpty() && !this.jpegBkgnd.isEmpty();
        int outputCount = 0;
        if (haveBackground) {
            ++outputCount;
        }
        if (haveForeground) {
            ++outputCount;
        }
        if (WhiteboardDebug.POWERPOINT.show()) {
            LogSupport.message((String)"");
            LogSupport.message((Object)this, (String)"processSlide", (String)("********** Slide " + this.slideIndex + " max=" + this.maxWidth + "x" + this.maxHeight + " fg=" + haveForeground + " bg=" + haveBackground + " PNGs=" + havePNGs + " JPGs=" + haveJPEGs));
        }
        PresentationImage diff = null;
        long diffLen = 0L;
        try {
            boolean ignoreDiff;
            int h;
            int w;
            if (outputCount < 1) {
                LogSupport.message((Object)this, (String)"processSlide", (String)("No image data for slide " + this.slideIndex + ": " + this.title));
                return;
            }
            this.checkAndScaleSlide(this.pngFg, this.pngBkgnd);
            this.checkAndScaleSlide(this.jpegFg, this.jpegBkgnd);
            progress.checkCancelled();
            int n = !this.pngFg.isEmpty() ? this.pngFg.getWidth() : (w = !this.jpegFg.isEmpty() ? this.jpegFg.getWidth() : -1);
            int n2 = !this.pngFg.isEmpty() ? this.pngFg.getHeight() : (h = !this.jpegFg.isEmpty() ? this.jpegFg.getHeight() : -1);
            if (haveBackground && havePNGs) {
                if (this.pngFg.getWidth() != this.pngBkgnd.getWidth() || this.pngFg.getHeight() != this.pngBkgnd.getHeight()) {
                    if (WhiteboardDebug.POWERPOINT.show()) {
                        LogSupport.message((Object)this, (String)"processSlide", (String)("Slide " + this.slideIndex + ": " + "background image size mismatch, using foreground only."));
                    }
                } else {
                    diff = this.generateDifference(2, this.pngFg, this.pngBkgnd, progress);
                    if (diff != null) {
                        diffLen = diff.getImageData().length;
                    }
                }
                progress.checkCancelled();
            }
            int reuseBkgndFactor = 2;
            long minBkgndLen = Math.min(this.jpegBkgnd.fileLength, this.pngBkgnd.fileLength);
            long minFgLen = Math.min(this.jpegFg.fileLength, this.pngFg.fileLength);
            long combinedAdjLen = minBkgndLen / (long)reuseBkgndFactor + diffLen;
            double lenDenom = Math.max(24576L, minFgLen);
            int lenRatio = (int)Math.round(100.0 * (double)combinedAdjLen / lenDenom);
            if (WhiteboardDebug.POWERPOINT.show()) {
                Rectangle diffDim = diff != null ? diff.getArea() : new Rectangle();
                LogSupport.message((Object)this, (String)"processSlide", (String)("Slide " + this.slideIndex + ": " + w + "x" + h + " JPG: " + PresentationSlide.toKB(this.jpegFg.fileLength) + "K," + PresentationSlide.toKB(this.jpegBkgnd.fileLength) + "K PNG: " + PresentationSlide.toKB(this.pngFg.fileLength) + "K," + PresentationSlide.toKB(this.pngBkgnd.fileLength) + "K Diff: " + diffDim.width + "x" + diffDim.height + " " + PresentationSlide.toKB(diffLen) + "K" + " reuse=" + reuseBkgndFactor + " lenRatio=" + lenRatio + "%"));
            }
            boolean bl = ignoreDiff = diff == null;
            if (!ignoreDiff && diffLen > 65536L && lenRatio > 350 && combinedAdjLen - minFgLen > 24576L) {
                ignoreDiff = true;
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)this, (String)"processSlide", (String)("Slide " + this.slideIndex + " diff exceeds maximums"));
                }
            }
            if (ignoreDiff) {
                if (!this.pngFg.isEmpty() && this.pngFg.fileLength <= this.jpegFg.fileLength) {
                    if (WhiteboardDebug.POWERPOINT.show()) {
                        LogSupport.message((Object)this, (String)"processSlide", (String)("Slide " + this.slideIndex + ": PNG " + w + "x" + h + " " + PresentationSlide.toKB(this.pngFg.fileLength) + "K"));
                    }
                    this.generateOutputSlide(1, 1, this.pngFg);
                    return;
                }
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)this, (String)"processSlide", (String)("Slide " + this.slideIndex + ": JPG " + w + "x" + h + " " + PresentationSlide.toKB(this.jpegFg.fileLength) + "K"));
                }
                this.generateOutputSlide(1, 1, this.jpegFg);
                return;
            }
            int pngFactor = (int)Math.round(100.0 * (double)this.pngBkgnd.fileLength / (double)this.jpegBkgnd.fileLength / (double)reuseBkgndFactor);
            if (!this.jpegBkgnd.isEmpty() && this.jpegBkgnd.fileLength < this.pngBkgnd.fileLength && this.pngBkgnd.fileLength / (long)reuseBkgndFactor > 24576L && pngFactor > 250) {
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)this, (String)"processSlide", (String)("Slide " + this.slideIndex + ": JPG+diff " + w + "x" + h + " Bkg PNG/JPEG: " + pngFactor + "% " + PresentationSlide.toKB(this.jpegBkgnd.fileLength) + "K + " + PresentationSlide.toKB(diffLen) + "K"));
                }
                this.generateOutputSlide(2, 1, this.jpegBkgnd);
            } else {
                if (WhiteboardDebug.POWERPOINT.show()) {
                    LogSupport.message((Object)this, (String)"processSlide", (String)("Slide " + this.slideIndex + ": PNG+diff " + w + "x" + h + " Bkg PNG/JPEG: " + pngFactor + "% " + PresentationSlide.toKB(this.pngBkgnd.fileLength) + "K + " + PresentationSlide.toKB(diffLen) + "K"));
                }
                this.generateOutputSlide(2, 1, this.pngBkgnd);
            }
            this.outputImages[1] = diff;
        }
        finally {
            if (this.pngFg != null) {
                this.pngFg.dispose();
            }
            if (this.pngBkgnd != null) {
                this.pngBkgnd.dispose();
            }
            if (this.jpegFg != null) {
                this.jpegFg.dispose();
            }
            if (this.jpegBkgnd != null) {
                this.jpegBkgnd.dispose();
            }
        }
    }

    private double computeScale(int w, int h) {
        double scaleX = w < 4 ? 1.0 : Math.min(1.0, (double)this.maxWidth / (double)w);
        double scaleY = h < 4 ? 1.0 : Math.min(1.0, (double)this.maxHeight / (double)h);
        return Math.min(scaleX, scaleY);
    }

    private void checkAndScaleSlide(FileEntry fg, FileEntry bg) {
        int fgWidth = fg.getWidth();
        int fgHeight = fg.getHeight();
        int bgWidth = bg.getWidth();
        int bgHeight = bg.getHeight();
        double scale = Math.min(this.computeScale(fgWidth, fgHeight), this.computeScale(bgWidth, bgHeight));
        if (scale > 0.999) {
            return;
        }
        byte[] imgBytes = null;
        Image[] imgRef = new Image[]{null};
        int fgWidth1 = (int)Math.round((double)fgWidth * scale);
        int fgHeight1 = (int)Math.round((double)fgHeight * scale);
        int bgWidth1 = (int)Math.round((double)bgWidth * scale);
        int bgHeight1 = (int)Math.round((double)bgHeight * scale);
        if (WhiteboardDebug.POWERPOINT.show()) {
            LogSupport.message((Object)this, (String)"processSlide", (String)("Scaling slide " + this.slideIndex + " (" + fg.getMimeType() + "): " + (double)Math.round(1000.0 * scale) / 10.0 + "% " + fgWidth + "x" + fgHeight + " => " + fgWidth1 + "x" + fgHeight1));
        }
        if (fgWidth1 < fgWidth || fgHeight1 < fgHeight) {
            imgBytes = fg.getScaledImage(fgWidth1, fgHeight1, imgRef);
            fg.replaceData(imgBytes, imgRef[0]);
        }
        if (bgWidth1 < bgWidth || bgHeight1 < bgHeight) {
            imgBytes = bg.getScaledImage(bgWidth1, bgHeight1, imgRef);
            bg.replaceData(imgBytes, imgRef[0]);
        }
    }

    void generateOutputSlide(int count, int index, FileEntry slide) {
        if (this.outputImages == null) {
            this.outputImages = new PresentationImage[count];
        }
        String imageName = "pptSlide." + this.slideIndex + "." + index + slide.suffix;
        this.outputImages[index - 1] = new PresentationImage(imageName, slide);
        slide.emitted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PresentationImage generateDifference(int index, FileEntry fg, FileEntry bg, PowerPointImport.PowerPointLoadDialog progress) {
        Image clippedImage;
        String imageBaseName = "pptSlide." + this.slideIndex + "." + index;
        if (fg.getWidth() != bg.getWidth() || fg.getHeight() != bg.getHeight()) {
            throw new IllegalArgumentException("Foreground and background areas do not match for slide: " + imageBaseName);
        }
        int[] fgImage = fg.getImageArray();
        int[] bgImage = bg.getImageArray();
        boolean[] opaque = new boolean[1];
        Rectangle area = new Rectangle(0, 0, bg.getWidth(), bg.getHeight());
        Rectangle origArea = new Rectangle(area);
        Image outputImage = clippedImage = WBImageUtils.clipImage(fgImage, bgImage, area, opaque);
        progress.checkCancelled();
        if (opaque[0] && area.equals(origArea)) {
            return null;
        }
        if (area.width <= 0 || area.height <= 0) {
            return null;
        }
        byte[] imageBytes = ImageSupport.encodeAsPNG((Image)outputImage, (int)9);
        String imageName = imageBaseName + PNG_FILE_SUFFIX;
        if (WhiteboardDebug.POWERPOINT.show()) {
            File f = new File(fg.getContainingDir(), "SlideDiff" + this.slideIndex + PNG_FILE_SUFFIX);
            LogSupport.message((Object)this, (String)"generateDifference", (String)(" storing " + PresentationSlide.toKB(imageBytes.length) + "K image as " + f.getName()));
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                fos.write(imageBytes);
                fos.flush();
            }
            catch (Throwable t) {
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable ignored) {}
                }
            }
        }
        outputImage.flush();
        if (clippedImage != null && clippedImage != outputImage) {
            clippedImage.flush();
        }
        return new PresentationImage(imageName, PNG_MIME_TYPE, imageBytes, area);
    }

    public int getOutputImageCount() {
        if (this.outputImages == null) {
            return 0;
        }
        int result = 0;
        for (int ix = 0; ix < this.outputImages.length; ++ix) {
            if (this.outputImages[ix] == null) continue;
            ++result;
        }
        return result;
    }

    public PresentationImage[] getOutputImages() {
        return this.outputImages;
    }

    public int getSlideIndex() {
        return this.slideIndex;
    }

    public String getSlideTitle() {
        return this.title;
    }

    public void setAltText(String text) {
        this.altText = text;
    }

    public String getAltText() {
        return this.altText;
    }

    public void setPresenterNotes(List<String> notes) {
        if (notes != null) {
            this.notes = notes;
        }
    }

    public List<String> getPresenterNotes() {
        return this.notes;
    }

    public void dispose() {
        if (this.pngFg != null) {
            this.pngFg.dispose();
        }
        if (this.pngBkgnd != null) {
            this.pngBkgnd.dispose();
        }
        if (this.jpegFg != null) {
            this.jpegFg.dispose();
        }
        if (this.jpegBkgnd != null) {
            this.jpegBkgnd.dispose();
        }
        if (this.outputImages != null) {
            for (int i = 0; i < this.outputImages.length; ++i) {
                if (this.outputImages[i] == null) continue;
                this.outputImages[i].dispose();
            }
        }
    }
}

