/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.presentations;

import com.elluminate.groupware.whiteboard.module.presentations.FileEntry;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;

public class PresentationImage {
    FileEntry fileEntry;
    String mimeType;
    String imageName;
    byte[] imageData;
    Rectangle area = new Rectangle(0, 0, 0, 0);

    public PresentationImage(String imageName, FileEntry fileEntry) {
        this.imageName = imageName;
        this.fileEntry = fileEntry;
        this.area = new Rectangle(0, 0, fileEntry.getWidth(), fileEntry.getHeight());
        this.mimeType = fileEntry.mimeType;
        this.imageData = null;
    }

    public PresentationImage(String imageName, String mimeType, byte[] imageData, Rectangle area) {
        this.imageName = imageName;
        this.mimeType = mimeType;
        this.imageData = imageData;
        this.area = area;
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public byte[] getImageData() {
        if (this.imageData == null && this.fileEntry != null) {
            this.imageData = this.fileEntry.getData();
        }
        return this.imageData;
    }

    public Rectangle getArea() {
        return this.area;
    }

    public void setArea(Rectangle area) {
        this.area = area;
    }

    public void dispose() {
        this.imageData = null;
    }

    public int[] getImageArray() throws IOException {
        Image image = this.createImage(this.getMimeType(), this.getImageData());
        int imgW = image.getWidth(null);
        int imgH = image.getHeight(null);
        int[] imageArray = new int[imgW * imgH];
        try {
            ImageSupport.getImageArray((Image)image, (int)imgW, (int)imgH, (int[])imageArray);
        }
        catch (Exception ex) {
            LogSupport.message((Object)this, (String)"getImageArray", (String)("Exception: " + ex.getMessage()));
        }
        return imageArray;
    }

    private Image createImage(String mimeType, byte[] imageBytes) throws IOException {
        return ImageSupport.loadImage((String)mimeType, (byte[])imageBytes);
    }
}

