/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.presentations;

import com.elluminate.groupware.whiteboard.module.presentations.PowerPointImport;
import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;

class FileEntry {
    String fileName;
    String mimeType;
    String suffix;
    long fileLength;
    boolean emitted = false;
    private byte[] fileData = null;
    private Image fileImage = null;
    private int[] imageArray;
    private int height = 0;
    private int width = 0;
    private Long checksum = null;
    private int refCount = 1;
    private int totalRefs = 1;
    private PowerPointImport.PowerPointLoadDialog progress = null;

    public FileEntry(int slideIndex, String containingDirectory, String prefix, String mimeType, PowerPointImport.PowerPointLoadDialog progress) {
        this.mimeType = mimeType;
        this.suffix = mimeType.equals("image/png") ? ".png" : ".jpg";
        File file = new File(containingDirectory, prefix + slideIndex + this.suffix);
        this.fileName = file.getAbsolutePath();
        this.progress = progress;
        this.fileLength = file.isFile() && file.exists() ? file.length() : -1L;
    }

    public void reinitialize() {
        this.forgetData();
        File file = new File(this.fileName);
        this.fileLength = file.isFile() && file.exists() ? file.length() : -1L;
    }

    public String getPath() {
        return this.fileName;
    }

    public String getContainingDir() {
        if (this.fileName == null) {
            return null;
        }
        return new File(this.fileName).getParent();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void addRef() {
        ++this.refCount;
        ++this.totalRefs;
    }

    public int getNumRefs() {
        return this.totalRefs;
    }

    public long getWeightedLength() {
        if (this.emitted) {
            return 0L;
        }
        if (this.totalRefs <= 1) {
            return this.fileLength;
        }
        return this.fileLength / (long)this.totalRefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readData() {
        FileInputStream fis = null;
        if (this.fileLength > 0L && this.fileData == null) {
            this.checksum = null;
            this.fileData = new byte[(int)this.fileLength];
            try {
                fis = new FileInputStream(this.fileName);
                if (this.fileLength != (long)fis.read(this.fileData)) {
                    LogSupport.error((Object)this, (String)"readData", (String)("File short read error: " + this.fileName + ", should read: " + this.fileLength));
                    this.fileLength = -1L;
                }
            }
            catch (IOException ex) {
                LogSupport.exception((Object)this, (String)"readData", (Throwable)ex, (boolean)false, (String)("read error: " + this.fileName));
                this.fileLength = -1L;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.fileLength >= 0L;
    }

    public byte[] getData() {
        this.readData();
        return this.fileData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceData(byte[] data, Image img) {
        this.checksum = null;
        this.fileData = null;
        this.fileLength = -1L;
        this.fileImage = null;
        this.height = 0;
        this.width = 0;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.fileName);
            fos.write(data);
            fos.flush();
        }
        catch (IOException iox) {
            LogSupport.exception((Object)this, (String)"replaceData", (Throwable)iox, (boolean)true, (String)("write error: " + this.fileName));
            return;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable ignored) {}
            }
        }
        this.fileLength = data.length;
        this.fileData = data;
        if (img != null) {
            int w = img.getWidth(null);
            int h = img.getHeight(null);
            if (w > 0 && h > 0) {
                this.width = w;
                this.height = h;
                this.fileImage = img;
            }
        }
    }

    public boolean isDataRead() {
        return this.fileData != null;
    }

    public void forgetData() {
        this.fileData = null;
    }

    public Long getEncodingChecksum() {
        if (this.checksum == null) {
            this.readData();
            if (this.fileData != null) {
                CRC32 crc = new CRC32();
                crc.update(this.fileData);
                this.checksum = new Long(crc.getValue());
            } else {
                this.checksum = new Long(0L);
            }
        }
        return this.checksum;
    }

    public Image getImage() {
        if (this.fileImage == null) {
            this.readData();
            if (this.fileData != null && this.fileData.length > 0) {
                try {
                    this.fileImage = ImageSupport.loadImage((String)this.mimeType, (byte[])this.fileData, (boolean)true).getImage();
                }
                catch (IOException iox) {
                    LogSupport.exception((Object)this, (String)"getImage", (Throwable)iox, (boolean)true, (String)("I/O error converting content of " + this.fileName));
                    throw new RuntimeException("Presentation image failed to load: " + new File(this.fileName).getName(), iox);
                }
                if (this.progress != null) {
                    this.progress.checkCancelled();
                }
                if (!ImageSupport.waitForImage((Image)this.fileImage)) {
                    if (this.progress != null) {
                        this.progress.checkCancelled();
                    }
                    throw new RuntimeException("Presentation image failed to load: " + new File(this.fileName).getName() + "\n" + this.mimeType);
                }
                this.height = this.fileImage.getHeight(null);
                this.width = this.fileImage.getWidth(null);
            }
        }
        return this.fileImage;
    }

    public byte[] getScaledImage(int w, int h) {
        return this.getScaledImage(w, h, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getScaledImage(int w, int h, Image[] imgOut) {
        byte[] encoding;
        BufferedImage scaledImage;
        block7: {
            this.getImage();
            if (this.width == w && this.height == h) {
                return this.fileData;
            }
            scaledImage = ImageSupport.getScaledInstance((Image)this.fileImage, (int)w, (int)h, (Object)RenderingHints.VALUE_INTERPOLATION_BICUBIC, (boolean)true);
            encoding = null;
            try {
                if (this.mimeType.equals("image/png")) {
                    encoding = ImageSupport.encodeAsPNG((Image)scaledImage, (int)9);
                    break block7;
                }
                if (this.mimeType.equals("image/jpeg")) {
                    encoding = ImageSupport.encodeAsJPEG((Image)scaledImage, (int)85);
                    break block7;
                }
                throw new RuntimeException("Unsupported image encoding: " + this.mimeType);
            }
            finally {
                scaledImage.flush();
            }
        }
        if (imgOut != null && imgOut.length > 0) {
            imgOut[0] = scaledImage;
        }
        return encoding;
    }

    int[] getImageArray() {
        this.getImage();
        int imgW = this.getWidth();
        int imgH = this.getHeight();
        this.imageArray = new int[imgW * imgH];
        try {
            ImageSupport.getImageArray((Image)this.getImage(), (int)imgW, (int)imgH, (int[])this.imageArray);
        }
        catch (Exception ex) {
            LogSupport.message((Object)this, (String)"getImageArray", (String)("Exception: " + ex.getMessage()));
        }
        return this.imageArray;
    }

    public int getWidth() {
        this.getImage();
        return this.width;
    }

    public int getHeight() {
        this.getImage();
        return this.height;
    }

    public boolean isEmpty() {
        return this.fileLength < 1L;
    }

    public String toString() {
        return "FileEntry [ name=" + new File(this.fileName).getName() + ",type=" + this.mimeType + ",len=" + this.fileLength + ",w=" + this.width + ",h=" + this.height + ",ref=" + this.refCount + ",maxRef=" + this.totalRefs + ",img=" + this.fileImage + ",datalen=" + (this.fileData == null ? -1 : this.fileData.length) + ",imgLen=" + (this.imageArray == null ? -1 : this.imageArray.length) + " ]";
    }

    public void dispose() {
        --this.refCount;
        if (this.refCount > 0) {
            return;
        }
        Image tmpImage = this.fileImage;
        this.fileImage = null;
        this.imageArray = null;
        this.fileData = null;
        if (tmpImage != null) {
            tmpImage.flush();
        }
    }

    private static void displayImage(Image img, String title, int w, int h) {
    }

    static class Factory {
        Factory() {
        }

        FileEntry make(int slideIndex, String containingDirectory, String prefix, String mimeType, PowerPointImport.PowerPointLoadDialog progress) {
            return new FileEntry(slideIndex, containingDirectory, prefix, mimeType, progress);
        }
    }
}

