/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.imageloading;

import com.elluminate.groupware.whiteboard.module.imageloading.StringsProperties;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.Mnemonic;
import com.elluminate.gui.component.SeeThruPane;
import com.elluminate.gui.swing.CDialog;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SelectFrame
extends CDialog {
    private static final boolean DRAG_BUG = Platform.getOS() == 300 && !Platform.checkJVMVersion((String)"1.6.0_12+");
    private static final boolean ALLOW_DRAG = Boolean.getBoolean("elive.appSnap.allowDrag");
    private static final int DELAY_TIME = 10;
    private static final int MINIMUM_WIDTH = 64;
    private static final int MINIMUM_HEIGHT = 64;
    private static final int BUTTON_ALPHA = 127;
    private static final int RESIZE_DISTANCE_SQ = 81;
    private static final int DRAG_MODE_NONE = 0;
    private static final int DRAG_MODE_MOVE = 1;
    private static final int DRAG_MODE_RESIZE_TL = 2;
    private static final int DRAG_MODE_RESIZE_TR = 3;
    private static final int DRAG_MODE_RESIZE_BL = 4;
    private static final int DRAG_MODE_RESIZE_BR = 5;
    private static final int[] POINT_CURSOR = new int[]{0, 12, 6, 7, 4, 5};
    private static final int[] DRAG_CURSOR = new int[]{0, 13, 6, 7, 4, 5};
    private static final int DRAG_BOUNDS_TOLERANCE = Platform.getPlatform() == 3 ? 16 : 128;
    private static final int BASE_KEY_MOTION = 1;
    private static final int LARGE_KEY_MOTION = 16;
    private I18n i18n = I18n.create((Object)((Object)this));
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private WbImagePanel imgPanel = new WbImagePanel();
    private JButton snap = new JButton();
    private JButton cancel = new JButton();
    private JButton refresh = new JButton();
    private JButton delaySnap = new JButton();
    private boolean done = false;
    private boolean cancelled = false;
    private boolean fullScreenHack = false;
    private Rectangle selectRect = new Rectangle();
    private int wbHeight = 0;
    private int wbWidth = 0;
    private int dragMode = 0;
    private Color outSizedColor = new Color(255, 0, 0, 30);
    private LightweightTimer countdown = null;

    public static boolean isAvailable() {
        return SeeThruPane.isAvailable();
    }

    public SelectFrame(Frame parent) {
        this.initComponents();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void showModeless() {
        this.done = false;
        this.cancelled = false;
        this.fullScreenHack = false;
        this.setModal(false);
        this.pack();
        this.setVisible(true);
    }

    public Rectangle showModal() {
        this.done = false;
        this.cancelled = false;
        this.fullScreenHack = false;
        this.setModal(true);
        this.pack();
        this.setVisible(true);
        if (this.isVisible()) {
            this.setVisible(false);
        }
        return this.selectRect;
    }

    public Rectangle grabDesktop() {
        this.done = false;
        this.cancelled = false;
        this.fullScreenHack = true;
        this.setModal(true);
        this.setVisible(true);
        this.selectRect.setBounds(this.imgPanel.getSnapshot().getBounds());
        return this.selectRect;
    }

    public void setFrameLocation(int x, int y) {
        super.setLocation(x, y);
        this.selectRect.setLocation(x, y);
    }

    public void setFrameSize(int w, int h) {
        this.imgPanel.setPreferredSize(new Dimension(w, h));
        this.selectRect.setSize(w, h);
    }

    public void setWbBounds(int w, int h) {
        this.wbWidth = w;
        this.wbHeight = h;
    }

    public Rectangle getSelectRect() {
        return this.selectRect;
    }

    public Image getSelectedImage() {
        Rectangle clip = this.imgPanel.getSnapshot().getBounds().intersection(this.selectRect);
        if (clip.isEmpty()) {
            return null;
        }
        Image img = this.imgPanel.getImage(clip);
        if (clip.equals(this.selectRect)) {
            return img;
        }
        Image result = this.createImage(this.selectRect.width, this.selectRect.height);
        Graphics g = result.getGraphics();
        g.setColor(Color.black);
        g.fillRect(0, 0, this.selectRect.width, this.selectRect.height);
        g.drawImage(img, clip.x - this.selectRect.x, clip.y - this.selectRect.y, null);
        g.dispose();
        return result;
    }

    public void dispose() {
        try {
            this.disposeImage();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.dispose();
    }

    public void disposeImage() {
        this.imgPanel.clearSnapshot();
    }

    private void initComponents() {
        this.setTitle(this.i18n.getString((PropertiesEnum)StringsProperties.SELECTFRAME_SELECT_AREA));
        DragListener dragster = null;
        if (!DRAG_BUG || ALLOW_DRAG) {
            try {
                this.setUndecorated(true);
                dragster = new DragListener();
            }
            catch (Throwable t) {
                dragster = null;
            }
        }
        Mnemonic.setTextAndMnemonic((AbstractButton)this.snap, (String)this.i18n.getString((PropertiesEnum)StringsProperties.SELECTFRAME_SNAP));
        Mnemonic.setTextAndMnemonic((AbstractButton)this.cancel, (String)this.i18n.getString((PropertiesEnum)StringsProperties.SELECTFRAME_CANCEL));
        Mnemonic.setTextAndMnemonic((AbstractButton)this.refresh, (String)this.i18n.getString((PropertiesEnum)StringsProperties.SELECTFRAME_REFRESH));
        Mnemonic.setTextAndMnemonic((AbstractButton)this.delaySnap, (String)this.i18n.getString((PropertiesEnum)StringsProperties.SELECTFRAME_DELAYEDSNAP));
        Dimension ps1 = this.snap.getPreferredSize();
        Dimension ps2 = this.cancel.getPreferredSize();
        Dimension ps3 = this.refresh.getPreferredSize();
        Dimension ps4 = this.delaySnap.getPreferredSize();
        Dimension buttonSize = new Dimension(Math.max(ps1.width, Math.max(ps2.width, Math.max(ps3.width, ps4.width))), ps1.height);
        boolean useTransButtons = true;
        Color transBkg = new Color(this.snap.getBackground().getRed(), this.snap.getBackground().getGreen(), this.snap.getBackground().getBlue(), 127);
        this.snap.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.SELECTFRAME_SNAPTIP));
        this.snap.setSize(buttonSize);
        if (useTransButtons) {
            this.snap.setBackground(transBkg);
        } else {
            this.snap.setOpaque(false);
        }
        this.snap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectFrame.this.doSnap();
            }
        });
        this.snap.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ButtonModel model = SelectFrame.this.snap.getModel();
                if (!model.isPressed() && !model.isArmed()) {
                    SelectFrame.this.imgPanel.repaint();
                }
            }
        });
        this.cancel.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.SELECTFRAME_CANCELTIP));
        this.cancel.setSize(buttonSize);
        if (useTransButtons) {
            this.cancel.setBackground(transBkg);
        } else {
            this.cancel.setOpaque(false);
        }
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectFrame.this.doCancel();
            }
        });
        this.cancel.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ButtonModel model = SelectFrame.this.cancel.getModel();
                if (!model.isPressed() && !model.isArmed()) {
                    SelectFrame.this.imgPanel.repaint();
                }
            }
        });
        this.refresh.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.SELECTFRAME_REFRESHTIP));
        this.refresh.setSize(buttonSize);
        if (useTransButtons) {
            this.refresh.setBackground(transBkg);
        } else {
            this.refresh.setOpaque(false);
        }
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SelectFrame.this.isVisible()) {
                    SelectFrame.this.doRefresh("AppSnap Refresh");
                }
            }
        });
        this.refresh.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ButtonModel model = SelectFrame.this.refresh.getModel();
                if (!model.isPressed() && !model.isArmed()) {
                    SelectFrame.this.imgPanel.repaint();
                }
            }
        });
        this.delaySnap.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.SELECTFRAME_DELAYEDSNAPTIP));
        this.delaySnap.setSize(buttonSize);
        if (useTransButtons) {
            this.delaySnap.setBackground(transBkg);
        } else {
            this.delaySnap.setOpaque(false);
        }
        this.delaySnap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectFrame.this.doDelayedSnap();
            }
        });
        this.delaySnap.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ButtonModel model = SelectFrame.this.delaySnap.getModel();
                if (!model.isPressed() && !model.isArmed()) {
                    SelectFrame.this.imgPanel.repaint();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SelectFrame.this.doClosed();
            }

            @Override
            public void windowOpened(WindowEvent e) {
                SelectFrame.this.doOpened();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                SelectFrame.this.updateDisplay(false);
            }

            @Override
            public void componentResized(ComponentEvent e) {
                SelectFrame.this.updateDisplay(false);
            }

            @Override
            public void componentShown(ComponentEvent ev) {
                SelectFrame.this.snap.requestFocus();
            }
        });
        this.dragMode = 0;
        this.updateCursor(this.dragMode, false);
        if (dragster != null) {
            this.getContentPane().addMouseListener(dragster);
            this.getContentPane().addMouseMotionListener(dragster);
        }
        KeyAdapter keyMover = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ev) {
                int code = ev.getKeyCode();
                int val = ev.isShiftDown() ? 16 : 1;
                int dx = 0;
                int dy = 0;
                switch (code) {
                    case 38: {
                        dy = -val;
                        break;
                    }
                    case 40: {
                        dy = val;
                        break;
                    }
                    case 37: {
                        dx = -val;
                        break;
                    }
                    case 39: {
                        dx = val;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                Rectangle desktop = GuiUtils.getDesktopBounds();
                desktop.grow(-16, -16);
                Rectangle b = new Rectangle(SelectFrame.this.getBounds());
                b.translate(dx, dy);
                if (!desktop.intersects(b)) {
                    return;
                }
                SelectFrame.this.setBounds(b);
            }
        };
        this.snap.addKeyListener(keyMover);
        this.cancel.addKeyListener(keyMover);
        this.refresh.addKeyListener(keyMover);
        this.delaySnap.addKeyListener(keyMover);
        ActionListener escaper = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SelectFrame.this.doEscape();
            }
        };
        this.imgPanel.registerKeyboardAction(escaper, "escape", KeyStroke.getKeyStroke(27, 0, false), 2);
        ActionListener snapper = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SelectFrame.this.doSnap();
            }
        };
        this.snap.registerKeyboardAction(snapper, "snap", KeyStroke.getKeyStroke(10, 0, false), 2);
        this.bindAlternateModifiers(this.snap, snapper, "snap");
        ActionListener canceller = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SelectFrame.this.doCancel();
            }
        };
        this.cancel.registerKeyboardAction(canceller, "cancel", KeyStroke.getKeyStroke(3, 0, false), 2);
        this.bindAlternateModifiers(this.cancel, canceller, "cancel");
        ActionListener refresher = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SelectFrame.this.doRefresh("AppSnap Refresh");
            }
        };
        this.bindAlternateModifiers(this.refresh, refresher, "refresh");
        ActionListener delayedSnapper = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SelectFrame.this.doDelayedSnap();
            }
        };
        this.bindAlternateModifiers(this.delaySnap, delayedSnapper, "delayedSnap");
        this.imgPanel.setLayout(null);
        this.imgPanel.add(this.snap);
        this.imgPanel.add(this.cancel);
        this.imgPanel.add(this.refresh);
        this.imgPanel.add(this.delaySnap);
        this.mainPanel.setBorder(new LineBorder(SystemColor.windowBorder, 2));
        this.mainPanel.add((Component)((Object)this.imgPanel), "Center");
        this.getContentPane().add(this.mainPanel);
        this.imgPanel.register();
    }

    private void bindAlternateModifiers(AbstractButton btn, ActionListener action, String cmd) {
        int mnemonicKey = btn.getMnemonic();
        if (mnemonicKey == 0) {
            return;
        }
        btn.registerKeyboardAction(action, cmd, KeyStroke.getKeyStroke(mnemonicKey, 0, false), 2);
        btn.registerKeyboardAction(action, cmd, KeyStroke.getKeyStroke(mnemonicKey, 1, false), 2);
        btn.registerKeyboardAction(action, cmd, KeyStroke.getKeyStroke(mnemonicKey, 2, false), 2);
        btn.registerKeyboardAction(action, cmd, KeyStroke.getKeyStroke(mnemonicKey, 4, false), 2);
    }

    private void updateDisplay(boolean immediate) {
        try {
            SwingRunnerSupport.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    SelectFrame.this.setButtonLocation();
                    SelectFrame.this.imgPanel.repaint();
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private int getDragMode(int x, int y) {
        Dimension dim = this.getContentPane().getSize();
        int mode = 0;
        mode = SelectFrame.distanceSq(x, y, 0, 0) <= 81 ? 2 : (SelectFrame.distanceSq(x, y, dim.width - 1, 0) <= 81 ? 3 : (SelectFrame.distanceSq(x, y, 0, dim.height - 1) <= 81 ? 4 : (SelectFrame.distanceSq(x, y, dim.width - 1, dim.height - 1) <= 81 ? 5 : 1)));
        return mode;
    }

    private void updateCursor(int mode, boolean isDrag) {
        int[] cursorList = isDrag ? DRAG_CURSOR : POINT_CURSOR;
        Cursor curs = null;
        if (cursorList != null && mode >= 0 && mode < cursorList.length) {
            curs = Cursor.getPredefinedCursor(cursorList[mode]);
        }
        if (curs == null) {
            curs = Cursor.getDefaultCursor();
        }
        this.imgPanel.setCursor(curs);
    }

    private void doOpened() {
        this.doRefresh("AppSnap Initial Capture");
    }

    private void doClosed() {
        this.disposeImage();
        this.cancelled = true;
        this.done = true;
    }

    private void doCancel() {
        this.disposeImage();
        this.cancelled = true;
        this.setVisible(false);
        this.done = true;
    }

    public void doEscape() {
        LightweightTimer ctimer = this.countdown;
        if (ctimer != null) {
            this.cancelDelayedSnap(ctimer);
            return;
        }
        this.doCancel();
    }

    private void doSnap() {
        this.computeSelectRect();
        this.cancelled = false;
        this.setVisible(false);
        this.done = true;
    }

    private void doDelayedSnap() {
        LightweightTimer ctimer = this.countdown;
        if (ctimer != null) {
            this.cancelDelayedSnap(ctimer);
            return;
        }
        this.snap.setEnabled(false);
        this.cancel.setEnabled(false);
        this.refresh.setEnabled(false);
        String s = null;
        try {
            s = this.i18n.getStringLegacy("SelectFrame.Delay10");
        }
        catch (Throwable t) {
            s = Integer.toString(10);
        }
        this.delaySnap.setText(s);
        this.delaySnap.requestFocus();
        Runnable timerAction = new Runnable(){
            private int count = 10;

            @Override
            public void run() {
                --this.count;
                String s = null;
                try {
                    s = SelectFrame.this.i18n.getStringLegacy("SelectFrame.Delay" + this.count);
                }
                catch (Throwable t) {
                    s = Integer.toString(this.count);
                }
                SelectFrame.this.delaySnap.setText(s);
                SelectFrame.this.imgPanel.repaint();
                if (this.count <= 0) {
                    LightweightTimer ctimer = SelectFrame.this.countdown;
                    SelectFrame.this.countdown = null;
                    if (ctimer != null) {
                        ctimer.cancel();
                        SelectFrame.this.computeSelectRect();
                        SelectFrame.this.doRefresh("AppSnap Delayed Capture", true, false);
                    }
                }
            }
        };
        this.countdown = new LightweightTimer(2, timerAction);
        this.countdown.scheduleEvery(1000L);
    }

    private void cancelDelayedSnap(LightweightTimer ctimer) {
        this.countdown = null;
        ctimer.cancel();
        Mnemonic.setTextAndMnemonic((AbstractButton)this.delaySnap, (String)this.i18n.getString((PropertiesEnum)StringsProperties.SELECTFRAME_DELAYEDSNAP));
        this.snap.setEnabled(true);
        this.cancel.setEnabled(true);
        this.refresh.setEnabled(true);
        this.imgPanel.repaint();
    }

    private void doRefresh(String threadName) {
        this.doRefresh(threadName, this.fullScreenHack, true);
    }

    private void doRefresh(String threadName, final boolean snapWhenDone, final boolean updateWhenDone) {
        WorkerThread t = new WorkerThread(threadName){

            public void run() {
                final Runnable[] undo = new Runnable[]{null};
                try {
                    SwingRunnerSupport.invokeAndWait((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            undo[0] = GuiUtils.hideWindow((Window)((Object)SelectFrame.this));
                        }
                    });
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                boolean ok = false;
                for (int ix = 0; ix < 3 && !ok; ++ix) {
                    if (ix > 0) {
                        LogSupport.message((Object)((Object)this), (String)"run (for SelectFrame.doRefresh)", (String)("Snap retry " + ix));
                        try {
                            Thread.sleep(250L);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    ok = SelectFrame.this.imgPanel.refresh();
                }
                if (!ok) {
                    LogSupport.message((Object)((Object)this), (String)"run (for SelectFrame.doRefresh)", (String)"Failed to acquire snapshot.");
                }
                try {
                    SwingRunnerSupport.invokeAndWait((Runnable)undo[0]);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (updateWhenDone || snapWhenDone) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (updateWhenDone) {
                                SelectFrame.this.updateDisplay(true);
                            }
                            if (snapWhenDone) {
                                SelectFrame.this.doSnap();
                            }
                        }
                    });
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    private void computeSelectRect() {
        if (!this.isShowing()) {
            return;
        }
        this.getLocationOnScreen();
        this.selectRect.setBounds(this.imgPanel.getDisplayBounds());
    }

    private void setButtonLocation() {
        Rectangle b;
        Rectangle onScreen;
        if (!this.isVisible()) {
            return;
        }
        Rectangle desktopArea = new Rectangle();
        Rectangle[] screens = GuiUtils.getScreenBounds((Rectangle)desktopArea);
        if (Platform.getPlatform() == 2 && screens.length > 0) {
            int mbarHeight = 22;
            screens[0] = new Rectangle(screens[0]);
            screens[0].y += mbarHeight;
            screens[0].height -= mbarHeight;
            desktopArea.setBounds(screens[0]);
            for (int ix = 1; ix < screens.length; ++ix) {
                desktopArea.add(screens[ix]);
            }
        }
        Point scrnLoc = this.imgPanel.getScreenLocation();
        Rectangle panelRect = new Rectangle(scrnLoc, this.imgPanel.getSize());
        Point p = new Point(panelRect.x + panelRect.width / 2, panelRect.y + panelRect.height / 2);
        Rectangle clipRect = new Rectangle(desktopArea);
        if (screens.length > 1) {
            Rectangle isect;
            int midScreen = -1;
            int hitScreen = -1;
            int hitArea = 0;
            int minHeight = this.snap.getSize().height + 2;
            int minWidth = (this.snap.getSize().width + this.cancel.getSize().width) / 2 + 5;
            boolean isMin = false;
            for (int ix = 0; ix < screens.length; ++ix) {
                if (screens[ix].contains(p)) {
                    midScreen = ix;
                }
                isect = screens[ix].intersection(panelRect);
                int area = isect.width * isect.height;
                if (area <= hitArea && (isMin || isect.width < minWidth || isect.height < minHeight)) continue;
                hitScreen = ix;
                hitArea = area;
                isMin = isect.width >= minWidth && isect.height >= minHeight;
            }
            if (hitScreen >= 0) {
                Rectangle scrn = screens[hitScreen];
                isect = scrn.intersection(panelRect);
                int midx = isect.x + isect.width / 2;
                int midy = isect.y + isect.height / 2;
                boolean offLeft = panelRect.x < scrn.x;
                boolean offRight = panelRect.x + panelRect.width > scrn.x + scrn.width;
                boolean offTop = panelRect.y < scrn.y;
                boolean offBottom = panelRect.y + panelRect.height > scrn.y + scrn.height;
                for (int ix = 0; ix < screens.length; ++ix) {
                    if (ix == hitScreen || !screens[ix].intersects(panelRect)) continue;
                    if (offLeft && screens[ix].x + screens[ix].width >= scrn.x && midy - minHeight >= screens[ix].y && midy + minHeight < screens[ix].y + screens[ix].height) {
                        offLeft = false;
                    }
                    if (offRight && screens[ix].x <= scrn.x + scrn.width && midy - minHeight >= screens[ix].y && midy + minHeight < screens[ix].y + screens[ix].height) {
                        offRight = false;
                    }
                    if (offTop && screens[ix].y + screens[ix].height >= scrn.y && midx - minWidth >= screens[ix].x && midx + minWidth < screens[ix].x + screens[ix].width) {
                        offTop = false;
                    }
                    if (!offBottom || screens[ix].y > scrn.y + scrn.height || midx - minWidth < screens[ix].x || midx + minWidth >= screens[ix].x + screens[ix].width) continue;
                    offBottom = false;
                }
                if (offLeft && scrn.x > clipRect.x) {
                    clipRect.width -= scrn.x - clipRect.x;
                    clipRect.x = scrn.x;
                }
                if (offRight && scrn.x + scrn.width < clipRect.x + clipRect.width) {
                    clipRect.width -= clipRect.x + clipRect.width - (scrn.x + scrn.width);
                }
                if (offTop && scrn.y > clipRect.y) {
                    clipRect.height -= scrn.y - clipRect.y;
                    clipRect.y = scrn.y;
                }
                if (offBottom && scrn.y + scrn.height < clipRect.y + clipRect.height) {
                    clipRect.height -= clipRect.y + clipRect.height - (scrn.y + scrn.height);
                }
            }
        }
        if ((onScreen = clipRect.getBounds().intersection(panelRect)).isEmpty()) {
            return;
        }
        Point center = new Point(Math.max(0, clipRect.x - scrnLoc.x) + onScreen.getSize().width / 2, Math.max(0, clipRect.y - scrnLoc.y) + onScreen.getSize().height / 2);
        int padX = (onScreen.getSize().width - Math.max(this.snap.getSize().width, this.delaySnap.getSize().width) - Math.max(this.cancel.getSize().width, this.refresh.getSize().width)) / 3;
        int padY = (onScreen.getSize().height - Math.max(this.snap.getSize().height, this.cancel.getSize().height) - Math.max(this.delaySnap.getSize().height, this.refresh.getSize().height)) / 3;
        if (padX < 0) {
            padX = 0;
        }
        if (padX > 5) {
            padX = 5;
        }
        if (padY < 0) {
            padY = 0;
        }
        if (padY > 5) {
            padY = 5;
        }
        Point snapLocation = this.makePoint(center.x - this.snap.getSize().width - padX / 2, center.y - this.snap.getSize().height - padY / 2, this.snap.getSize(), true, true);
        Point cancelLocation = this.makePoint(center.x + (padX + 1) / 2, center.y - this.cancel.getSize().height - padY / 2, this.cancel.getSize(), true, true);
        Point delayLocation = this.makePoint(center.x - this.delaySnap.getSize().width - padX / 2, center.y + (padY + 1) / 2, this.delaySnap.getSize(), true, true);
        Point refreshLocation = this.makePoint(center.x + (padX + 1) / 2, center.y + (padY + 1) / 2, this.refresh.getSize(), true, true);
        int overlapArea = 0;
        Rectangle a = new Rectangle(snapLocation, this.snap.getSize());
        Rectangle c = a.intersection(b = new Rectangle(cancelLocation, this.cancel.getSize()));
        if (!c.isEmpty()) {
            overlapArea += c.width * c.height;
        }
        b.setLocation(delayLocation);
        b.setSize(this.delaySnap.getSize());
        c = a.intersection(b);
        if (!c.isEmpty()) {
            overlapArea += c.width * c.height;
        }
        a.setLocation(cancelLocation);
        a.setSize(this.cancel.getSize());
        c = a.intersection(b);
        if (!c.isEmpty()) {
            overlapArea += c.width * c.height;
        }
        b.setLocation(delayLocation);
        b.setSize(this.delaySnap.getSize());
        c = a.intersection(b);
        if (!c.isEmpty()) {
            overlapArea += c.width * c.height;
        }
        if (overlapArea > 0) {
            int vOverlap = 0;
            int hOverlap = 0;
            int tmp = this.snap.getSize().height + this.cancel.getSize().height + this.delaySnap.getSize().height + this.refresh.getSize().height - onScreen.height;
            if (tmp > 0) {
                vOverlap = tmp / 3 * Math.min(this.snap.getSize().width, this.cancel.getSize().width) + (tmp + 1) / 3 * Math.min(this.cancel.getSize().width, this.delaySnap.getSize().width) + (tmp + 1) / 3 * Math.min(this.delaySnap.getSize().width, this.refresh.getSize().width);
            }
            if ((tmp = this.snap.getSize().width + this.cancel.getSize().width + this.delaySnap.getSize().width + this.refresh.getSize().width - onScreen.width) > 0) {
                hOverlap = tmp / 3 * Math.min(this.snap.getSize().height, this.cancel.getSize().height) + (tmp + 1) / 3 * Math.min(this.cancel.getSize().height, this.delaySnap.getSize().height) + (tmp + 1) / 3 * Math.min(this.delaySnap.getSize().height, this.refresh.getSize().height);
            }
            if (vOverlap <= hOverlap && vOverlap < overlapArea) {
                padY = (onScreen.getSize().height - this.snap.getSize().height - this.cancel.getSize().height - this.delaySnap.getSize().height - this.refresh.getSize().height) / 5;
                if (padY < 0) {
                    padY = 0;
                }
                if (padY > 5) {
                    padY = 5;
                }
                snapLocation = this.makePoint(center.x - this.snap.getSize().width / 2, center.y - this.snap.getSize().height - this.cancel.getSize().height - padY * 3 / 2, this.snap.getSize(), false, true);
                cancelLocation = this.makePoint(center.x - this.cancel.getSize().width / 2, center.y - this.cancel.getSize().height - padY / 2, this.cancel.getSize(), false, true);
                delayLocation = this.makePoint(center.x - this.delaySnap.getSize().width / 2, center.y + (padY + 1) / 2, this.delaySnap.getSize(), false, true);
                refreshLocation = this.makePoint(center.x - this.refresh.getSize().width / 2, center.y + this.delaySnap.getSize().height + (padY * 3 + 1) / 2, this.refresh.getSize(), false, true);
            } else if (hOverlap < vOverlap && hOverlap < overlapArea) {
                padX = (onScreen.getSize().width - this.snap.getSize().width - this.cancel.getSize().width - this.delaySnap.getSize().width - this.refresh.getSize().width) / 5;
                if (padX < 0) {
                    padX = 0;
                }
                if (padX > 5) {
                    padX = 5;
                }
                snapLocation = this.makePoint(center.x - this.snap.getSize().width - this.cancel.getSize().width - padX * 3 / 2, center.y - this.snap.getSize().height / 2, this.snap.getSize(), true, false);
                cancelLocation = this.makePoint(center.x - this.cancel.getSize().width - padX / 2, center.y - this.cancel.getSize().height / 2, this.cancel.getSize(), true, false);
                delayLocation = this.makePoint(center.x + (padX + 1) / 2, center.y - this.cancel.getSize().height / 2, this.delaySnap.getSize(), true, false);
                refreshLocation = this.makePoint(center.x + this.delaySnap.getSize().width + (padX * 3 + 1) / 25, center.y - this.cancel.getSize().height / 2, this.refresh.getSize(), true, false);
            }
        }
        if (this.snap.getLocation().distance(snapLocation) > 0.01) {
            this.snap.repaint();
            this.snap.setLocation(snapLocation);
            this.snap.repaint();
        }
        if (this.cancel.getLocation().distance(cancelLocation) > 0.01) {
            this.cancel.repaint();
            this.cancel.setLocation(cancelLocation);
            this.cancel.repaint();
        }
        if (this.delaySnap.getLocation().distance(delayLocation) > 0.01) {
            this.delaySnap.repaint();
            this.delaySnap.setLocation(delayLocation);
            this.delaySnap.repaint();
        }
        if (this.refresh.getLocation().distance(refreshLocation) > 0.01) {
            this.refresh.repaint();
            this.refresh.setLocation(refreshLocation);
            this.refresh.repaint();
        }
    }

    private Point makePoint(int x, int y, Dimension siz, boolean checkX, boolean checkY) {
        Point pt = new Point(x, y);
        Dimension mySize = this.imgPanel.getSize();
        if (checkX) {
            if (siz.width + 4 > mySize.width) {
                pt.x = mySize.width / 2 - siz.width / 2;
            } else if (pt.x < 2) {
                pt.x = 2;
            } else if (pt.x + siz.width > mySize.width - 2) {
                pt.x = mySize.width - siz.width - 2;
            }
        }
        if (checkY) {
            if (siz.height + 4 > mySize.height) {
                pt.y = mySize.height / 2 - siz.height / 2;
            } else if (pt.y < 2) {
                pt.y = 2;
            } else if (pt.y + siz.height > mySize.height - 2) {
                pt.y = mySize.height - siz.height - 2;
            }
        }
        return pt;
    }

    private static int distanceSq(int x1, int y1, int x2, int y2) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        return dx * dx + dy * dy;
    }

    class DragListener
    implements MouseListener,
    MouseMotionListener {
        private int dragPosX = 0;
        private int dragPosY = 0;
        private Component dragComponent = null;
        private Rectangle desktop = null;
        private Point curPos = new Point();

        DragListener() {
        }

        private void registerDrag(Component cmp, int x, int y) {
            this.desktop = GuiUtils.getDesktopBounds();
            this.curPos.setLocation(x, y);
            SwingUtilities.convertPointToScreen(this.curPos, cmp);
            if (!this.desktop.contains(this.curPos)) {
                return;
            }
            this.dragComponent = cmp;
            this.dragPosX = this.curPos.x;
            this.dragPosY = this.curPos.y;
        }

        private void abortDrag() {
            this.dragComponent = null;
            this.desktop = null;
            SelectFrame.this.dragMode = 0;
            SelectFrame.this.updateCursor(SelectFrame.this.dragMode, true);
        }

        @Override
        public void mousePressed(MouseEvent mev) {
            this.registerDrag(mev.getComponent(), mev.getX(), mev.getY());
            SelectFrame.this.dragMode = SelectFrame.this.getDragMode(mev.getX(), mev.getY());
            SelectFrame.this.updateCursor(SelectFrame.this.dragMode, true);
        }

        @Override
        public void mouseReleased(MouseEvent mev) {
            this.abortDrag();
            SelectFrame.this.updateCursor(SelectFrame.this.getDragMode(mev.getX(), mev.getY()), false);
            if (mev.getClickCount() == 2) {
                SelectFrame.this.setButtonLocation();
                SelectFrame.this.imgPanel.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mev) {
            if (SelectFrame.this.dragMode != 0 && (mev.getModifiers() & 0x10) == 0) {
                SelectFrame.this.dragMode = 0;
            }
            if (SelectFrame.this.dragMode != 0) {
                SelectFrame.this.updateCursor(SelectFrame.this.dragMode, true);
            } else {
                SelectFrame.this.updateCursor(SelectFrame.this.getDragMode(mev.getX(), mev.getY()), false);
            }
        }

        @Override
        public void mouseExited(MouseEvent mev) {
            if (SelectFrame.this.dragMode == 0) {
                SelectFrame.this.imgPanel.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseClicked(MouseEvent mev) {
        }

        @Override
        public void mouseDragged(MouseEvent mev) {
            int y;
            if (SelectFrame.this.dragMode == 0) {
                return;
            }
            if (this.dragComponent == null) {
                return;
            }
            if (this.dragComponent != mev.getComponent()) {
                return;
            }
            int x = mev.getX();
            if (!this.dragComponent.contains(x, y = mev.getY())) {
                Rectangle b = this.dragComponent.getBounds();
                if (x < b.x - DRAG_BOUNDS_TOLERANCE || y < b.y - DRAG_BOUNDS_TOLERANCE || x > b.x + b.width + DRAG_BOUNDS_TOLERANCE || y > b.y + b.height + DRAG_BOUNDS_TOLERANCE) {
                    return;
                }
            }
            this.curPos.setLocation(x, y);
            SwingUtilities.convertPointToScreen(this.curPos, mev.getComponent());
            if (!this.desktop.contains(this.curPos)) {
                return;
            }
            this.doDrag(this.curPos.x - this.dragPosX, this.curPos.y - this.dragPosY);
            this.dragPosX = this.curPos.x;
            this.dragPosY = this.curPos.y;
            SelectFrame.this.updateCursor(SelectFrame.this.dragMode, true);
        }

        @Override
        public void mouseMoved(MouseEvent mev) {
            if (SelectFrame.this.dragMode != 0) {
                SelectFrame.this.updateCursor(SelectFrame.this.dragMode, false);
            } else {
                SelectFrame.this.updateCursor(SelectFrame.this.getDragMode(mev.getX(), mev.getY()), false);
            }
        }

        private void doDrag(int dx, int dy) {
            if (dx == 0 && dy == 0) {
                return;
            }
            Rectangle bounds = SelectFrame.this.getBounds();
            switch (SelectFrame.this.dragMode) {
                case 2: {
                    if (bounds.width - dx < 64) {
                        dx = bounds.width - 64;
                    }
                    if (bounds.height - dy < 64) {
                        dy = bounds.height - 64;
                    }
                    if (dx == 0 && dy == 0) {
                        return;
                    }
                    bounds.x += dx;
                    bounds.y += dy;
                    bounds.width -= dx;
                    bounds.height -= dy;
                    break;
                }
                case 3: {
                    if (bounds.width + dx < 64) {
                        dx = 64 - bounds.width;
                    }
                    if (bounds.height - dy < 64) {
                        dy = bounds.height - 64;
                    }
                    if (dx == 0 && dy == 0) {
                        return;
                    }
                    bounds.y += dy;
                    bounds.width += dx;
                    bounds.height -= dy;
                    break;
                }
                case 4: {
                    if (bounds.width - dx < 64) {
                        dx = bounds.width - 64;
                    }
                    if (bounds.height + dy < 64) {
                        dy = 64 - bounds.height;
                    }
                    if (dx == 0 && dy == 0) {
                        return;
                    }
                    bounds.x += dx;
                    bounds.width -= dx;
                    bounds.height += dy;
                    break;
                }
                case 5: {
                    if (bounds.width + dx < 64) {
                        dx = 64 - bounds.width;
                    }
                    if (bounds.height + dy < 64) {
                        dy = 64 - bounds.height;
                    }
                    if (dx == 0 && dy == 0) {
                        return;
                    }
                    bounds.width += dx;
                    bounds.height += dy;
                    break;
                }
                case 1: {
                    bounds.x += dx;
                    bounds.y += dy;
                    break;
                }
                default: {
                    return;
                }
            }
            if (!bounds.intersects(this.desktop)) {
                this.abortDrag();
                return;
            }
            SelectFrame.this.setBounds(bounds);
        }
    }

    class WbImagePanel
    extends SeeThruPane {
        WbImagePanel() {
        }

        public void paintComponent(Graphics g) {
            try {
                super.paintComponent(g);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (!this.isShowing()) {
                return;
            }
            Rectangle bounds = super.getBounds();
            Insets ins = super.getInsets();
            bounds.x = ins.left;
            bounds.y = ins.top;
            bounds.width -= ins.left + ins.right;
            bounds.height -= ins.top + ins.bottom;
            Graphics2D g2 = (Graphics2D)g;
            if (bounds.width > SelectFrame.this.wbWidth) {
                try {
                    g2.setColor(SelectFrame.this.outSizedColor);
                    g2.fillRect(bounds.x + SelectFrame.this.wbWidth, bounds.y, bounds.width - SelectFrame.this.wbWidth, Math.min(SelectFrame.this.wbHeight, bounds.height));
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (bounds.height > SelectFrame.this.wbHeight) {
                try {
                    g2.setColor(SelectFrame.this.outSizedColor);
                    g2.fillRect(bounds.x, bounds.y + SelectFrame.this.wbHeight, bounds.width, bounds.height - SelectFrame.this.wbHeight);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    }
}

