/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.imageloading;

import com.elluminate.groupware.whiteboard.module.imageloading.PaletteEntry;
import com.elluminate.groupware.whiteboard.module.imageloading.Palettes;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

class PaletteTableModel
extends AbstractTableModel {
    public static final int TITLE_COLUMN = 0;
    public static final int VISIBLE_COLUMN = 1;
    public static final int NUMBER_OF_COLUMNS = 2;
    ArrayList palettes = new ArrayList();

    public PaletteTableModel(Palettes palettes) {
        this.mergeModel(palettes);
    }

    public void mergeModel(Palettes palettes) {
        if (palettes == null) {
            return;
        }
        Iterator iter = palettes.paletteEntryIterator();
        while (iter.hasNext()) {
            PaletteEntry paletteEntry = (PaletteEntry)iter.next();
            if (this.palettes.contains(paletteEntry)) continue;
            this.palettes.add(paletteEntry);
            this.fireTableChanged(new TableModelEvent(this));
        }
    }

    @Override
    public int getRowCount() {
        return this.palettes.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        PaletteEntry entry = (PaletteEntry)this.palettes.get(row);
        switch (column) {
            case 0: {
                return entry.getLocalizedPaletteTitle();
            }
            case 1: {
                return new Boolean(entry.isVisible());
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Palette Title";
            }
            case 1: {
                return "Visible";
            }
        }
        return "Unknown";
    }

    public Class getColumnClass(int column) {
        switch (column) {
            default: {
                return String.class;
            }
            case 1: 
        }
        return Boolean.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 1;
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (column != 1 || row < 0 || row >= this.getRowCount()) {
            return;
        }
        PaletteEntry entry = (PaletteEntry)this.palettes.get(row);
        if (aValue instanceof Boolean) {
            Boolean value = (Boolean)aValue;
            entry.setVisible(value);
        }
    }
}

