/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.imageloading;

import com.elluminate.groupware.whiteboard.module.imageloading.ImageData;
import com.elluminate.groupware.whiteboard.module.imageloading.PaletteBuilderDialog;
import com.elluminate.groupware.whiteboard.module.imageloading.PaletteEntry;
import com.elluminate.groupware.whiteboard.module.imageloading.PaletteFileFilter;
import com.elluminate.groupware.whiteboard.module.imageloading.Palettes;
import com.elluminate.groupware.whiteboard.module.imageloading.PalettesFileListEntry;
import com.elluminate.groupware.whiteboard.module.imageloading.StringsProperties;
import com.elluminate.gui.FontUtils;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.CToolBarButton;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.swing.CFileChooser;
import com.elluminate.gui.swing.CTree;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.StringComparator;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class PaletteOrganizeDialog
extends EasyDialog
implements TreeSelectionListener {
    private static final boolean DEBUG_BUTTONS = false;
    private static final boolean DEBUG = false;
    private static I18n i18n = I18n.create((Object)new Object(){});
    private static File defaultDirectory = null;
    private JPanel dialogPane = new JPanel();
    private JToolBar toolBar = new JToolBar();
    private JButton newButton = new CToolBarButton();
    private JButton loadButton = new CToolBarButton();
    private JButton removeButton = new CToolBarButton();
    private JButton editButton = new CToolBarButton();
    private JScrollPane paletteTreeScroller = new JScrollPane();
    private JButton doneButton = new JButton();
    private TitledBorder paletteTitle;
    private Palettes palettes = null;
    private JTree paletteTree = null;
    private DefaultTreeModel paletteTreeModel = null;
    private Frame frame = null;
    private ArrayList addedPalettes = null;
    private double splitterWeight = 0.61803398875;
    private String addedPalettesKey;

    public PaletteOrganizeDialog(Frame frame, String title, ArrayList addedPalettes, Palettes palettes, String addedPalettesKey) {
        super((Component)frame, title);
        this.setResizable(true);
        this.setInsets(null);
        this.setDefaultCloseOperation(1);
        this.frame = frame;
        this.palettes = palettes;
        this.addedPalettes = addedPalettes;
        this.addedPalettesKey = addedPalettesKey;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"PaletteEditDialog", (Throwable)ex, (boolean)true);
        }
    }

    public PaletteOrganizeDialog() {
        this(null, "", new ArrayList(), null, "");
    }

    private void jbInit() throws Exception {
        this.dialogPane.setLayout(new BorderLayout(0, 0));
        this.dialogPane.add((Component)this.toolBar, "North");
        this.dialogPane.add((Component)this.paletteTreeScroller, "Center");
        this.toolBar.setFloatable(false);
        this.initButton(this.newButton, "newButton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteOrganizeDialog.this.createButton_actionPerformed(e);
            }
        });
        this.initButton(this.loadButton, "loadButton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteOrganizeDialog.this.loadButton_actionPerformed(e);
            }
        });
        this.initButton(this.removeButton, "removeButton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteOrganizeDialog.this.removeButton_actionPerformed(e);
            }
        });
        this.initButton(this.editButton, "editButton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteOrganizeDialog.this.editButton_actionPerformed(e);
            }
        });
        this.initButton(this.doneButton, "cancelButton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteOrganizeDialog.this.doneButton_actionPerformed(e);
            }
        });
        this.paletteTreeModel = this.buildTree(this.palettes, null, false);
        this.paletteTree = new CTree((TreeModel)this.paletteTreeModel);
        this.paletteTreeScroller.setViewportView(this.paletteTree);
        this.paletteTreeScroller.setVerticalScrollBarPolicy(22);
        this.paletteTreeScroller.setHorizontalScrollBarPolicy(30);
        this.paletteTreeScroller.setPreferredSize(new Dimension(300, 300));
        this.paletteTreeScroller.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.GRAY));
        this.toolBar.add(this.newButton);
        this.toolBar.add(this.loadButton);
        this.toolBar.add(this.removeButton);
        this.toolBar.add(this.editButton);
        this.paletteTree.setRootVisible(false);
        this.paletteTree.setShowsRootHandles(true);
        this.paletteTree.setCellRenderer(new PaletteRenderer(this.paletteTree));
        this.paletteTree.setCellEditor(new PaletteRenderer(this.paletteTree));
        this.paletteTree.setEditable(true);
        this.paletteTree.setSelectionModel(new DefaultTreeSelectionModel());
        this.paletteTree.addTreeSelectionListener(this);
        this.expandAll(this.paletteTree);
        this.paletteTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e instanceof MouseEvent) {
                    Object node;
                    MouseEvent mouseEvent = e;
                    TreePath path = PaletteOrganizeDialog.this.paletteTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (path != null && !((node = path.getLastPathComponent()) instanceof PaletteTreeNode)) {
                        return;
                    }
                    PaletteOrganizeDialog.this.paletteTree.clearSelection();
                }
            }
        });
        this.removeButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.setContent(this.dialogPane);
        this.addCancelButton(this.doneButton);
        this.setInitialFocus(this.paletteTree);
    }

    private void initButton(JButton button, String buttonName, ActionListener listener) {
        String buttonData = "PaletteEditDialog." + buttonName;
        try {
            button.setText(i18n.getStringLegacy(buttonData + "Text"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            button.setIcon(i18n.getIcon(buttonData + "Icon"));
        }
        catch (Exception ex1) {
            // empty catch block
        }
        try {
            button.setToolTipText(i18n.getStringLegacy(buttonData + "ToolTip"));
        }
        catch (Exception ex2) {
            // empty catch block
        }
        button.addActionListener(listener);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        boolean visible = false;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.paletteTree.getLastSelectedPathComponent();
        if (node != null) {
            Object nodeInfo = node.getUserObject();
            if (!(nodeInfo instanceof String) && !(nodeInfo instanceof PalettesFileListEntry)) {
                this.paletteTree.clearSelection();
            } else {
                String path = "**";
                Object info = node.getUserObject();
                if (info instanceof String) {
                    path = (String)info;
                } else if (info instanceof PalettesFileListEntry) {
                    path = ((PalettesFileListEntry)info).getURL();
                }
                if (this.addedPalettes.contains(path)) {
                    visible = true;
                } else {
                    this.paletteTree.clearSelection();
                }
            }
        }
        this.removeButton.setEnabled(this.paletteTree.getSelectionCount() > 0 && visible);
        this.editButton.setEnabled(this.paletteTree.getSelectionCount() == 1 && visible);
    }

    private void expandAll(JTree tree) {
        for (int row = 0; row < tree.getRowCount(); ++row) {
            tree.expandRow(row);
        }
    }

    private void doneButton_actionPerformed(ActionEvent e) {
        this.hide();
    }

    private void loadButton_actionPerformed(ActionEvent e) {
        if (defaultDirectory == null) {
            defaultDirectory = Platform.getDefaultDir();
        }
        CFileChooser chooser = new CFileChooser(defaultDirectory);
        chooser.setDialogTitle(i18n.getString((PropertiesEnum)StringsProperties.PALETTEEDITDIALOG_BROWSETITLE));
        chooser.resetChoosableFileFilters();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.addChoosableFileFilter(new PaletteFileFilter());
        chooser.setMultiSelectionEnabled(true);
        if (chooser.showOpenDialog((Component)((Object)this)) == 0) {
            File[] files = chooser.getSelectedFiles();
            if (files.length == 0) {
                files = new File[]{chooser.getSelectedFile()};
            }
            defaultDirectory = files[0];
            int fileCount = this.palettes.getFileArrayList().size();
            boolean fileAdded = false;
            for (int i = 0; i < files.length; ++i) {
                String canonicalPath;
                if (files[i] == null || !files[i].isFile()) continue;
                boolean added = this.palettes.loadPaletteFile(files[i], true);
                fileAdded |= added;
                try {
                    canonicalPath = files[i].getCanonicalPath();
                }
                catch (Exception ex) {
                    canonicalPath = files[i].getPath();
                }
                if (!added || this.addedPalettes.contains(canonicalPath)) continue;
                this.addedPalettes.add(canonicalPath);
            }
            if (fileAdded) {
                this.paletteTree.setModel(this.buildTree(this.palettes, null, true));
                this.expandAll(this.paletteTree);
                this.paletteTree.repaint();
            } else {
                ModalDialog.showMessageDialogAsync((int)-1, (Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEEDITDIALOG_NOFILESADDED), (String)i18n.getString((PropertiesEnum)StringsProperties.PALETTEEDITDIALOG_NOFILESADDEDTITLE), (int)1);
            }
        }
    }

    private void editButton_actionPerformed(ActionEvent e) {
        DefaultMutableTreeNode node;
        TreePath selectedPath = this.paletteTree.getSelectionPath();
        Object object = selectedPath.getLastPathComponent();
        if (object instanceof DefaultMutableTreeNode && ((node = (DefaultMutableTreeNode)object).getUserObject() instanceof String || node.getUserObject() instanceof PalettesFileListEntry)) {
            String path = "**";
            Object info = node.getUserObject();
            if (info instanceof String) {
                path = (String)info;
            } else if (info instanceof PalettesFileListEntry) {
                path = ((PalettesFileListEntry)info).getPath();
            }
            if (this.addedPalettes.contains(path)) {
                PaletteBuilderDialog builder = new PaletteBuilderDialog(this.frame, i18n.getString((PropertiesEnum)StringsProperties.PALETTEEDITDIALOG_CREATETITLE), true, path, this.addedPalettesKey);
                builder.show();
                String savedPath = builder.getSavedFilePath();
                if (savedPath != null) {
                    this.palettes.removeFile(path);
                    LinkedList<PalettesFileListEntry> list = new LinkedList<PalettesFileListEntry>();
                    list.add(new PalettesFileListEntry(savedPath, savedPath));
                    Palettes newPalette = new Palettes("com.elluminate.util.imageLoading.palette", list, true, (Component)((Object)this), this.addedPalettesKey, null);
                    this.palettes.mergePalette((Component)((Object)this), newPalette);
                    this.paletteTree.setModel(this.buildTree(this.palettes, null, false));
                    this.expandAll(this.paletteTree);
                    this.addedPalettes.add(savedPath);
                    this.paletteTree.repaint();
                }
                builder.dispose();
                builder = null;
            } else {
                ModalDialog.showMessageDialogAsync((int)-1, (Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEEDITDIALOG_CANNOTEDIT, new Object[]{path}), (String)i18n.getString((PropertiesEnum)StringsProperties.PALETTEEDITDIALOG_CANNOTEDITTITLE), (int)1);
            }
        }
    }

    private void removeButton_actionPerformed(ActionEvent e) {
        boolean removed = false;
        TreePath[] treePaths = new TreePath[this.paletteTree.getSelectionCount()];
        if (treePaths.length == 1) {
            treePaths[0] = this.paletteTree.getSelectionPath();
        } else {
            treePaths = this.paletteTree.getSelectionPaths();
        }
        for (int pathIndex = 0; pathIndex < treePaths.length; ++pathIndex) {
            DefaultMutableTreeNode node;
            Object object = treePaths[pathIndex].getLastPathComponent();
            if (!(object instanceof DefaultMutableTreeNode) || !((node = (DefaultMutableTreeNode)object).getUserObject() instanceof String) && !(node.getUserObject() instanceof PalettesFileListEntry)) continue;
            Object userObject = node.getUserObject();
            String path = "";
            if (userObject instanceof String) {
                path = (String)node.getUserObject();
            } else if (userObject instanceof PalettesFileListEntry) {
                path = ((PalettesFileListEntry)userObject).getPath();
            }
            if (this.addedPalettes.contains(path)) {
                if (ModalDialog.showConfirmDialog((Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEEDITDIALOG_CONFIRM, new Object[]{path}), (String)i18n.getString((PropertiesEnum)StringsProperties.PALETTEEDITDIALOG_CONFIRMTITLE), (int)2) != 0) continue;
                this.palettes.removeFile(path);
                this.addedPalettes.remove(path);
                removed = true;
                continue;
            }
            ModalDialog.showMessageDialog((Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.PALETTEEDITDIALOG_CANNOTEDIT, new Object[]{path}), (String)i18n.getString((PropertiesEnum)StringsProperties.PALETTEEDITDIALOG_CANNOTEDITTITLE), (int)1);
        }
        if (removed) {
            this.paletteTree.setModel(this.buildTree(this.palettes, null, false));
            this.expandAll(this.paletteTree);
            this.paletteTree.repaint();
        }
        System.gc();
    }

    private void createButton_actionPerformed(ActionEvent e) {
        PaletteBuilderDialog builder = new PaletteBuilderDialog(this.frame, i18n.getString((PropertiesEnum)StringsProperties.PALETTEEDITDIALOG_CREATETITLE), true);
        builder.show();
        String savedPath = builder.getSavedFilePath();
        if (savedPath != null) {
            LinkedList<PalettesFileListEntry> list = new LinkedList<PalettesFileListEntry>();
            list.add(new PalettesFileListEntry(savedPath, savedPath));
            Palettes newPalette = new Palettes("com.elluminate.util.imageLoading.palette", list, true, (Component)((Object)this), "", null);
            this.palettes.mergePalette((Component)((Object)this), newPalette);
            this.paletteTree.setModel(this.buildTree(this.palettes, null, true));
            if (!this.addedPalettes.contains(savedPath)) {
                this.addedPalettes.add(savedPath);
            }
            this.expandAll(this.paletteTree);
            this.paletteTree.repaint();
        }
        builder.dispose();
        builder = null;
    }

    private DefaultTreeModel buildTree(Palettes palettes, DefaultTreeModel oldModel, boolean merge) {
        PaletteTreeNode paletteTreeNode;
        TreeMap fileMapEntry;
        PaletteEntry paletteEntry;
        DefaultTreeModel model = oldModel;
        DefaultMutableTreeNode root = null;
        TreeMap<String, TreeMap> fileMap = new TreeMap<String, TreeMap>((Comparator<String>)new StringComparator());
        HashMap<String, String> urlMapping = new HashMap<String, String>();
        Iterator paletteEntryIterator = palettes.paletteEntryIterator();
        while (paletteEntryIterator.hasNext()) {
            paletteEntry = (PaletteEntry)paletteEntryIterator.next();
            Iterator imageDataIterator = paletteEntry.imageDataIterator();
            while (imageDataIterator.hasNext()) {
                ImageData imageData = (ImageData)imageDataIterator.next();
                if (!urlMapping.containsKey(imageData.getSourceFile())) {
                    urlMapping.put(imageData.getSourceFile(), imageData.getURL());
                }
                if ((fileMapEntry = (TreeMap)fileMap.get(imageData.getSourceFile())) == null) {
                    fileMapEntry = new TreeMap(new StringComparator());
                    fileMap.put(imageData.getSourceFile(), fileMapEntry);
                }
                if ((paletteTreeNode = (PaletteTreeNode)fileMapEntry.get(paletteEntry.getPackageName())) != null) continue;
                paletteTreeNode = new PaletteTreeNode(paletteEntry);
                fileMapEntry.put(paletteEntry.getPackageName(), paletteTreeNode);
            }
        }
        if (model != null) {
            root = (DefaultMutableTreeNode)model.getRoot();
        }
        if (root == null) {
            root = new DefaultMutableTreeNode();
            model = new DefaultTreeModel(root);
        }
        for (Map.Entry fileEntry : fileMap.entrySet()) {
            Object userObject;
            String nodePathName;
            int index;
            String pathName = (String)fileEntry.getKey();
            String url = (String)urlMapping.get(pathName);
            PalettesFileListEntry entry = new PalettesFileListEntry(pathName, url);
            DefaultMutableTreeNode node = null;
            int compare = -1;
            int limit = root.getChildCount();
            for (index = 0; index < limit && (compare = pathName.compareTo(nodePathName = (userObject = (node = (DefaultMutableTreeNode)root.getChildAt(index)).getUserObject()) instanceof String ? (String)userObject : (userObject instanceof PalettesFileListEntry ? ((PalettesFileListEntry)userObject).getPath() : ""))) > 0; ++index) {
            }
            if (!merge || compare != 0) {
                node = new DefaultMutableTreeNode(entry);
                model.insertNodeInto(node, root, index);
            }
            fileMapEntry = (TreeMap)fileEntry.getValue();
            for (Map.Entry palette : fileMapEntry.entrySet()) {
                String oldPackageName;
                paletteEntry = ((PaletteTreeNode)palette.getValue()).getPaletteEntry();
                String packageName = paletteEntry.getPackageName();
                compare = -1;
                paletteTreeNode = null;
                int paletteLimit = node.getChildCount();
                for (index = 0; index < paletteLimit && (compare = packageName.compareTo(oldPackageName = (paletteTreeNode = (PaletteTreeNode)node.getChildAt(index)).getPaletteEntry().getPackageName())) > 0; ++index) {
                }
                if (merge && compare == 0) continue;
                paletteTreeNode = new PaletteTreeNode(paletteEntry);
                model.insertNodeInto(paletteTreeNode, node, index);
            }
        }
        return model;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("PaletteEditDialog: addedPalettes: ");
        Iterator iter = this.addedPalettes.iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            buf.append(path);
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("\n  " + this.palettes);
        return buf.toString();
    }

    public class PaletteRenderer
    extends DefaultTreeCellRenderer
    implements TreeCellEditor {
        protected JCheckBox checkboxRenderer = new JCheckBox();
        protected JLabel fileRenderer = new JLabel();
        private JTree tree = null;
        private LinkedList listeners = new LinkedList();
        private PaletteEntry editEntry = null;
        private PaletteEntry renderEntry = null;
        private Font systemFont = null;
        private Font userFont = null;

        public PaletteRenderer(JTree tree) {
            this.tree = tree;
            this.checkboxRenderer.setOpaque(true);
            this.fileRenderer.setOpaque(true);
            this.checkboxRenderer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PaletteRenderer.this.editEntry != null) {
                        PaletteRenderer.this.editEntry.setVisible(PaletteRenderer.this.checkboxRenderer.isSelected());
                    }
                }
            });
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.fileRenderer.setText("Uknown");
            if (this.userFont == null) {
                this.userFont = UIManager.getFont("Tree.font");
                this.systemFont = FontUtils.setFontStyle((Font)this.userFont, (int)1);
            }
            JComponent component = this.fileRenderer;
            if (value instanceof PaletteTreeNode) {
                PaletteTreeNode paletteTreeNode = (PaletteTreeNode)value;
                this.renderEntry = paletteTreeNode.getPaletteEntry();
                this.checkboxRenderer.setSelected(this.renderEntry.isVisible());
                this.checkboxRenderer.setText(this.renderEntry.getLocalizedPaletteTitle());
                component = this.checkboxRenderer;
                ((Component)component).setFont(this.userFont);
            } else if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                String path = null;
                String url = null;
                String name = null;
                if (node.getUserObject() instanceof String) {
                    url = path = (String)node.getUserObject();
                } else if (node.getUserObject() instanceof PalettesFileListEntry) {
                    PalettesFileListEntry entry = (PalettesFileListEntry)node.getUserObject();
                    path = entry.getPath();
                    url = entry.getURL();
                    name = entry.getName();
                }
                if (path != null) {
                    if (name != null) {
                        this.fileRenderer.setText(name);
                    } else {
                        this.fileRenderer.setText(url);
                    }
                    component = this.fileRenderer;
                    if (!PaletteOrganizeDialog.this.addedPalettes.contains(path)) {
                        this.fileRenderer.setFont(this.systemFont);
                    } else {
                        this.fileRenderer.setFont(this.userFont);
                    }
                }
            }
            ((Component)component).setEnabled(tree.isEnabled());
            if (selected) {
                ((Component)component).setBackground(UIManager.getColor("Tree.selectionBackground"));
                ((Component)component).setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                ((Component)component).setBackground(UIManager.getColor("Tree.textBackground"));
                ((Component)component).setForeground(UIManager.getColor("Tree.textForeground"));
            }
            return component;
        }

        private String listToString(ArrayList list) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                buf.append("Entry: " + i + "\"" + list.get(i) + "\",");
            }
            return buf.toString();
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            Component c = this.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
            this.editEntry = this.renderEntry;
            return c;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            MouseEvent mouseEvent;
            TreePath path;
            if (anEvent instanceof MouseEvent && (path = this.tree.getPathForLocation((mouseEvent = (MouseEvent)anEvent).getX(), mouseEvent.getY())) != null) {
                Object node = path.getLastPathComponent();
                return node instanceof PaletteTreeNode;
            }
            return false;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return !this.isCellEditable(anEvent);
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.listeners.remove(l);
        }
    }

    public class PaletteTreeNode
    extends DefaultMutableTreeNode {
        private PaletteEntry paletteEntry;
        private boolean selected = false;

        public PaletteTreeNode(PaletteEntry paletteEntry) {
            this.paletteEntry = paletteEntry;
        }

        public PaletteEntry getPaletteEntry() {
            return this.paletteEntry;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        @Override
        public String toString() {
            return this.paletteEntry.getPackageName();
        }
    }
}

