/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.imageloading;

import com.elluminate.groupware.whiteboard.module.imageloading.ImageData;
import com.elluminate.groupware.whiteboard.module.imageloading.ImageSelectionButton;
import com.elluminate.groupware.whiteboard.module.imageloading.ImageTransferHandler;
import com.elluminate.groupware.whiteboard.module.imageloading.PaletteEntry;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;

public class ImageTable
extends JPanel {
    static final int WIDTH;
    static final int HEIGHT;
    private static final int HGAP = 1;
    private static final int VGAP = 1;
    private String paletteTitle = null;

    private ImageTable(String paletteTitle) {
        this.paletteTitle = paletteTitle;
        FlowLayout layout = new FlowLayout(0);
        layout.setHgap(1);
        layout.setVgap(1);
        this.setLayout(layout);
    }

    public static ImageTable draggableTableFromResource(PaletteEntry paletteEntry, MouseInputListener inputListener, ButtonGroup group) {
        return ImageTable.tableFromResource(paletteEntry, null, inputListener, group);
    }

    public static ImageTable tableFromResource(PaletteEntry paletteEntry, MouseListener listener, ButtonGroup group) {
        return ImageTable.tableFromResource(paletteEntry, listener, null, group);
    }

    private static ImageTable tableFromResource(PaletteEntry paletteEntry, MouseListener listener, MouseInputListener inputListener, ButtonGroup group) {
        ImageTable holder = new ImageTable(paletteEntry.getLocalizedPaletteTitle());
        Iterator iter = paletteEntry.imageDataIterator();
        while (iter.hasNext()) {
            ImageData data = (ImageData)iter.next();
            data.setPaletteType(paletteEntry.getLocalizedType());
            ImageSelectionButton button = new ImageSelectionButton(data, WIDTH, HEIGHT, data.getPathname());
            holder.add(button);
            group.add(button);
            if (inputListener != null) {
                button.addMouseListener(inputListener);
                button.addMouseMotionListener(inputListener);
                button.setTransferHandler(new ImageTransferHandler());
                continue;
            }
            if (listener == null) continue;
            button.addMouseListener(listener);
        }
        return holder;
    }

    public int getButtonWidth() {
        return WIDTH;
    }

    public int getButtonHeight() {
        return HEIGHT;
    }

    public String getPaletteTitle() {
        return this.paletteTitle;
    }

    static {
        Insets ins = new ImageSelectionButton().getCorrectedMargin();
        int marginW = ins.left + ins.right + 6;
        int marginH = ins.top + ins.bottom + 6;
        WIDTH = Math.max(60, 50 + marginW);
        HEIGHT = Math.max(60, 50 + marginH);
    }
}

