/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module.imageloading;

import com.elluminate.groupware.whiteboard.module.imageloading.ImageCapturePanel;
import com.elluminate.groupware.whiteboard.module.imageloading.ImageData;
import com.elluminate.groupware.whiteboard.module.imageloading.ImageFileFilter;
import com.elluminate.groupware.whiteboard.module.imageloading.ImagePreview;
import com.elluminate.groupware.whiteboard.module.imageloading.ImageSelectionButton;
import com.elluminate.groupware.whiteboard.module.imageloading.ImageTable;
import com.elluminate.groupware.whiteboard.module.imageloading.PaletteEntry;
import com.elluminate.groupware.whiteboard.module.imageloading.Palettes;
import com.elluminate.groupware.whiteboard.module.imageloading.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.swing.CDialog;
import com.elluminate.gui.swing.CFileChooser;
import com.elluminate.platform.Platform;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.UtilDebug;
import com.elluminate.util.image.ImageMimeUtilities;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;

public class ImageInputDialog
extends CDialog {
    public static final long MAX_IMAGE_FILE_SIZE = 0x200000L;
    private static String selectedTabName = "";
    private static String selectedPaletteTabName = "";
    private I18n i18n = I18n.create((Object)((Object)this));
    private JPanel panel1 = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JFileChooser jFileChooser;
    private ImagePreview previewAccessory = null;
    private ImageCapturePanel imageCapture;
    private JTabbedPane imageInputTabs = new JTabbedPane();
    private int modalResult = 1;
    private byte[] imageFileBuffer;
    private String imageFileSuffix = null;
    private String imageFileName = null;
    private Frame parentFrame;
    private File imageFile = null;
    private File selectedFile = null;
    private int maxWidth;
    private int maxHeight;
    private int previewWidth = 300;
    private int previewHeight = 200;
    private JTabbedPane imagePalette = new JTabbedPane();
    private JPanel jPanel1 = new JPanel();
    private JPanel paletteControls = new JPanel();
    private JButton cancelPalette = new JButton();
    private JButton blankImage = new JButton();
    private JButton okButton = new JButton();
    private BorderLayout borderLayout2 = new BorderLayout();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private Palettes palettes = null;
    private ImageData selectedPaletteItem = null;
    private ButtonGroup paletteButtonGroup = new ButtonGroup();
    private MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            ImageInputDialog.this.selectionListener(e);
        }
    };

    public ImageInputDialog(Frame frame, String title, File imageFile, Palettes palettes, Runnable query, int maxWidth, int maxHeight, int previewWidth, int previewHeight) {
        super(frame, title, true);
        this.imageFile = imageFile;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.previewWidth = previewWidth;
        this.previewHeight = previewHeight;
        try {
            if (query != null) {
                query.run();
            }
            this.palettes = palettes;
        }
        catch (Throwable t) {
            if (UtilDebug.PALETTE_LOAD.show()) {
                LogSupport.message((Object)((Object)this), (String)"<init>", (String)("Palette query exception: " + Debug.getStackTrace((Throwable)t)));
            }
            this.palettes = null;
        }
        if (UtilDebug.PALETTE_LOAD.show()) {
            LogSupport.message((Object)((Object)this), (String)"<init>", (String)("Got palettes: " + (palettes != null)));
        }
        this.parentFrame = frame;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)((Object)this), (String)"ImageInputDialog", (Throwable)ex, (boolean)true);
        }
    }

    public ImageInputDialog() {
        this(null, "", null, null, null, 200, 150, 200, 150);
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.imagePalette.setBackground(SystemColor.control);
        this.computeSize();
        this.cancelPalette.setText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGEINPUTDIALOG_CANCELPALETTE));
        this.cancelPalette.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGEINPUTDIALOG_CANCELPALETTETIP));
        this.cancelPalette.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageInputDialog.this.cancelPalette_actionPerformed(e);
            }
        });
        this.blankImage.setText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGEINPUTDIALOG_BLANKIMAGE));
        this.blankImage.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGEINPUTDIALOG_BLANKIMAGETIP));
        this.blankImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageInputDialog.this.blankImage_actionPerformed(e);
            }
        });
        this.okButton.setText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGEINPUTDIALOG_OKPALETTE));
        this.okButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGEINPUTDIALOG_OKPALETTETIP));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageInputDialog.this.okButton_actionPerformed(e);
            }
        });
        this.okButton.setEnabled(false);
        this.jPanel1.setLayout(this.borderLayout2);
        this.paletteControls.setLayout(this.gridBagLayout1);
        this.buildImageDialog(this.imageFile);
        this.jFileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageInputDialog.this.jFileChooser_actionPerformed(e);
            }
        });
        this.paletteControls.add((Component)new JPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.paletteControls.add((Component)this.blankImage, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.paletteControls.add((Component)this.okButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.paletteControls.add((Component)this.cancelPalette, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.createPalettes(this.palettes);
        this.jPanel1.add((Component)this.paletteControls, "South");
        this.jPanel1.add((Component)this.imagePalette, "Center");
        this.imagePalette.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.imageInputTabs.add((Component)this.jFileChooser, this.i18n.getString((PropertiesEnum)StringsProperties.IMAGEINPUTDIALOG_IMAGE_FILE_SELECTION));
        this.imageInputTabs.add((Component)this.jPanel1, "Testing: Clip Art");
        if (ImageCapturePanel.canInstantiate()) {
            this.imageCapture = new ImageCapturePanel((Dialog)((Object)this), this.maxWidth, this.maxHeight);
            this.imageCapture.setCancelListener(this);
            this.imageInputTabs.add((Component)this.imageCapture, this.i18n.getString((PropertiesEnum)StringsProperties.IMAGEINPUTDIALOG_SCREEN_IMAGE_CAPTURE));
        }
        this.panel1.add((Component)this.imageInputTabs, "Center");
        this.imageInputTabs.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.getContentPane().add(this.panel1);
    }

    private void computeSize() {
        int ht = Math.max(400, this.previewHeight + 250);
        int wd = Math.max(600, this.previewWidth + 400);
        this.setSize(wd, ht);
    }

    private void buildImageDialog(File imageFile) {
        this.jFileChooser = new CFileChooser(imageFile);
        if (imageFile != null && imageFile.isFile()) {
            this.setSelectedFile(imageFile);
        }
        this.jFileChooser.setDialogTitle(this.i18n.getString((PropertiesEnum)StringsProperties.IMAGEINPUTDIALOG_CHOOSERDIALOGTITLE));
        this.jFileChooser.resetChoosableFileFilters();
        this.jFileChooser.removeChoosableFileFilter(this.jFileChooser.getAcceptAllFileFilter());
        this.jFileChooser.setFileFilter(new ImageFileFilter());
    }

    public void cancelDialog() {
        this.modalResult = 1;
        this.hide();
        this.dispose();
    }

    public void dispose() {
        if (this.previewAccessory != null) {
            this.previewAccessory.dispose();
            this.previewAccessory = null;
        }
        Enumeration<AbstractButton> buttonEnum = this.paletteButtonGroup.getElements();
        while (buttonEnum.hasMoreElements()) {
            AbstractButton obj = buttonEnum.nextElement();
            if (!(obj instanceof ImageSelectionButton)) continue;
            ((ImageSelectionButton)obj).flush();
        }
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int showModal() {
        try {
            if (this.previewAccessory == null) {
                this.previewAccessory = new ImagePreview(this.jFileChooser, this.previewWidth, this.previewHeight);
                this.jFileChooser.setAccessory(this.previewAccessory);
            }
            this.setModal(true);
            int tabIndex = this.imageInputTabs.indexOfTab(selectedTabName);
            if (tabIndex < 0 || tabIndex >= this.imageInputTabs.getTabCount()) {
                tabIndex = 0;
            }
            this.imageInputTabs.setSelectedIndex(tabIndex);
            if (this.imagePalette.getTabCount() > 0) {
                tabIndex = this.imagePalette.indexOfTab(selectedPaletteTabName);
                if (tabIndex < 0 || tabIndex >= this.imagePalette.getTabCount()) {
                    tabIndex = 0;
                }
                this.imagePalette.setSelectedIndex(tabIndex);
            } else {
                this.okButton.setVisible(false);
            }
            if (!this.okButton.isVisible() && !this.blankImage.isVisible()) {
                this.imageInputTabs.removeTabAt(1);
            }
            this.modalResult = 1;
            if (UtilDebug.PALETTE_LOAD.show()) {
                LogSupport.message((Object)((Object)this), (String)"showModal", (String)"Showing...");
            }
            this.setLocationRelativeTo(this.parentFrame);
            this.show();
            if (UtilDebug.PALETTE_LOAD.show()) {
                LogSupport.message((Object)((Object)this), (String)"showModal", (String)"  ...end of show.");
            }
            if (this.imageInputTabs.getSelectedComponent() == this.imageCapture) {
                if (this.imageCapture.isCancelled()) {
                    int n = 1;
                    return n;
                }
                this.imageFileBuffer = this.imageCapture.getImageBytes();
                this.imageFileName = this.imageCapture.getCaptureName();
                this.imageFileSuffix = this.imageCapture.getCaptureSuffix();
                this.modalResult = 0;
                this.selectedFile = null;
            } else if (this.imageInputTabs.getSelectedComponent() == this.imagePalette) {
                this.modalResult = 0;
                this.selectedFile = null;
            } else if (this.imageInputTabs.getSelectedComponent() == this.jFileChooser) {
                this.selectedFile = this.jFileChooser.getSelectedFile();
            }
        }
        catch (Exception e) {
            LogSupport.exception((Object)((Object)this), (String)"showModal", (Throwable)e, (boolean)true);
        }
        finally {
            selectedTabName = this.imageInputTabs.getTitleAt(this.imageInputTabs.getSelectedIndex());
            if (this.imagePalette.getTabCount() > 0) {
                selectedPaletteTabName = this.imagePalette.getTitleAt(this.imagePalette.getSelectedIndex());
            }
        }
        return this.modalResult;
    }

    public void setSelectedFile(File imageFile) {
        try {
            if (imageFile != null) {
                this.jFileChooser.setCurrentDirectory(imageFile);
                if (imageFile.isFile()) {
                    this.jFileChooser.setSelectedFile(imageFile);
                    this.jFileChooser.ensureFileIsVisible(imageFile);
                }
            }
        }
        catch (Exception e) {
            LogSupport.exception((Object)((Object)this), (String)"setSelectedFile", (Throwable)e, (boolean)true, (String)("Setting_selected_file" + imageFile));
        }
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public byte[] getImageBytes() {
        return this.imageFileBuffer;
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public String getImageFileSuffix() {
        return this.imageFileSuffix;
    }

    public boolean isBlankButtonEnabled() {
        return this.blankImage.isVisible();
    }

    public void enableBlankButton(boolean b) {
        this.blankImage.setVisible(b);
    }

    private void jFileChooser_actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("CancelSelection")) {
            this.modalResult = 1;
        } else {
            try {
                String mimeType;
                FileInputStream in;
                int reply = 0;
                if (this.jFileChooser.getSelectedFile() == null) {
                    ModalDialog.showMessageDialogAsync((int)-1, (Component)((Object)this), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.IMAGEINPUTDIALOG_NOFILE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.IMAGEINPUTDIALOG_NOFILETITLE), (int)0);
                    return;
                }
                long fileLength = this.jFileChooser.getSelectedFile().length();
                if (fileLength > 0x200000L) {
                    reply = ModalDialog.showConfirmDialog((Component)((Object)this), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.IMAGEINPUTDIALOG_QUERYSIZE, new Object[]{new Long(fileLength)}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.IMAGEINPUTDIALOG_QUERYSIZETITLE), (int)0);
                }
                if (reply == 0) {
                    in = new FileInputStream(this.jFileChooser.getSelectedFile());
                    int length = in.available();
                    this.imageFileBuffer = new byte[length];
                    in.read(this.imageFileBuffer);
                    in.close();
                    this.imageFileName = this.jFileChooser.getSelectedFile().getName();
                    mimeType = Platform.getMimeType((File)this.jFileChooser.getSelectedFile());
                    if (!ImageMimeUtilities.isValidImageMimeType((String)mimeType)) {
                        this.imageFileBuffer = null;
                        this.imageFileSuffix = "";
                        ModalDialog.showMessageDialogAsync((int)-1, (Component)((Object)this), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.IMAGEINPUTDIALOG_UNABLETOLOADIMAGE, new Object[]{this.imageFileName}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.IMAGEINPUTDIALOG_UNABLETOLOADTITLE), (int)0);
                        return;
                    }
                } else {
                    this.modalResult = 1;
                    return;
                }
                this.imageFileSuffix = Platform.getSuffix((String)mimeType);
                in = null;
            }
            catch (FileNotFoundException fe) {
                return;
            }
            catch (Throwable t) {
                LogSupport.exception((Object)((Object)this), (String)"JFileChooser_actionPerformed", (Throwable)t, (boolean)true);
                return;
            }
            this.modalResult = 0;
        }
        this.dispose();
    }

    private void cancelPalette_actionPerformed(ActionEvent e) {
        this.cancelDialog();
    }

    private void blankImage_actionPerformed(ActionEvent e) {
        this.imageFileBuffer = null;
        this.imageFileName = "blankImage.Text";
        this.imageFileSuffix = ".jpg";
        this.modalResult = 0;
        this.dispose();
    }

    private void okButton_actionPerformed(ActionEvent e) {
        this.returnSelectedPaletteImage();
    }

    private void returnSelectedPaletteImage() {
        this.imageFile = null;
        this.imageFileBuffer = this.selectedPaletteItem.getImageBytes();
        this.imageFileName = this.selectedPaletteItem.getPathname();
        this.imageFileSuffix = FileSysUtils.getExtensionString((String)this.imageFileName);
        this.modalResult = 0;
        this.dispose();
    }

    public void createPalettes(Palettes palettes) {
        if (palettes == null) {
            return;
        }
        Iterator iteratePalettes = palettes.paletteEntryIterator();
        while (iteratePalettes.hasNext()) {
            PaletteEntry paletteEntry = (PaletteEntry)iteratePalettes.next();
            if (!paletteEntry.isVisible()) continue;
            this.addImagePalettePane(paletteEntry);
        }
    }

    public void addImagePalettePane(PaletteEntry paletteEntry) {
        ImageTable imageTable = ImageTable.tableFromResource(paletteEntry, this.mouseListener, this.paletteButtonGroup);
        if (imageTable == null) {
            return;
        }
        String resourceTitle = paletteEntry.getLocalizedPaletteTitle();
        JScrollPane scrollPane = new JScrollPane(imageTable);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(22);
        JScrollBar scrollBar = scrollPane.getVerticalScrollBar();
        scrollBar.setUnitIncrement(imageTable.getButtonHeight());
        int block = scrollBar.getBlockIncrement();
        if ((block /= imageTable.getButtonHeight()) > 0) {
            scrollBar.setBlockIncrement(block * imageTable.getButtonHeight());
        }
        this.imagePalette.add(resourceTitle, scrollPane);
    }

    public void selectionListener(MouseEvent e) {
        if (e.getSource() instanceof ImageSelectionButton) {
            ImageSelectionButton imageSelectionButton = (ImageSelectionButton)e.getSource();
            this.selectedPaletteItem = imageSelectionButton.getData();
            if (e.getClickCount() > 1) {
                this.returnSelectedPaletteImage();
            } else {
                this.okButton.setEnabled(true);
            }
        }
    }
}

