/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

public class WhiteboardFileUtilities {
    public static String getNextFilenameFromPrevious(String previousFilename) {
        if (previousFilename == null || previousFilename.equals("")) {
            return null;
        }
        String extension = WhiteboardFileUtilities.getFilenameExtension(previousFilename);
        String base = WhiteboardFileUtilities.getFilenameBase(previousFilename);
        char searchDelim = '.';
        char writeDelim = '.';
        int increment = 0;
        if (base.matches(".*\\.+[0-9]+")) {
            searchDelim = '.';
            writeDelim = '.';
        } else if (base.matches(".*_+[0-9]+")) {
            searchDelim = '_';
            writeDelim = '_';
        } else {
            searchDelim = '\uffff';
            writeDelim = '_';
        }
        increment = WhiteboardFileUtilities.extractIncrement(base, searchDelim);
        return WhiteboardFileUtilities.removeIncrement(base, searchDelim) + writeDelim + ++increment + extension;
    }

    protected static String removeIncrement(String filename, char delim) {
        if (delim == '\uffffffff') {
            return filename;
        }
        int index = filename.lastIndexOf(delim);
        if (index > 0) {
            return filename.substring(0, index);
        }
        return filename;
    }

    protected static int extractIncrement(String filename, char delim) {
        if (delim == '\uffffffff') {
            return -1;
        }
        String base = WhiteboardFileUtilities.removeIncrement(filename, delim);
        String substr = filename;
        if ((substr = substr.substring(base.length())).length() > 1 && substr.charAt(0) == delim) {
            substr = substr.substring(1);
        }
        int increment = -1;
        try {
            increment = Integer.parseInt(substr);
        }
        catch (Exception e) {
            // empty catch block
        }
        return increment;
    }

    public static String getFilenameBase(String filename) {
        if (filename == null || filename.equals("")) {
            return null;
        }
        String extension = WhiteboardFileUtilities.getFilenameExtension(filename);
        if (extension == null) {
            return filename;
        }
        return filename.substring(0, filename.indexOf(extension));
    }

    public static String getFilenameExtension(String filename) {
        String extension;
        if (filename == null || filename.equals("")) {
            return null;
        }
        int extIndex = filename.lastIndexOf(46);
        if (extIndex > 0 && (extension = filename.substring(extIndex)).matches("\\..*[^0-9]+.*")) {
            return extension;
        }
        return null;
    }
}

