/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.groupware.whiteboard.WhiteboardChairListener;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.conference.ClientIdentification;
import com.elluminate.groupware.whiteboard.conference.ViewedScreens;
import com.elluminate.groupware.whiteboard.conference.ViewedScreensListener;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.listeners.ClientIDListener;
import com.elluminate.groupware.whiteboard.module.StringsProperties;
import com.elluminate.gui.swing.CDialog;
import com.elluminate.gui.swing.CPopupMenu;
import com.elluminate.gui.swing.CTable;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.JinxServerProps;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.ShortList;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class ScreenViewDialog
extends CDialog
implements ViewedScreensListener,
ClientIDListener,
WhiteboardChairListener {
    private static final boolean MAC_SNOW_LEOPARD = Platform.checkOSVersion((int)202, (String)"10.6+");
    private static final I18n i18n = I18n.create((Object)new Object(){});
    private static final int PARTICIPANT_COLUMN = 0;
    private static final int SCREEN_NAME_COLUMN = 1;
    private JTable screenTable;
    private Model model;
    private JScrollPane tableScroller;
    private JButton cancelButton;
    private WhiteboardContext context;
    private ViewedScreens viewedScreens;
    private JPopupMenu popup = new CPopupMenu();
    private int popupRow = 0;
    private String partTip;
    private String screenTip;
    private String noTip;

    public ScreenViewDialog(Frame frame, ClientList clients, WhiteboardContext thisContext) {
        super(frame, i18n.getString((PropertiesEnum)StringsProperties.SCREENVIEWDIALOG_TITLE, new Object[]{JinxServerProps.get((PropertyAccessAPI)clients, (String)"Label.Participants")}), false);
        this.getRootPane().putClientProperty("Window.style", "small");
        this.partTip = i18n.getString((PropertiesEnum)StringsProperties.SCREENVIEWDIALOG_PARTICIPANTTIP, new Object[]{JinxServerProps.get((PropertyAccessAPI)clients, (String)"Label.participant")});
        this.screenTip = i18n.getString((PropertiesEnum)StringsProperties.SCREENVIEWDIALOG_SCREENTIP);
        this.noTip = i18n.getString((PropertiesEnum)StringsProperties.SCREENVIEWDIALOG_NOSCREENTIP);
        this.context = thisContext;
        Object[] columnNames = new Object[]{JinxServerProps.get((PropertyAccessAPI)clients, (String)"Label.Participants"), i18n.getString((PropertiesEnum)StringsProperties.SCREENVIEWDIALOG_SCREENNAME)};
        this.model = new Model(columnNames);
        this.screenTable = new CTable((TableModel)this.model);
        this.screenTable.setRowSelectionAllowed(true);
        this.tableScroller = new JScrollPane(this.screenTable, 20, 30);
        this.getContentPane().add((Component)this.tableScroller, "Center");
        this.cancelButton = new JButton(i18n.getString((PropertiesEnum)StringsProperties.SCREENVIEWDIALOG_CANCEL));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.cancelButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setSize(250, 150);
        Rectangle parent = this.context.getDialogParentFrame().getBounds();
        Point loc = new Point(parent.x + (parent.width - this.getBounds().width) / 2, parent.y + (parent.height - this.getBounds().height) / 2);
        this.setLocation(loc);
        this.viewedScreens = this.context.getDataExporter().getViewedScreens();
        this.viewedScreens.addViewedListener((ViewedScreensListener)this);
        this.context.getIDProcessor().addClientIDListener((ClientIDListener)this);
        this.screenTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ScreenViewDialog.this.managePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ScreenViewDialog.this.managePopup(e);
            }
        });
        this.context.getChairManager().addChairListener((WhiteboardChairListener)this);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScreenViewDialog.this.hide();
            }
        });
        this.cancelButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SCREENVIEWDIALOG_CANCELTIP));
        this.screenTable.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                ScreenViewDialog.this.setTableTip(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                ScreenViewDialog.this.setTableTip(e);
            }
        });
    }

    public void show() {
        if (MAC_SNOW_LEOPARD) {
            Runnable repainter = new Runnable(){

                @Override
                public void run() {
                    ScreenViewDialog.this.screenTable.repaint();
                }
            };
            LightweightTimer t = new LightweightTimer(2, repainter);
            t.scheduleIn(50L);
        }
        super.show();
    }

    private void setTableTip(MouseEvent e) {
        Object obj;
        int row = this.screenTable.rowAtPoint(e.getPoint());
        int column = this.screenTable.columnAtPoint(e.getPoint());
        String tipText = column == 0 ? this.partTip : ((obj = this.screenTable.getValueAt(row, column)) != null && obj instanceof String && ((String)obj).length() > 0 ? this.screenTip : this.noTip);
        this.screenTable.setToolTipText(tipText);
    }

    private void managePopup(MouseEvent e) {
        if (e.isPopupTrigger() && !this.popup.isVisible()) {
            this.popup.removeAll();
            boolean post = false;
            if (this.context.getController().isRightButton(false, e)) {
                this.context.getController().consumeRightButton();
            }
            this.popupRow = this.screenTable.rowAtPoint(e.getPoint());
            List screens = this.model.getScreenListAt(this.popupRow);
            if (screens == null) {
                return;
            }
            for (Long screenUID : screens) {
                try {
                    ScreenModel screen = (ScreenModel)this.context.getObjectManager().getObjectFromMap(screenUID);
                    if (screen == null) continue;
                    GotoItem gotoItem = new GotoItem(i18n.getString((PropertiesEnum)StringsProperties.SCREENVIEWDIALOG_POPUP, new Object[]{screen.getScreenName()}), screenUID);
                    gotoItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            GotoItem gotoItem = (GotoItem)e.getSource();
                            ScreenViewDialog.this.context.getController().gotoUIScreen(gotoItem.getUID(), false);
                        }
                    });
                    this.popup.add(gotoItem);
                    post = true;
                }
                catch (Exception ex) {}
            }
            if (post) {
                this.popup.show(this.screenTable, e.getPoint().x, e.getPoint().y);
                e.consume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParticipants(List<ClientInfo> who) {
        ScreenViewDialog screenViewDialog = this;
        synchronized (screenViewDialog) {
            this.model.clear();
            for (ClientInfo ci : who) {
                this.model.addClient(ci);
            }
        }
        this.model.fireTableDataChanged();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClientID(int type, Short clientId, Short clientAddress) {
        ScreenViewDialog screenViewDialog = this;
        synchronized (screenViewDialog) {
            this.model.removeClient(this.context.getClientList().get(clientAddress.shortValue()));
        }
        this.repaint();
    }

    public void onWhiteboardChairChange(Short clientId, Short jinxAddress, boolean add) {
        if (clientId.equals(ClientIdentification.CLIENT_LOCAL)) {
            this.model.clear();
            this.hide();
        }
    }

    public void onAddViewedScreensChange(Long screenUID, ViewedScreens.ScreenViewerList viewedScreensViewers, Short clientId) {
        this.screenTable.repaint();
    }

    public void onRemoveViewedScreensChange(Long screenUID, ViewedScreens.ScreenViewerList viewedScreensViewers, Short clientId) {
        this.screenTable.repaint();
    }

    public void onViewedChange() {
    }

    class GotoItem
    extends JMenuItem {
        Long uid;

        public GotoItem(String text, Long screenUID) {
            super(text);
            this.uid = screenUID;
        }

        public Long getUID() {
            return this.uid;
        }
    }

    class Model
    extends DefaultTableModel {
        public Model(Object[] columnNames) {
            super(columnNames, 0);
        }

        public void clear() {
            this.dataVector.removeAllElements();
            this.fireTableDataChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addClient(ClientInfo clientInfo) {
            Short clientAddress = ShortList.get((short)clientInfo.getAddress());
            Short clientId = ScreenViewDialog.this.context.getIDProcessor().getClientId(clientAddress);
            Vector vector = this.dataVector;
            synchronized (vector) {
                super.addRow(new Object[]{clientInfo, clientId});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeClient(ClientInfo clientInfo) {
            Vector vector = this.dataVector;
            synchronized (vector) {
                for (int row = this.dataVector.size() - 1; row >= 0; --row) {
                    if (((Vector)this.dataVector.elementAt(row)).firstElement() != clientInfo) continue;
                    super.removeRow(row);
                    return;
                }
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object result;
            Vector rowVector = (Vector)this.dataVector.elementAt(row);
            Object obj = rowVector.elementAt(column);
            switch (column) {
                case 0: {
                    result = ((ClientInfo)obj).getDisplayName();
                    break;
                }
                case 1: {
                    StringBuffer buf = new StringBuffer();
                    Set set = ScreenViewDialog.this.context.getDataExporter().getClientsScreens((Short)obj);
                    if (set != null) {
                        Vector list = new Vector(set);
                        Collections.sort(list);
                        for (Long uid : list) {
                            try {
                                result = ScreenViewDialog.this.context.getObjectManager().getObjectFromMap(uid);
                                if (!(result instanceof ScreenModel)) continue;
                                if (buf.length() > 0) {
                                    buf.append(", ");
                                }
                                buf.append(((ScreenModel)result).getScreenName());
                            }
                            catch (Exception e) {}
                        }
                    }
                    result = buf.toString();
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        public List getScreenListAt(int row) {
            Vector rowVector = (Vector)this.dataVector.elementAt(row);
            Object obj = rowVector.elementAt(1);
            return new ArrayList(ScreenViewDialog.this.context.getDataExporter().getClientsScreens((Short)obj));
        }

        public ClientInfo getClientInfoAt(int row) {
            Vector rowVector = (Vector)this.dataVector.elementAt(row);
            Object obj = rowVector.elementAt(0);
            return (ClientInfo)ScreenViewDialog.this.context.getDataExporter().getClientsScreens((Short)obj);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

