/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.ImageWriterGraphics;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.module.FileUtils;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.tree.TreePath;

public class PrintWhiteboardWriter
implements Printable {
    private File file;
    private Object[] allScreens = null;
    private Image image;
    private int depthLimit;
    private ArrayList screenCapture = new ArrayList();

    public PrintWhiteboardWriter(TreePath[] paths, int depthLimit) {
        this.screenCapture.clear();
        WBNode[] nodes = ActionUtilities.pruneRootChildren((WBNode[])FileUtils.createScreensFromPaths(paths));
        for (int i = 0; i < nodes.length; ++i) {
            this.depthLimit = nodes[i] instanceof ScreenRoot ? Integer.MAX_VALUE : 1;
            this.pushScreenCapture((ScreenModel)nodes[i], 1);
        }
        this.allScreens = this.screenCapture.toArray();
    }

    private void pushScreenCapture(ScreenModel screen, int depth) {
        if (screen.canPrint() && depth <= this.depthLimit) {
            if (!(screen instanceof ScreenRoot)) {
                this.screenCapture.add(screen);
            }
            if (depth < this.depthLimit) {
                Iterator iter = screen.iterateScreens();
                while (iter.hasNext()) {
                    Object object = iter.next();
                    if (!(object instanceof ScreenModel)) continue;
                    this.pushScreenCapture((ScreenModel)object, depth + 1);
                }
            }
        }
    }

    public int getScreenCount() {
        return this.allScreens.length;
    }

    public void print(PrinterJob printerJob, PageFormat pf) {
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        try {
            if (pageIndex < 0 || pageIndex >= this.allScreens.length || !(this.allScreens[pageIndex] instanceof ScreenModel)) {
                return 1;
            }
            ScreenModel screen = (ScreenModel)this.allScreens[pageIndex];
            this.image = ImageWriterGraphics.processToolToImage((String)screen.getScreenName(), (Iterator)screen.iterateTools(), (int)0, (int)0, (int)screen.getScreenSize().width, (int)screen.getScreenSize().height, (boolean)true, null, null);
            double pageWidth = pf.getImageableWidth();
            double pageHeight = pf.getImageableHeight();
            double imageWidth = this.image.getWidth(null);
            double imageHeight = this.image.getHeight(null);
            double imageAspectWtoH = imageWidth / imageHeight;
            int width = (int)pageWidth;
            int height = (int)(pageWidth / imageAspectWtoH);
            if (height > (int)pageHeight) {
                height = (int)pageHeight;
                width = (int)(pageHeight * imageAspectWtoH);
            }
            g.drawImage(this.image, (int)pf.getImageableX(), (int)pf.getImageableY(), width, height, null);
        }
        catch (Exception e) {
            // empty catch block
        }
        return 0;
    }
}

