/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.groupware.whiteboard.dataModel.ImageWriterGraphics;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.module.WhiteboardFileUtilities;
import com.elluminate.util.image.ImageSupport;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;

public class ImageWhiteboardWriter {
    File file;
    private String lastFilename;
    private int RECURSION_LIMIT = 10;
    private int recursionCount = 0;
    int depthLimit;
    private boolean continueOperation = true;

    public ImageWhiteboardWriter(File file) {
        this.file = file;
    }

    public void writeImages(ScreenModel[] screens, int depthLimit, ProgressUpdate progress) throws Exception {
        int i;
        int toolCount = 0;
        for (i = 0; i < screens.length && this.continueOperation; ++i) {
            toolCount += ScreenModel.toolCount((ScreenModel)screens[i]);
        }
        progress.setMaximum(toolCount);
        progress.setValue(0);
        for (i = 0; i < screens.length && this.continueOperation; ++i) {
            if (!(screens[i] instanceof ScreenModel)) continue;
            this.depthLimit = screens[i] instanceof ScreenRoot ? Integer.MAX_VALUE : 1;
            this.pushImageScreen(screens[i].getScreenName(), screens[i], 1, progress);
        }
    }

    private void pushImageScreen(String title, ScreenModel screen, int depth, ProgressUpdate progress) throws Exception {
        if (!screen.canSave() || depth > this.depthLimit || !this.continueOperation) {
            return;
        }
        String newTitle = "";
        if (!(screen instanceof ScreenRoot)) {
            BufferedImage image = ImageWriterGraphics.processToolToImage((String)title, (Iterator)screen.iterateTools(), (int)0, (int)0, (int)screen.getScreenSize().width, (int)screen.getScreenSize().height, (boolean)true, null, (ProgressUpdate)progress);
            this.writeImageToFile(image, title, progress);
            image.flush();
            image = null;
            newTitle = title + " || ";
        }
        if (depth < this.depthLimit) {
            Iterator iter = screen.iterateScreens();
            while (iter.hasNext() && this.continueOperation) {
                ScreenModel child = (ScreenModel)iter.next();
                this.pushImageScreen(newTitle + child.getScreenName(), child, depth + 1, progress);
            }
        }
    }

    private void writeImageToFile(Image image, String title, ProgressUpdate progress) throws Exception {
        File output = null;
        boolean override = false;
        if (this.lastFilename == null) {
            this.lastFilename = this.file.getAbsolutePath();
            output = new File(this.lastFilename);
            override = true;
        } else {
            String newFilename = WhiteboardFileUtilities.getNextFilenameFromPrevious(this.lastFilename);
            output = new File(newFilename);
            this.lastFilename = newFilename;
        }
        if (!override && (output.exists() || output.isDirectory())) {
            ++this.recursionCount;
            if (this.recursionCount >= this.RECURSION_LIMIT) {
                String alteredFilename = WhiteboardFileUtilities.getFilenameBase(this.lastFilename);
                String extension = WhiteboardFileUtilities.getFilenameExtension(this.lastFilename);
                this.lastFilename = alteredFilename + "_0" + extension;
                this.recursionCount = 0;
            }
            this.writeImageToFile(image, title, progress);
            return;
        }
        progress.setFilename(output.getPath());
        FileOutputStream imageOutputStream = new FileOutputStream(output);
        byte[] bytes = ImageSupport.encodeAsPNG((Image)image);
        if (bytes != null && this.continueOperation) {
            imageOutputStream.write(bytes, 0, bytes.length);
        }
        imageOutputStream.close();
    }

    public void endOperation() {
        this.continueOperation = false;
    }
}

