/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.groupware.whiteboard.AbstractWBFileFilter;
import com.elluminate.groupware.whiteboard.module.StringsProperties;
import com.elluminate.groupware.whiteboard.module.imageloading.ImagePreview;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.image.ImageMimeUtilities;
import com.elluminate.util.image.PICTImporter;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class ImageFileFilter
extends AbstractWBFileFilter
implements PropertyChangeListener {
    private static final I18n i18n = I18n.create((Object)new Object(){});
    private String description = null;
    private ImagePreview preview = null;
    private JPanel orderingPanel = null;
    private JPanel previewPanel = new JPanel(new GridBagLayout());
    private TitledBorder border = null;
    private JRadioButton selectedOrder = new JRadioButton();
    private JRadioButton alphaOrder = new JRadioButton();
    private JRadioButton numericOrder = new JRadioButton();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private File[] files = new File[0];
    private HashSet oldFileSet = new HashSet();
    private LinkedList fileList = new LinkedList();

    public ImageFileFilter() {
        super("wbd");
        this.multiMode = true;
        this.description = i18n.getString((PropertiesEnum)StringsProperties.IMAGEFILEFILTER_DESCRIPTION);
        this.border = new TitledBorder(i18n.getString((PropertiesEnum)StringsProperties.IMAGEFILEFILTER_ORDERINGTITLE));
        this.selectedOrder.setText(i18n.getString((PropertiesEnum)StringsProperties.IMAGEFILEFILTER_SELECTEDORDER));
        this.alphaOrder.setText(i18n.getString((PropertiesEnum)StringsProperties.IMAGEFILEFILTER_ALPHAORDER));
        this.numericOrder.setText(i18n.getString((PropertiesEnum)StringsProperties.IMAGEFILEFILTER_NUMERICORDER));
        this.buttonGroup.add(this.selectedOrder);
        this.buttonGroup.add(this.alphaOrder);
        this.buttonGroup.add(this.numericOrder);
        this.orderingPanel = new JPanel(new GridBagLayout());
        this.orderingPanel.setBorder(this.border);
        this.orderingPanel.add((Component)this.selectedOrder, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.orderingPanel.add((Component)this.alphaOrder, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.orderingPanel.add((Component)this.numericOrder, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.buttonGroup.setSelected(this.selectedOrder.getModel(), true);
        this.previewPanel.add((Component)this.orderingPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.orderingPanel.setVisible(false);
    }

    public boolean accept(File f) {
        try {
            if (f == null) {
                return false;
            }
            if (FileSysUtils.isTraversableDirectory((File)f)) {
                return true;
            }
            if (!ImageMimeUtilities.isValidImageMimeFile((File)f)) {
                return false;
            }
            if (PICTImporter.isPICT((File)f)) {
                return PICTImporter.isSupported();
            }
            return true;
        }
        catch (Exception ex) {
            if (!(ex instanceof InterruptedException)) {
                LogSupport.exception((Object)this, (String)"accept", (Throwable)ex, (boolean)false);
            }
            return false;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void dispose() {
        if (this.accessory != null) {
            if (this.preview != null) {
                this.preview.dispose();
            }
            this.preview = null;
            this.accessory = null;
        }
    }

    public void addChoosableFileFilter(JFileChooser chooser) {
        chooser.addChoosableFileFilter((FileFilter)((Object)this));
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        JFileChooser chooser = null;
        super.propertyChange(e);
        if (this.preview != null) {
            this.preview.propertyChange(e);
        }
        if (!(e.getSource() instanceof JFileChooser)) {
            return;
        }
        chooser = (JFileChooser)e.getSource();
        if (prop.equals("fileViewChanged") || prop.equals("ChoosableFileFilterChangedProperty") || prop.equals("directoryChanged") || prop.equals("SelectedFileChangedProperty") || prop.equals("SelectedFilesChangedProperty")) {
            File file2;
            this.files = chooser.getSelectedFiles();
            if ((this.files == null || this.files.length == 0) && (file2 = chooser.getSelectedFile()) != null) {
                this.files = new File[1];
                this.files[0] = file2;
            }
            HashSet<File> current = new HashSet<File>(this.files.length);
            for (int i = 0; i < this.files.length; ++i) {
                current.add(this.files[i]);
            }
            HashSet added = (HashSet)current.clone();
            HashSet removed = (HashSet)this.oldFileSet.clone();
            added.removeAll(this.oldFileSet);
            removed.removeAll(current);
            for (File file2 : removed) {
                this.fileList.remove(file2);
            }
            for (File file2 : added) {
                this.fileList.add(file2);
            }
            this.oldFileSet = current;
            if (this.preview != null) {
                this.preview.setVisible(this.files.length <= 1);
            }
            this.orderingPanel.setVisible(this.files.length > 1);
        }
        if (e.getPropertyName().equals("fileFilterChanged")) {
            chooser = (JFileChooser)e.getSource();
            if (e.getNewValue() == this && chooser.getAccessory() != this.getAccessory()) {
                if (chooser.getAccessory() != null) {
                    chooser.getAccessory().setVisible(false);
                }
                chooser.setAccessory(this.getAccessory());
                if (chooser.getAccessory() != null) {
                    chooser.getAccessory().setVisible(true);
                }
                chooser.setMultiSelectionEnabled(false);
                chooser.invalidate();
            } else if (e.getOldValue() == this && chooser.getAccessory() == this.getAccessory()) {
                chooser.getAccessory().setVisible(false);
                chooser.setAccessory(null);
            }
        }
        this.previewPanel.repaint();
    }

    public File[] getFiles() {
        Comparator comparator = null;
        LinkedList newFileList = (LinkedList)this.fileList.clone();
        if (!this.selectedOrder.isSelected()) {
            if (this.alphaOrder.isSelected()) {
                comparator = new AlphaFileComparator();
            }
            if (this.numericOrder.isSelected()) {
                comparator = new AlphaNumericFileComparator();
            }
            if (comparator != null) {
                Collections.sort(newFileList, comparator);
            }
        }
        this.files = newFileList.toArray(this.files);
        return this.files;
    }

    class AlphaFileComparator
    implements Comparator {
        AlphaFileComparator() {
        }

        public int compare(Object o1, Object o2) {
            String file1 = ((File)o1).getName().toLowerCase();
            String file2 = ((File)o2).getName().toLowerCase();
            return file1.compareTo(file2);
        }

        @Override
        public boolean equals(Object obj) {
            throw new RuntimeException("attempt to use equals in AlphaFileComparator");
        }
    }

    class AlphaNumericFileComparator
    implements Comparator {
        AlphaNumericFileComparator() {
        }

        public int compare(Object o1, Object o2) {
            int comparison = 0;
            int file1Int = 0;
            int file2Int = 0;
            boolean file1Digits = false;
            boolean file2Digits = false;
            StringBuffer file1Part = new StringBuffer();
            StringBuffer file2Part = new StringBuffer();
            int file1Index = 0;
            int file2Index = 0;
            String file1 = ((File)o1).getName().toLowerCase();
            String file2 = ((File)o2).getName().toLowerCase();
            while (file1Index < file1.length() && file2Index < file2.length()) {
                while (file1Index < file1.length()) {
                    if (!Character.isDigit(file1.charAt(file1Index))) {
                        if (file1Digits) break;
                        file1Part.append(file1.charAt(file1Index));
                    } else {
                        file1Digits = true;
                        file1Int = file1Int * 10 + Character.digit(file1.charAt(file1Index), 10);
                    }
                    ++file1Index;
                }
                while (file2Index < file2.length()) {
                    if (!Character.isDigit(file2.charAt(file2Index))) {
                        if (file2Digits) break;
                        file2Part.append(file2.charAt(file2Index));
                    } else {
                        file2Digits = true;
                        file2Int = file2Int * 10 + Character.digit(file2.charAt(file2Index), 10);
                    }
                    ++file2Index;
                }
                if ((comparison = file1Part.toString().compareTo(file2Part.toString())) != 0) {
                    return comparison;
                }
                if (file1Digits && !file2Digits) {
                    return 1;
                }
                if (file2Digits && !file1Digits) {
                    return -1;
                }
                if (file1Int != file2Int) {
                    return file1Int - file2Int;
                }
                file1Int = 0;
                file2Int = 0;
                file1Digits = false;
                file2Digits = false;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            throw new RuntimeException("attempt to use equals in AlphaNumericFileComparator");
        }
    }
}

