/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.groupware.imps.ImageAcceptAPI;
import com.elluminate.groupware.imps.ImageAcceptAccessibleListener;
import com.elluminate.groupware.imps.ImageAcceptData;
import com.elluminate.groupware.whiteboard.AccessibleChangeListener;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.module.FileUtils;
import com.elluminate.groupware.whiteboard.module.StringsProperties;
import com.elluminate.groupware.whiteboard.module.ui.ControllerPane;
import com.elluminate.groupware.whiteboard.module.ui.ScreenGotoListener;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.BackgroundTool;
import com.elluminate.groupware.whiteboard.tools.ImageToolModel;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashSet;

public class ImageAcceptIMPS
implements AccessibleChangeListener,
ImageAcceptAPI,
ScreenGotoListener {
    private static final I18n i18n = I18n.create((Object)new Object(){});
    private WhiteboardContext context;
    private boolean addedListener = false;
    private HashSet publishListeners = new HashSet();

    public ImageAcceptIMPS(WhiteboardContext context) {
        this.context = context;
        context.addAccessibleChangeListener((AccessibleChangeListener)this);
    }

    public String getProvider() {
        return i18n.getString((PropertiesEnum)StringsProperties.IMAGEACCEPTIMPS_NAME);
    }

    public byte getTier() {
        return 32;
    }

    public boolean isAccessible(int insertionMode) {
        if (!this.addedListener && this.context.getController() != null) {
            ControllerPane pane = (ControllerPane)this.context.getController();
            pane.getCanvas().addScreenGotoListener(this);
            this.addedListener = true;
        }
        try {
            boolean isAccessible = this.context.isAccessible();
            if (insertionMode != 8) {
                isAccessible &= this.context.getController().getScreen().canCreate();
            }
            return isAccessible;
        }
        catch (Exception e) {
            return false;
        }
    }

    public ImageAcceptData setImage(Component component, String name, ImageAcceptData acceptData) {
        ImageAcceptData data = null;
        try {
            int width = component.getSize().width;
            int height = component.getSize().height;
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            component.paint(g);
            g.dispose();
            data = this.setImage(image, name, acceptData);
            image.flush();
        }
        catch (Throwable t) {
            if (data == null) {
                data = new ImageAcceptData();
            }
            data.setException(t);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageAcceptData setImage(Image image, String name, ImageAcceptData acceptData) {
        try {
            this.context.getDataExporter().blockCodecs();
            ImageAcceptData imageAcceptData = this.setImageLocal(image, name, acceptData);
            return imageAcceptData;
        }
        catch (Throwable t) {
            if (acceptData == null) {
                acceptData = new ImageAcceptData();
            }
            acceptData.setException(t);
        }
        finally {
            this.context.getDataExporter().unblockCodecs();
        }
        return acceptData;
    }

    private ImageAcceptData setImageLocal(Image image, String name, ImageAcceptData acceptData) throws Exception {
        ScreenModel screen = null;
        BackgroundTool background = null;
        ImageToolModel imageTool = null;
        if (!this.isAccessible(acceptData.getInsertionMode())) {
            throw new Exception(i18n.getString((PropertiesEnum)StringsProperties.IMAGEACCEPTIMPS_NOTACCESSIBLE));
        }
        if (acceptData == null) {
            acceptData = new ImageAcceptData(1, 0, 2);
        } else {
            if (acceptData.getScreenId() != null) {
                screen = (ScreenModel)this.context.getObjectManager().getObjectFromMap(acceptData.getScreenId());
            }
            if (acceptData.getBackgroundId() != null) {
                background = (BackgroundTool)this.context.getObjectManager().getObjectFromMap(acceptData.getBackgroundId());
            }
            if (acceptData.getImageId() != null) {
                imageTool = (ImageToolModel)this.context.getObjectManager().getObjectFromMap(acceptData.getImageId());
            }
        }
        if (acceptData.getWidth() <= 0) {
            acceptData.setWidth(image.getWidth(null));
        }
        if (acceptData.getHeight() <= 0) {
            acceptData.setHeight(image.getHeight(null));
        }
        if (acceptData.getWidth() < 50) {
            acceptData.setWidth(50);
            acceptData.setSizeMode((byte)0);
        }
        if (acceptData.getHeight() < 50) {
            acceptData.setHeight(50);
            acceptData.setSizeMode((byte)0);
        }
        Dimension screenSize = new Dimension(this.context.getController().getScreen().getScreenSize());
        if (screenSize.width < 50) {
            screenSize.width = 1014;
        }
        if (screenSize.height < 50) {
            screenSize.height = 835;
        }
        double maxWidth = 4200.0;
        double maxHeight = 4200.0;
        double minWidth = 50.0;
        double minHeight = 50.0;
        switch (acceptData.getSizeMode()) {
            case 0: {
                maxWidth = screenSize.width;
                maxHeight = screenSize.height;
                minWidth = maxWidth;
                minHeight = maxHeight;
                break;
            }
            case 1: {
                maxWidth = Math.max(acceptData.getWidth(), 50);
                maxHeight = Math.max(acceptData.getHeight(), 50);
                minWidth = maxWidth;
                minHeight = maxHeight;
                break;
            }
            case 3: {
                maxWidth = Math.min(4200, Math.max(acceptData.getWidth(), 50));
                maxHeight = Math.min(4200, Math.max(acceptData.getHeight(), 50));
                break;
            }
            case 2: {
                minWidth = Math.max(acceptData.getWidth(), 50);
                minHeight = Math.max(acceptData.getHeight(), 50);
                break;
            }
            default: {
                throw new Exception(i18n.getString((PropertiesEnum)StringsProperties.IMAGEACCEPTIMPS_INVALIDSIZEMODE));
            }
        }
        int imageWidth = image.getWidth(null);
        double width = imageWidth;
        int imageHeight = image.getHeight(null);
        double height = imageHeight;
        double xScale = maxWidth / width;
        double yScale = maxHeight / height;
        double scale = Math.min(xScale, yScale);
        int spaceLeft = this.context.getMediaCache().spaceRemaining((int)(width * height * scale));
        if (spaceLeft < 0) {
            throw new Exception(i18n.getString((PropertiesEnum)StringsProperties.IMAGEACCEPTIMPS_CACHEFULLEXCEPTION, new Object[]{new Double(-spaceLeft)}));
        }
        if (width > maxWidth || height > maxHeight) {
            image = image.getScaledInstance((int)(width * scale), (int)(height * scale), 4);
        }
        int insertionMode = acceptData.getInsertionMode();
        switch (insertionMode) {
            case 5: 
            case 6: {
                if (background != null) break;
                insertionMode = 1;
                break;
            }
            case 4: {
                if (screen != null) break;
                insertionMode = 1;
                break;
            }
            case 7: {
                if (screen == null) {
                    screen = ActionUtilities.newScreen((WhiteboardContext)this.context, (int)1, (int)1, (boolean)false);
                }
                if (image != null && imageTool != null) break;
                insertionMode = 8;
                break;
            }
        }
        switch (insertionMode) {
            case 1: {
                screen = this.createScreen(image, name, 1, acceptData);
                background = ActionUtilities.getFirstBackground((ScreenModel)screen);
                imageTool = (ImageToolModel)background.getToolAt(background.getToolCount() - 1);
                break;
            }
            case 3: {
                screen = this.createScreen(image, name, ActionUtilities.SUBTOPIC, acceptData);
                background = ActionUtilities.getFirstBackground((ScreenModel)screen);
                imageTool = (ImageToolModel)background.getToolAt(background.getToolCount() - 1);
                break;
            }
            case 2: {
                screen = this.createScreen(image, name, 2, acceptData);
                background = ActionUtilities.getFirstBackground((ScreenModel)screen);
                imageTool = (ImageToolModel)background.getToolAt(background.getToolCount() - 1);
                break;
            }
            case 0: {
                screen = this.createScreen(image, name, 4, acceptData);
                background = ActionUtilities.getFirstBackground((ScreenModel)screen);
                imageTool = (ImageToolModel)background.getToolAt(background.getToolCount() - 1);
                break;
            }
            case 6: {
                imageTool = FileUtils.createImageTool(this.context, image, name);
                background.add((WBNode)imageTool);
                screen = background.getScreenParent();
                break;
            }
            case 5: {
                BackgroundTool newBackground = FileUtils.createBackground(this.context, new Image[]{image}, new String[]{name});
                this.replaceTool((AbstractToolModel)background, (AbstractToolModel)newBackground);
                background = newBackground;
                screen = background.getScreenParent();
                imageTool = (ImageToolModel)background.getToolAt(background.getToolCount() - 1);
                break;
            }
            case 4: {
                ScreenModel newScreen = this.createScreen(image, name);
                this.replaceScreen(screen, newScreen);
                screen = newScreen;
                background = ActionUtilities.getFirstBackground((ScreenModel)screen);
                imageTool = (ImageToolModel)background.getToolAt(background.getToolCount() - 1);
                break;
            }
            case 7: {
                ImageToolModel newImageTool = FileUtils.createImageTool(this.context, image, name);
                screen = imageTool.getScreenParent();
                this.replaceTool((AbstractToolModel)imageTool, (AbstractToolModel)newImageTool);
                imageTool = newImageTool;
                background = ActionUtilities.getFirstBackground((ScreenModel)screen);
                break;
            }
            case 8: {
                imageTool = FileUtils.createImageTool(this.context, image, name);
                screen = this.context.getController().getScreen();
                screen = this.validateScreen(screen, image, name, acceptData);
                screen.insert((WBNode)imageTool, screen.getForegroundToolCount());
                screen = imageTool.getScreenParent();
                background = ActionUtilities.getFirstBackground((ScreenModel)screen);
                break;
            }
            default: {
                throw new Exception(i18n.getString((PropertiesEnum)StringsProperties.IMAGEACCEPTIMPS_INVALIDINSERTIONMODE));
            }
        }
        screenSize = new Dimension(screen.getScreenSize());
        if (image.getWidth(null) != screenSize.width || image.getHeight(null) != screenSize.height) {
            int x = 0;
            int y = 0;
            switch (acceptData.getOrientationMode()) {
                case 0: {
                    x = (screenSize.width - imageWidth) / 2;
                    y = (screenSize.height - imageHeight) / 2;
                    break;
                }
                case 9: {
                    x = 0;
                    y = (screenSize.height - imageHeight) / 2;
                    break;
                }
                case 4: {
                    x = screenSize.width - imageWidth;
                    y = (screenSize.height - imageHeight) / 2;
                    break;
                }
                case 6: {
                    x = (screenSize.width - imageWidth) / 2;
                    y = screenSize.height - imageHeight;
                    break;
                }
                case 7: {
                    x = 0;
                    y = (screenSize.height - imageHeight) / 2;
                    break;
                }
                case 5: {
                    x = screenSize.width - imageWidth;
                    y = (screenSize.height - imageHeight) / 2;
                    break;
                }
                case 2: {
                    x = (screenSize.width - imageWidth) / 2;
                    y = 0;
                    break;
                }
                case 3: {
                    x = screenSize.width - imageWidth;
                    y = 0;
                    break;
                }
                case 1: {
                    x = 0;
                    y = 0;
                    break;
                }
                default: {
                    throw new Exception(i18n.getString((PropertiesEnum)StringsProperties.IMAGEACCEPTIMPS_INVALIDORIENTATIONMODE));
                }
            }
            imageTool.setLocation((double)x, (double)y);
        }
        acceptData.setImageId(imageTool.getObjectID());
        if (background != null) {
            acceptData.setBackgroundId(background.getObjectID());
        }
        acceptData.setScreenId(screen.getObjectID());
        acceptData.setWidth(imageTool.getSize().getIntSize().width);
        acceptData.setHeight(imageTool.getSize().getIntSize().height);
        acceptData.setSuccess(true);
        if (screen != this.context.getController().getScreen()) {
            this.deferredGoTo(screen);
        }
        return acceptData;
    }

    private void deferredGoTo(final ScreenModel screen) {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ImageAcceptIMPS.this.context.getController() != null) {
                    ImageAcceptIMPS.this.context.getController().gotoUIScreen(screen.getObjectID(), false);
                }
            }
        });
    }

    private void replaceTool(AbstractToolModel oldTool, AbstractToolModel newTool) {
        WBNode parentNode = oldTool.getParent();
        int index = parentNode.getIndex((WBNode)oldTool);
        ActionUtilities.deleteTool((AbstractToolModel)oldTool, (WhiteboardContext)this.context);
        parentNode.insert((WBNode)newTool, index);
    }

    private void replaceScreen(ScreenModel oldScreen, ScreenModel newScreen) {
        WBNode parentNode = oldScreen.getParent();
        int index = parentNode.getIndex((WBNode)oldScreen);
        ActionUtilities.deleteScreen((ScreenModel)oldScreen, (WhiteboardContext)this.context);
        parentNode.insert((WBNode)newScreen, index);
    }

    private ScreenModel validateScreen(ScreenModel currentScreen, Image image, String name, ImageAcceptData acceptData) throws Exception {
        if (currentScreen == null || currentScreen instanceof ScreenRoot) {
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            ScreenModel screen = ActionUtilities.newScreen((WhiteboardContext)this.context, (int)1, (int)1, (boolean)false);
            if (screen != null) {
                screen.setScreenNameFromUi(name);
                Dimension dim = new Dimension(width, height);
                switch (acceptData.getSizeMode()) {
                    case 2: 
                    case 3: {
                        dim.setSize(width, height);
                        screen.setScreenSize(dim);
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 1: {
                        screen.setScreenSize(dim);
                    }
                }
            }
            if (screen == null) {
                throw new Exception(i18n.getString((PropertiesEnum)StringsProperties.IMAGEACCEPTIMPS_CANNOTCREATESCREEN));
            }
            if (currentScreen instanceof ScreenRoot) {
                currentScreen.add((WBNode)screen);
            }
            return screen;
        }
        return currentScreen;
    }

    private ScreenModel createScreen(Image image, String name, int mode, ImageAcceptData acceptData) throws Exception {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BackgroundTool background = FileUtils.createBackground(this.context, new Image[]{image}, new String[]{name});
        ImageToolModel imageTool = (ImageToolModel)background.getToolAt(background.getToolCount() - 1);
        ScreenModel screen = ActionUtilities.newScreen((WhiteboardContext)this.context, (int)1, (int)1, (boolean)false);
        if (background != null && screen != null) {
            screen.setScreenNameFromUi(name);
            Dimension dim = new Dimension(background.getIntSize().width, background.getIntSize().height);
            switch (acceptData.getSizeMode()) {
                case 2: 
                case 3: {
                    dim.setSize(width, height);
                    screen.setScreenSize(dim);
                    break;
                }
                case 0: {
                    break;
                }
                case 1: {
                    screen.setScreenSize(dim);
                }
            }
            screen.add((WBNode)background);
        }
        if (screen == null) {
            throw new Exception(i18n.getString((PropertiesEnum)StringsProperties.IMAGEACCEPTIMPS_CANNOTCREATESCREEN));
        }
        return screen;
    }

    private ScreenModel createScreen(Image image, String name) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BackgroundTool background = FileUtils.createBackground(this.context, new Image[]{image}, new String[]{name});
        ImageToolModel imageTool = (ImageToolModel)background.getToolAt(background.getToolCount() - 1);
        ScreenModel screen = new ScreenModel(name, this.context);
        if (background != null && screen != null) {
            Dimension dim = new Dimension(background.getIntSize().width, background.getIntSize().height);
            if (dim.width > screen.getScreenSize().width || dim.height > screen.getScreenSize().height) {
                screen.setScreenSize(dim);
            }
            screen.add((WBNode)background);
        }
        return screen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccessibleListener(ImageAcceptAccessibleListener l) {
        HashSet hashSet = this.publishListeners;
        synchronized (hashSet) {
            this.publishListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccessibleListener(ImageAcceptAccessibleListener l) {
        HashSet hashSet = this.publishListeners;
        synchronized (hashSet) {
            this.publishListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAccessibleListeners() {
        Object[] listeners;
        HashSet hashSet = this.publishListeners;
        synchronized (hashSet) {
            listeners = this.publishListeners.toArray();
        }
        for (int i = 0; i < listeners.length; ++i) {
            try {
                ((ImageAcceptAccessibleListener)listeners[i]).onAccessChange();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onAccessibleChange(boolean accessible) {
        this.fireAccessibleListeners();
    }

    @Override
    public void onScreenGoto(ScreenModel oldScreen, ScreenModel newScreen) {
        this.fireAccessibleListeners();
    }
}

