/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.GoToNextWhiteboardScreenCommand;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.module.StringsProperties;
import com.elluminate.groupware.whiteboard.module.WhiteboardBean;
import com.elluminate.groupware.whiteboard.module.WhiteboardModule;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;

public class GoToNextWhiteboardScreenCmd
extends AbstractCommand
implements GoToNextWhiteboardScreenCommand {
    private boolean withinCurrentTopic = true;
    @Inject
    private I18n i18n;
    @Inject
    private WhiteboardModule whiteboardModule;

    protected WhiteboardBean getWhiteboardBean() {
        return this.whiteboardModule != null ? this.whiteboardModule.getWhiteboardBean() : null;
    }

    public void setWithinCurrentTopic(boolean withinCurrentTopic) {
        this.withinCurrentTopic = withinCurrentTopic;
    }

    public void doexecute() throws CommandExecutionException {
        ScreenModel next;
        WhiteboardBean bean;
        block8: {
            bean = this.getWhiteboardBean();
            if (this.isOnline() && bean.getContext().getController().isFollowInstructorSelected()) {
                this.validateIsChair();
            }
            ScreenModel cur = bean.getContext().getController().getScreen();
            next = null;
            if (!this.withinCurrentTopic && cur.getRealScreenCount() != 0) {
                for (int i = 0; i < cur.getScreenCount(); ++i) {
                    if (!(cur.getScreenAt(i) instanceof ScreenModel)) continue;
                    next = (ScreenModel)cur.getScreenAt(i);
                    break;
                }
            } else {
                int index;
                ScreenModel p;
                ScreenModel scr = cur;
                while (!((p = scr.getScreenParent()) == null || (index = p.getIndex((WBNode)scr)) == -1 || index >= p.getScreenCount() - 1 && this.withinCurrentTopic)) {
                    if (index + 1 < p.getScreenCount()) {
                        for (int i = index + 1; i < p.getScreenCount(); ++i) {
                            if (!(p.getScreenAt(i) instanceof ScreenModel)) continue;
                            next = (ScreenModel)p.getScreenAt(i);
                            break block8;
                        }
                        break;
                    }
                    if (this.withinCurrentTopic) continue;
                    scr = p;
                }
            }
        }
        if (next == null) {
            throw new CommandContextException("The current screen is the last screen", this.i18n.getString((PropertiesEnum)StringsProperties.GOTONEXTWHITEBOARDSCREENCMD_BADCONTEXTLASTSCREEN));
        }
        bean.getContext().getController().gotoUIScreen(next.getObjectID(), false);
    }
}

